/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.utils;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.widgets.Display;

class WorkQueue {
    private boolean updateScheduled = false;
    private LinkedList<Runnable> pendingWork = new LinkedList();
    private Realm d;
    private Set pendingWorkSet = new HashSet();
    private Runnable updateJob = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LinkedList linkedList = WorkQueue.this.pendingWork;
            synchronized (linkedList) {
                WorkQueue.this.updateScheduled = false;
            }
            Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)Display.getCurrent()), (Runnable)WorkQueue.this.defaultRealmJob);
        }
    };
    private Runnable defaultRealmJob = new Runnable(){

        public void run() {
            WorkQueue.this.doUpdate();
        }
    };

    public WorkQueue(Realm targetDisplay) {
        this.d = targetDisplay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate() {
        long operationStart = System.currentTimeMillis();
        while (true) {
            Runnable next;
            LinkedList<Runnable> linkedList = this.pendingWork;
            synchronized (linkedList) {
                long currentTime;
                if (this.pendingWork.isEmpty()) {
                    break;
                }
                if (!this.updateScheduled) {
                    this.updateScheduled = true;
                    this.d.asyncExec(this.updateJob);
                }
                if ((currentTime = System.currentTimeMillis()) - operationStart > 100L) {
                    break;
                }
                next = this.pendingWork.removeFirst();
                this.pendingWorkSet.remove(next);
            }
            try {
                next.run();
            }
            catch (RuntimeException e) {
                StatusUtil.log((Object)this, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOnce(Runnable work) {
        LinkedList<Runnable> linkedList = this.pendingWork;
        synchronized (linkedList) {
            if (this.pendingWorkSet.contains(work)) {
                return;
            }
            this.pendingWorkSet.add(work);
            this.asyncExec(work);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable work) {
        LinkedList<Runnable> linkedList = this.pendingWork;
        synchronized (linkedList) {
            this.pendingWork.add(work);
            if (!this.updateScheduled) {
                this.updateScheduled = true;
                this.d.asyncExec(this.updateJob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelExec(Runnable toCancel) {
        LinkedList<Runnable> linkedList = this.pendingWork;
        synchronized (linkedList) {
            this.pendingWork.remove(toCancel);
            this.pendingWorkSet.remove(toCancel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        LinkedList<Runnable> linkedList = this.pendingWork;
        synchronized (linkedList) {
            this.pendingWork.clear();
            this.pendingWorkSet.clear();
        }
    }
}

