/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.utils;

import com.ibm.team.repository.rcp.ui.internal.RepositoryUiPlugin;
import com.ibm.team.repository.rcp.ui.internal.utils.AdapterCache;
import com.ibm.team.repository.rcp.ui.internal.utils.StandardActionFilterFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.IActionFilter;

public class StandardActionFilter
implements IActionFilter {
    private static StandardActionFilter instance;
    private AdapterCache cache = new AdapterCache();
    private static IAdapterFactory factory;

    public static StandardActionFilter getInstance() {
        if (instance == null) {
            instance = new StandardActionFilter();
        }
        return instance;
    }

    public static void register(Class[] types) {
        int i = 0;
        while (i < types.length) {
            Class class1 = types[i];
            StandardActionFilter.register(class1);
            ++i;
        }
    }

    public static void unregister(Class[] types) {
        int i = 0;
        while (i < types.length) {
            Class class1 = types[i];
            StandardActionFilter.unregister(class1);
            ++i;
        }
    }

    public static void register(Class type) {
        Platform.getAdapterManager().registerAdapters(StandardActionFilter.getFactory(), type);
    }

    public static void unregister(Class type) {
        Platform.getAdapterManager().unregisterAdapters(StandardActionFilter.getFactory(), type);
    }

    private static IAdapterFactory getFactory() {
        if (factory == null) {
            factory = new StandardActionFilterFactory();
        }
        return factory;
    }

    public boolean testAttribute(Object target, String name, String value) {
        Collection sel = Collections.singleton(target);
        this.cache.setInput(sel);
        return this.evaluate(name, this.getValue(value));
    }

    private boolean evaluate(String name, Object expectedResult) {
        int bracket = name.indexOf(40);
        if (bracket == -1) {
            return false;
        }
        int closingBracket = name.indexOf(41, bracket);
        if (closingBracket == -1 || closingBracket <= bracket) {
            return false;
        }
        String methodName = name.substring(0, bracket);
        String adapterName = name.substring(bracket + 1, closingBracket);
        if (methodName.equals("hasAdapter")) {
            return this.cache.hasAdapter(adapterName);
        }
        if (methodName.equals("getAdapter")) {
            int methodStart = closingBracket + 2;
            int methodArgsStart = name.indexOf(40, methodStart);
            int methodArgsEnd = name.indexOf(41, methodArgsStart);
            String innerMethod = name.substring(methodStart, methodArgsStart);
            Object[] args = this.parseArgs(name, methodArgsStart + 1, methodArgsEnd);
            Class[] argTypes = StandardActionFilter.getTypes(args);
            Collection adapters = this.cache.getAdapters(adapterName);
            for (Object next : adapters) {
                Class<?> c = next.getClass();
                try {
                    Method toInvoke = c.getMethod(innerMethod, argTypes);
                    Object result = toInvoke.invoke(next, args);
                    if (!Util.equals((Object)result, (Object)expectedResult)) continue;
                    return true;
                }
                catch (Exception e) {
                    RepositoryUiPlugin.log(e);
                }
            }
        }
        return false;
    }

    private static Class[] getTypes(Object[] args) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < args.length) {
            Object next = args[i];
            result.add(next.getClass());
            ++i;
        }
        return result.toArray(new Class[result.size()]);
    }

    private Object[] parseArgs(String string, int start, int end) {
        ArrayList<Object> result = new ArrayList<Object>();
        int idx = start;
        int next = start;
        while (idx < end) {
            next = string.indexOf(44);
            if (next == -1 || next > end) {
                next = end;
            }
            String nextArg = string.substring(idx, next);
            result.add(this.getValue(nextArg));
            idx = next;
        }
        return result.toArray();
    }

    private Object getValue(String nextArg) {
        if (nextArg.equals("true")) {
            return new Boolean(true);
        }
        if (nextArg.equals("false")) {
            return new Boolean(false);
        }
        try {
            int nextInt = Integer.parseInt(nextArg);
            return new Integer(nextInt);
        }
        catch (NumberFormatException numberFormatException) {
            return nextArg;
        }
    }
}

