/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.utils;

import com.ibm.team.repository.rcp.ui.internal.utils.WorkQueue;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SWTUtil {
    private static Map<Realm, WorkQueue> mapDisplayOntoWorkQueue = new HashMap<Realm, WorkQueue>();

    public static List selectionToList(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return ss.toList();
        }
        return Collections.EMPTY_LIST;
    }

    private SWTUtil() {
    }

    public static String filterMnemonics(String withMnemonics) {
        return Action.removeMnemonics((String)withMnemonics);
    }

    public static void matchBackground(Control toSetBackground) {
        toSetBackground.setBackground(toSetBackground.getParent().getBackground());
    }

    public static void greedyExec(Display d, Runnable r) {
        if (d.isDisposed()) {
            return;
        }
        SWTUtil.greedyExec(SWTObservables.getRealm((Display)d), r);
    }

    public static void greedyExec(Display d, Control c, Runnable r) {
        SWTUtil.greedyExec(d, (Runnable)new ControlRunnable(c, r));
    }

    public static void runOnce(Display d, Control c, Runnable r) {
        SWTUtil.runOnce(d, (Runnable)new ControlRunnable(c, r));
    }

    public static void runOnce(Display d, Runnable r) {
        if (d.isDisposed()) {
            return;
        }
        SWTUtil.runOnce(SWTObservables.getRealm((Display)d), r);
    }

    public static void runOnce(Realm realm, Runnable r) {
        WorkQueue queue = SWTUtil.getQueueFor(realm);
        queue.runOnce(r);
    }

    public static void cancelExec(Display d, Runnable r) {
        if (d.isDisposed()) {
            return;
        }
        SWTUtil.cancelExec(SWTObservables.getRealm((Display)d), r);
    }

    public static void cancelExec(Realm realm, Runnable r) {
        WorkQueue queue = SWTUtil.getQueueFor(realm);
        queue.cancelExec(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WorkQueue getQueueFor(Realm d) {
        Map<Realm, WorkQueue> map = mapDisplayOntoWorkQueue;
        synchronized (map) {
            WorkQueue result = mapDisplayOntoWorkQueue.get(d);
            if (result == null) {
                result = new WorkQueue(d);
                mapDisplayOntoWorkQueue.put(d, result);
            }
            return result;
        }
    }

    public static ColumnPosition mapColumn(Table table, Point p) {
        int x = table.getDisplay().map(null, (Control)table, (int)p.x, (int)p.y).x;
        int scrollPosition = table.getHorizontalBar().getSelection();
        x += scrollPosition;
        TableColumn[] columns = table.getColumns();
        int[] currentOrder = table.getColumnOrder();
        int startPos = 0;
        int i = 0;
        while (i < columns.length) {
            if (x < startPos + columns[currentOrder[i]].getWidth()) {
                ColumnPosition pos = new ColumnPosition();
                pos.creationIndex = currentOrder[i];
                pos.offset = startPos;
                pos.currentIndex = i;
                return pos;
            }
            startPos += columns[currentOrder[i]].getWidth();
            ++i;
        }
        return null;
    }

    public static RGB[] chooseContrastingColors(RGB originalColor, int numberOfDesiredColors) {
        float[] hsb = originalColor.getHSB();
        float h0 = hsb[0];
        float s0 = hsb[1];
        float cfr_ignored_0 = hsb[2];
        float b1 = 0.5f;
        float hrange = 180.0f + (1.0f - s0) * 180.0f;
        float hstart = h0 + 180.0f;
        float hincrement = hrange / (float)numberOfDesiredColors;
        RGB[] result = new RGB[numberOfDesiredColors];
        int count = 0;
        while (count < numberOfDesiredColors) {
            RGB nextRGB;
            float nextHue = hstart + (float)count * hincrement;
            while (nextHue >= 360.0f) {
                nextHue -= 360.0f;
            }
            result[count] = nextRGB = new RGB(nextHue, 1.0f, b1);
            ++count;
        }
        return result;
    }

    public static RGB mix(RGB rgb1, RGB rgb2, double ratio) {
        return new RGB(SWTUtil.interp(rgb1.red, rgb2.red, ratio), SWTUtil.interp(rgb1.green, rgb2.green, ratio), SWTUtil.interp(rgb1.blue, rgb2.blue, ratio));
    }

    private static int interp(int i1, int i2, double ratio) {
        int result = (int)((double)i1 * ratio + (double)i2 * (1.0 - ratio));
        if (result < 0) {
            result = 0;
        }
        if (result > 255) {
            result = 255;
        }
        return result;
    }

    public static Rectangle getDisplayBounds(Control parent) {
        if (parent.getParent() == null) {
            return parent.getBounds();
        }
        return Geometry.toDisplay((Control)parent.getParent(), (Rectangle)parent.getBounds());
    }

    public static RGB getContrastingColor(RGB toContrast) {
        return new RGB(SWTUtil.getContrast(toContrast.red), SWTUtil.getContrast(toContrast.green), SWTUtil.getContrast(toContrast.blue));
    }

    public static int getContrast(int component) {
        if (component < 128) {
            return 200;
        }
        return 10;
    }

    public static void greedyExec(Realm realm, Runnable runnable) {
        WorkQueue queue = SWTUtil.getQueueFor(realm);
        queue.asyncExec(runnable);
    }

    public static class ColumnPosition {
        public int creationIndex;
        public int currentIndex;
        public int offset;
    }

    private static final class ControlRunnable
    implements Runnable {
        private Control theControl;
        private Runnable r;

        public ControlRunnable(Control theControl, Runnable r) {
            this.theControl = theControl;
            this.r = r;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ControlRunnable) {
                ControlRunnable other = (ControlRunnable)obj;
                return other.theControl == this.theControl && other.r.equals(this.r);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.theControl.hashCode() + this.r.hashCode();
        }

        public void run() {
            if (!this.theControl.isDisposed()) {
                this.r.run();
            }
        }
    }
}

