/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.utils;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.rcp.core.preferences.StringStore;
import com.ibm.team.repository.rcp.core.preferences.StringStoreToPreferencesAdapter;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.RepositoryUiPlugin;
import com.ibm.team.repository.rcp.ui.internal.utils.MementoStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MementoUtil {
    public static final String FACTORY_ID = "InputUtil.factoryID";

    private MementoUtil() {
    }

    public static Preferences getPreferencesFor(IMemento toConvert) {
        return new StringStoreToPreferencesAdapter((StringStore)new MementoStore(toConvert));
    }

    public static float getFloat(IMemento memento, String key) throws CoreException {
        Float result = memento.getFloat(key);
        if (result == null) {
            MementoUtil.missingKeyException(key);
        }
        return result.floatValue();
    }

    public static int getInt(IMemento memento, String key) throws CoreException {
        Integer result = memento.getInteger(key);
        if (result == null) {
            MementoUtil.missingKeyException(key);
        }
        return result;
    }

    public static String getString(IConfigurationElement memento, String key) throws CoreException {
        String result = memento.getAttribute(key);
        if (result == null) {
            MementoUtil.missingKeyException(key);
        }
        return result;
    }

    public static String getString(IMemento memento, String key) throws CoreException {
        String result = memento.getString(key);
        if (result == null) {
            MementoUtil.missingKeyException(key);
        }
        return result;
    }

    public static float getFloat(IMemento memento, String key, float defaultValue) {
        Float f = memento.getFloat(key);
        if (f == null) {
            return defaultValue;
        }
        return f.floatValue();
    }

    public static int getInt(IMemento memento, String key, int defaultValue) {
        Integer integer = memento.getInteger(key);
        if (integer == null) {
            return defaultValue;
        }
        return integer;
    }

    public static String getString(IMemento memento, String key, String defaultValue) {
        String value = memento.getString(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static void saveChild(IMemento parentMemento, String childId, Object toSave) {
        IMemento child = parentMemento.createChild(childId);
        MementoUtil.saveState(child, toSave);
    }

    public static <T> T loadRequiredChild(IMemento parentMemento, String childId, Class<T> expectedClass) throws CoreException {
        IMemento child = parentMemento.getChild(childId);
        if (child == null) {
            throw new CoreException(StatusUtil.newStatus(MementoUtil.class, (String)("Missing required element " + childId)));
        }
        return MementoUtil.loadState(child, expectedClass);
    }

    public static <T> T loadChild(IMemento parentMemento, String childId, Class<T> expectedClass, T defaultResult) throws CoreException {
        IMemento child = parentMemento.getChild(childId);
        if (child == null) {
            return defaultResult;
        }
        return MementoUtil.loadState(child, expectedClass);
    }

    public static void saveState(IMemento whereToSave, Object toSave) {
        if (toSave == null) {
            whereToSave.putString(FACTORY_ID, "null");
            return;
        }
        IPersistableElement element = (IPersistableElement)Adapters.getAdapter((Object)toSave, IPersistableElement.class);
        if (element == null) {
            StatusUtil.log(MementoUtil.class, (String)NLS.bind((String)"Object {0} is not adaptable to {1}", (Object)toSave.toString(), (Object)IPersistableElement.class.getName()));
            return;
        }
        element.saveState(whereToSave);
        whereToSave.putString(FACTORY_ID, element.getFactoryId());
    }

    public static <T> T loadState(IMemento whereToLoad, Class<T> expectedClass) throws CoreException {
        String factoryId = whereToLoad.getString(FACTORY_ID);
        if (factoryId == null) {
            throw new CoreException(StatusUtil.newStatus((Object)RepositoryUiPlugin.PLUGIN_ID, (int)2, (String)"Persistable element is missing factory ID"));
        }
        if (factoryId.equals("null")) {
            return null;
        }
        IElementFactory factory = PlatformUI.getWorkbench().getElementFactory(factoryId);
        if (factory != null) {
            IAdaptable result = factory.createElement(whereToLoad);
            if (result == null) {
                throw new CoreException(StatusUtil.newStatus((Object)RepositoryUiPlugin.PLUGIN_ID, (int)2, (String)NLS.bind((String)"Persistable element factory {0} returned null", (Object)factoryId)));
            }
            Object adaptedResult = result.getAdapter(expectedClass);
            if (adaptedResult == null) {
                throw new CoreException(StatusUtil.newStatus((Object)RepositoryUiPlugin.PLUGIN_ID, (int)2, (String)NLS.bind((String)"Persistable element {0} is not adaptable to {1}", (Object)result.getClass().getName(), (Object)expectedClass.getName())));
            }
            return (T)adaptedResult;
        }
        throw new CoreException(StatusUtil.newStatus((Object)RepositoryUiPlugin.PLUGIN_ID, (int)2, (String)NLS.bind((String)"Invalid persistable element factory: {0}", (Object)factoryId)));
    }

    private static void missingKeyException(String key) throws CoreException {
        throw new CoreException(StatusUtil.newStatus((Object)RepositoryUiPlugin.PLUGIN_ID, (String)NLS.bind((String)"Missing required key {0}", (Object)key)));
    }

    public static <T> List<T> loadList(IMemento memento, String attributeId, Class<T> elementType) throws CoreException {
        IMemento next;
        ArrayList<T> result = new ArrayList<T>();
        IMemento[] children = memento.getChildren(attributeId);
        HashMap<String, IMemento> idsToMementos = new HashMap<String, IMemento>();
        int i = 0;
        while (i < children.length) {
            next = children[i];
            idsToMementos.put(next.getID(), next);
            ++i;
        }
        int idx = 0;
        while ((next = (IMemento)idsToMementos.get("" + idx)) != null) {
            result.add(MementoUtil.loadState(next, elementType));
            ++idx;
        }
        return result;
    }

    public static <T> void saveList(IMemento memento, String attributeId, List<T> elements) {
        int idx = 0;
        for (T next : elements) {
            IMemento nextMemento = memento.createChild(attributeId, "" + idx);
            MementoUtil.saveState(nextMemento, next);
            ++idx;
        }
    }

    public static void putBoolean(IMemento memento, String key, boolean selection) {
        memento.putString(key, selection ? "true" : "false");
    }

    public static boolean getBoolean(IMemento memento, String key, boolean defaultValue) {
        String result = memento.getString(key);
        if (result == null) {
            return defaultValue;
        }
        return result.equals("true");
    }
}

