/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.utils;

import com.ibm.team.repository.rcp.ui.internal.utils.CompositeLayoutInfo;
import com.ibm.team.repository.rcp.ui.internal.utils.ISizeListener;
import com.ibm.team.repository.rcp.ui.internal.utils.ISizeProvider;
import com.ibm.team.repository.rcp.ui.internal.utils.ShellLayoutInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;

class LayoutInfo {
    public static final int FLAG_OFFSET_KNOWN = 4;
    public static final int FLAG_PREFERRED_SIZE_KNOWN = 8;
    public static final int FLAG_MAX_WIDTH_KNOWN = 16;
    public static final int FLAG_MIN_WIDTH_KNOWN = 32;
    public static final int FLAG_MAX_HEIGHT_KNOWN = 64;
    public static final int FLAG_MIN_HEIGHT_KNOWN = 128;
    public static final int SIZE_FLAGS = 12;
    int flags = 0;
    int offsetX = 0;
    int offsetY = 0;
    int preferredX = 0;
    int preferredY = 0;
    int maxWidthConstraint = 0;
    int maxWidthResult = 0;
    int maxHeightConstraint = 0;
    int maxHeightResult = 0;
    int minWidthConstraint = 0;
    int minWidthResult = 0;
    int minHeightConstraint = 0;
    int minHeightResult = 0;
    int widthAtLastChange = 0;
    int heightAtLastChange = 0;
    Control theControl = null;
    private static final String INFO_KEY = LayoutInfo.class.getName();
    private List sizeListeners = null;

    public static LayoutInfo getInfo(Control toQuery) {
        LayoutInfo info = (LayoutInfo)toQuery.getData(INFO_KEY);
        if (info == null) {
            info = toQuery instanceof Shell ? new ShellLayoutInfo((Shell)toQuery) : (toQuery instanceof Composite ? new CompositeLayoutInfo((Composite)toQuery) : new LayoutInfo(toQuery));
            toQuery.setData(INFO_KEY, (Object)info);
        }
        return info;
    }

    public static CompositeLayoutInfo getCompositeInfo(Composite toQuery) {
        return (CompositeLayoutInfo)LayoutInfo.getInfo((Control)toQuery);
    }

    public static ShellLayoutInfo getShellInfo(Composite toQuery) {
        return (ShellLayoutInfo)LayoutInfo.getInfo((Control)toQuery);
    }

    public LayoutInfo(Control theControl) {
        this.theControl = theControl;
    }

    public void addSizeListener(ISizeListener l) {
        if (this.sizeListeners == null) {
            this.sizeListeners = new ArrayList();
        }
        this.sizeListeners.add(l);
    }

    public void removeSizeListener(ISizeListener l) {
        if (this.sizeListeners == null) {
            return;
        }
        this.sizeListeners.remove(l);
        if (this.sizeListeners.isEmpty()) {
            this.sizeListeners = null;
        }
    }

    public void controlChanged() {
        this.clearFlags(12);
        Composite parent = this.theControl.getParent();
        CompositeLayoutInfo parentInfo = LayoutInfo.getCompositeInfo(parent);
        parentInfo.childChanged(this.theControl);
        this.notifySizeListeners();
    }

    protected void notifySizeListeners() {
        if (this.sizeListeners != null) {
            for (ISizeListener l : this.sizeListeners) {
                l.controlChanged(this.theControl);
            }
        }
    }

    public int computeMinSize(int constrainedDimension, boolean widthNeeded) {
        int result;
        if (widthNeeded) {
            int result2;
            if (!((this.flags & 0x20) == 0 || this.isWrapping() && this.minWidthConstraint != constrainedDimension)) {
                return this.minWidthResult;
            }
            this.minWidthResult = result2 = this.internalComputeMinSize(constrainedDimension, widthNeeded);
            this.minWidthConstraint = constrainedDimension;
            this.setFlags(32);
            return this.minWidthResult;
        }
        if (!((this.flags & 0x80) == 0 || this.isWrapping() && this.minHeightConstraint != constrainedDimension)) {
            return this.minHeightResult;
        }
        this.minHeightResult = result = this.internalComputeMinSize(constrainedDimension, widthNeeded);
        this.minHeightConstraint = constrainedDimension;
        this.setFlags(128);
        return this.minHeightResult;
    }

    public int computeMaxSize(int constrainedDimension, boolean widthNeeded) {
        int result;
        if (widthNeeded) {
            int result2;
            if (!((this.flags & 0x10) == 0 || this.isWrapping() && this.maxWidthConstraint != constrainedDimension)) {
                return this.maxWidthResult;
            }
            this.maxWidthResult = result2 = this.internalComputeMaxSize(constrainedDimension, widthNeeded);
            this.maxWidthConstraint = constrainedDimension;
            this.setFlags(16);
            return this.maxWidthResult;
        }
        if (!((this.flags & 0x40) == 0 || this.isWrapping() && this.maxHeightConstraint != constrainedDimension)) {
            return this.maxHeightResult;
        }
        this.maxHeightResult = result = this.internalComputeMaxSize(constrainedDimension, widthNeeded);
        this.maxHeightConstraint = constrainedDimension;
        this.setFlags(64);
        return this.maxHeightResult;
    }

    private int internalComputeMaxSize(int constrainedDimension, boolean widthNeeded) {
        if (this.theControl instanceof ISizeProvider) {
            ISizeProvider size = (ISizeProvider)this.theControl;
            return size.computeMaxSize(constrainedDimension, widthNeeded);
        }
        Class<?> clazz = this.theControl.getClass();
        if (clazz == Label.class || clazz == ToolBar.class) {
            return this.computePreferredSize(constrainedDimension, widthNeeded);
        }
        return Integer.MAX_VALUE;
    }

    public int computePreferredSize(int constrainedDimension, boolean widthNeeded) {
        int result;
        int constrainedHint = constrainedDimension;
        constrainedHint = constrainedDimension == Integer.MAX_VALUE ? -1 : Math.max(constrainedHint - this.getCorrection(!widthNeeded), 0);
        if (widthNeeded) {
            Point sz = this.theControl.computeSize(-1, constrainedHint, false);
            result = sz.x;
        } else {
            Point sz = this.theControl.computeSize(constrainedHint, -1, false);
            result = sz.y;
        }
        return result;
    }

    public int getCorrection(boolean width) {
        this.computeInnerOffsetCorrection();
        if (width) {
            return this.offsetX;
        }
        return this.offsetY;
    }

    public Point getPreferredSize() {
        if ((this.flags & 8) != 0) {
            Point preferred = this.theControl.computeSize(-1, -1, false);
            this.preferredX = preferred.x;
            this.preferredY = preferred.y;
            this.setFlags(8);
        }
        return new Point(this.preferredX, this.preferredY);
    }

    protected final void clearFlags(int toClear) {
        this.flags &= ~toClear;
    }

    protected final void setFlags(int toSet) {
        this.flags |= toSet;
    }

    private void computeInnerOffsetCorrection() {
        if ((this.flags & 4) != 0) {
            return;
        }
        Class<?> controlClass = this.theControl.getClass();
        if (controlClass == Composite.class || controlClass == Text.class) {
            Composite c = (Composite)this.theControl;
            Rectangle trim = c.computeTrim(0, 0, 100, 100);
            this.offsetX = trim.width - 100;
            this.offsetY = trim.height - 100;
        } else if (controlClass == Button.class || controlClass == Link.class || controlClass == ProgressBar.class || controlClass == Sash.class || controlClass == Scale.class || controlClass == Slider.class) {
            int border;
            this.offsetX = border = 2 * this.theControl.getBorderWidth();
            this.offsetY = border;
        } else {
            Point result = this.theControl.computeSize(32, 32, false);
            this.offsetX = result.x - 32;
            this.offsetY = result.y - 32;
        }
        this.flags |= 4;
    }

    private boolean isWrapping() {
        Class<?> clazz = this.theControl.getClass();
        if (clazz == Button.class || clazz == ProgressBar.class || clazz == Sash.class || clazz == Scale.class || clazz == Slider.class || clazz == List.class || clazz == Combo.class || clazz == Tree.class) {
            return false;
        }
        if (this.theControl instanceof Label || this.theControl instanceof Text) {
            return (this.theControl.getStyle() & 0x40) != 0;
        }
        return true;
    }

    private int internalComputeMinSize(int constrainedDimension, boolean widthNeeded) {
        if (this.theControl instanceof ISizeProvider) {
            ISizeProvider size = (ISizeProvider)this.theControl;
            return size.computeMinSize(constrainedDimension, widthNeeded);
        }
        if (this.scrollable(widthNeeded)) {
            return 0;
        }
        return this.computePreferredSize(constrainedDimension, widthNeeded);
    }

    private boolean scrollable(boolean widthNeeded) {
        if (this.theControl instanceof Scrollable) {
            Text txt;
            Scrollable control = (Scrollable)this.theControl;
            if (widthNeeded && control instanceof Text && ((txt = (Text)control).getStyle() & 8) != 0) {
                return true;
            }
            if (widthNeeded) {
                return control.getHorizontalBar() != null;
            }
            return control.getVerticalBar() != null;
        }
        return false;
    }
}

