/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.utils;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.RepositoryUiPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFaceUtils {
    public static void showMessage(final String title, final String message, final int severity) {
        IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
        if (page != null) {
            final Shell shell = page.getWorkbenchWindow().getShell();
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    switch (severity) {
                        case 4: {
                            MessageDialog.openError((Shell)shell, (String)title, (String)message);
                            break;
                        }
                        default: {
                            MessageDialog.openWarning((Shell)shell, (String)title, (String)message);
                        }
                    }
                }
            });
        }
    }

    public static void showMessageBlocking(final String title, final String message, final int severity) {
        IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
        if (page != null) {
            final Shell shell = page.getWorkbenchWindow().getShell();
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    switch (severity) {
                        case 4: {
                            MessageDialog.openError((Shell)shell, (String)title, (String)message);
                            break;
                        }
                        default: {
                            MessageDialog.openWarning((Shell)shell, (String)title, (String)message);
                        }
                    }
                }
            });
        }
    }

    public static boolean showMessageBlocking(String title, String message, String[] buttons, int severity) {
        return JFaceUtils.showMessageButtonsBlocking(title, message, buttons, severity) == 0;
    }

    public static int showMessageButtonsBlocking(String title, String message, String[] buttons, int severity) {
        return JFaceUtils.showMessageButtonsBlocking(title, message, buttons, severity, 1);
    }

    public static int showMessageButtonsBlocking(final String title, final String message, final String[] buttons, final int severity, final int defaultButton) {
        final int[] returnValue = new int[1];
        IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
        if (page != null) {
            final Shell shell = page.getWorkbenchWindow().getShell();
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialog messageDialog = new MessageDialog(shell, title, null, message, severity, buttons, defaultButton);
                    returnValue[0] = messageDialog.open();
                }
            });
        }
        return returnValue[0];
    }

    public static void syncExec(final Runnable runnable) {
        IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
        if (page != null) {
            Shell shell = page.getWorkbenchWindow().getShell();
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    runnable.run();
                }
            });
        }
    }

    public static void showError(final String title, final String message, final Throwable e) {
        IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
        if (page != null) {
            final Shell shell = page.getWorkbenchWindow().getShell();
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (e != null) {
                        ErrorDialog.openError((Shell)shell, (String)title, null, (IStatus)StatusUtil.newStatus((Object)RepositoryUiPlugin.PLUGIN_ID, (String)message, (Throwable)e));
                    } else {
                        MessageDialog.openError((Shell)shell, (String)title, (String)message);
                    }
                }
            });
        }
    }

    public static void showError(final String title, final String message, final IStatus status) {
        IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
        if (page != null) {
            final Shell shell = page.getWorkbenchWindow().getShell();
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
                }
            });
        }
    }

    public static IWorkbenchPage getWorkbenchPage() {
        IWorkbenchPage page;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            if (workbench.getWorkbenchWindowCount() > 0) {
                window = workbench.getWorkbenchWindows()[0];
            } else {
                return null;
            }
        }
        if ((page = window.getActivePage()) == null) {
            if (window.getPages().length > 0) {
                page = window.getPages()[0];
            } else {
                return null;
            }
        }
        return page;
    }

    public static <T> T getSelected(TreePath tree, Class<T> desiredClass) {
        int idx = 0;
        while (idx < tree.getSegmentCount()) {
            Object next = tree.getSegment(idx);
            if (desiredClass.isInstance(next)) {
                return (T)next;
            }
            ++idx;
        }
        return null;
    }

    public static <T> List<T> getSelected(ITreeSelection selection, Class<T> desiredClass) {
        TreePath[] paths = selection.getPaths();
        ArrayList<T> result = new ArrayList<T>();
        int i = 0;
        while (i < paths.length) {
            TreePath treePath = paths[i];
            T next = JFaceUtils.getSelected(treePath, desiredClass);
            if (next != null) {
                result.add(next);
            }
            ++i;
        }
        return result;
    }
}

