/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.utils;

import com.ibm.team.repository.rcp.ui.internal.utils.IAffectsSizeProvider;
import com.ibm.team.repository.rcp.ui.internal.utils.LayoutInfo;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import java.util.ArrayList;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CompositeLayoutInfo
extends LayoutInfo {
    private boolean isDirty = false;
    private static ArrayList queuedLayouts = new ArrayList();
    private static Runnable asyncLayoutRunnable = new Runnable(){

        public void run() {
            CompositeLayoutInfo.runDeferredLayouts();
        }
    };

    public CompositeLayoutInfo(Composite control) {
        super((Control)control);
    }

    protected Composite getComposite() {
        return (Composite)this.theControl;
    }

    public void childChanged(Control child) {
        Composite composite = this.getComposite();
        if (CompositeLayoutInfo.affectsSize(composite, child)) {
            composite.changed(new Control[]{child});
            if (!this.isDirty) {
                this.isDirty = true;
                queuedLayouts.add(this);
                composite.setLayoutDeferred(true);
                this.controlChanged();
                composite.layout(false);
                this.scheduleAsyncLayout();
            }
        }
    }

    private void scheduleAsyncLayout() {
        SWTUtil.runOnce(this.theControl.getDisplay(), asyncLayoutRunnable);
    }

    public static void runDeferredLayouts() {
        while (!queuedLayouts.isEmpty()) {
            CompositeLayoutInfo[] dirtyShells = queuedLayouts.toArray(new CompositeLayoutInfo[queuedLayouts.size()]);
            queuedLayouts.clear();
            int i = 0;
            while (i < dirtyShells.length) {
                CompositeLayoutInfo next = dirtyShells[i];
                next.undeferLayouts();
                ++i;
            }
        }
    }

    private void undeferLayouts() {
        if (this.theControl.isDisposed()) {
            return;
        }
        Composite c = this.getComposite();
        this.isDirty = false;
        c.setLayoutDeferred(false);
    }

    private static boolean affectsSize(Composite parent, Control child) {
        GridData data;
        if (parent instanceof IAffectsSizeProvider) {
            IAffectsSizeProvider provider = (IAffectsSizeProvider)parent;
            return provider.affectsSize(child);
        }
        Layout layout = parent.getLayout();
        if (layout instanceof IAffectsSizeProvider) {
            IAffectsSizeProvider provider = (IAffectsSizeProvider)layout;
            return provider.affectsSize(child);
        }
        if (layout instanceof GridLayout ? (data = (GridData)child.getLayoutData()) != null && data.widthHint != -1 && data.heightHint != -1 : layout instanceof FormLayout && (data = (FormData)child.getLayoutData()) != null && data.width != -1 && data.height != -1) {
            return false;
        }
        return layout != null || parent.getClass() != Composite.class && parent.getClass() != ScrolledComposite.class;
    }
}

