/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.tree;

import com.ibm.team.repository.rcp.ui.internal.tree.AbstractObservableSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetDiff;

public final class DelegatingObservableSet
extends AbstractObservableSet {
    private IObservableSet toDelegateTo;
    private ISetChangeListener listener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            SetDiff diff = event.diff;
            DelegatingObservableSet.this.fireSetChange(diff);
        }
    };

    public DelegatingObservableSet(IObservableSet toDelegate) {
        this.toDelegateTo = toDelegate;
        toDelegate.addSetChangeListener(this.listener);
    }

    protected Set getWrappedSet() {
        return this.toDelegateTo;
    }

    public Object getElementType() {
        return this.toDelegateTo.getElementType();
    }

    public void dispose() {
        this.toDelegateTo.removeSetChangeListener(this.listener);
        super.dispose();
    }
}

