/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.tree;

import com.ibm.team.repository.rcp.ui.internal.tree.AbstractObservable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractObservableSet
extends AbstractObservable
implements IObservableSet {
    private boolean stale = false;
    private Realm realm;
    private Object setChangeListeners;

    protected AbstractObservableSet() {
        Assert.isNotNull((Object)Display.getCurrent());
        this.realm = SWTObservables.getRealm((Display)Display.getCurrent());
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void addSetChangeListener(ISetChangeListener listener) {
        ArrayList<ISetChangeListener> listenerList;
        if (this.setChangeListeners == null) {
            boolean hadListeners = this.hasListeners();
            this.setChangeListeners = listener;
            if (!hadListeners) {
                this.firstListenerAdded();
            }
            return;
        }
        if (this.setChangeListeners instanceof Collection) {
            listenerList = (ArrayList<ISetChangeListener>)this.setChangeListeners;
        } else {
            ISetChangeListener l = (ISetChangeListener)this.setChangeListeners;
            listenerList = new ArrayList<ISetChangeListener>();
            listenerList.add(l);
            this.setChangeListeners = listenerList;
        }
        if (listenerList.size() > 16) {
            HashSet<ISetChangeListener> listenerSet = new HashSet<ISetChangeListener>();
            listenerSet.addAll(listenerList);
            this.setChangeListeners = listenerList;
        }
        listenerList.add(listener);
    }

    public void removeSetChangeListener(ISetChangeListener listener) {
        if (this.setChangeListeners == listener) {
            this.setChangeListeners = null;
            if (!this.hasListeners()) {
                this.lastListenerRemoved();
            }
            return;
        }
        if (this.setChangeListeners instanceof Collection) {
            Collection listenerList = (Collection)this.setChangeListeners;
            listenerList.remove(listener);
            if (listenerList.size() == 0) {
                this.setChangeListeners = null;
                if (!this.hasListeners()) {
                    this.lastListenerRemoved();
                }
            }
        }
    }

    protected abstract Set getWrappedSet();

    protected boolean hasListeners() {
        return super.hasListeners() || this.setChangeListeners != null;
    }

    protected void fireSetChange(SetDiff diff) {
        super.fireChange();
        if (this.setChangeListeners == null) {
            return;
        }
        SetChangeEvent event = new SetChangeEvent((IObservableSet)this, diff);
        if (this.setChangeListeners instanceof ISetChangeListener) {
            ((ISetChangeListener)this.setChangeListeners).handleSetChange(event);
            return;
        }
        Collection changeListenerCollection = (Collection)this.setChangeListeners;
        ISetChangeListener[] listeners = changeListenerCollection.toArray(new ISetChangeListener[changeListenerCollection.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].handleSetChange(event);
            ++i;
        }
    }

    public boolean contains(Object o) {
        this.getterCalled();
        return this.getWrappedSet().contains(o);
    }

    public boolean containsAll(Collection c) {
        this.getterCalled();
        return this.getWrappedSet().containsAll(c);
    }

    public boolean equals(Object o) {
        this.getterCalled();
        return this.getWrappedSet().equals(o);
    }

    public int hashCode() {
        this.getterCalled();
        return this.getWrappedSet().hashCode();
    }

    public boolean isEmpty() {
        this.getterCalled();
        return this.getWrappedSet().isEmpty();
    }

    public Iterator iterator() {
        final Iterator wrappedIterator = this.getWrappedSet().iterator();
        return new Iterator(){

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                ObservableTracker.getterCalled((IObservable)AbstractObservableSet.this);
                return wrappedIterator.hasNext();
            }

            public Object next() {
                ObservableTracker.getterCalled((IObservable)AbstractObservableSet.this);
                return wrappedIterator.next();
            }
        };
    }

    public int size() {
        this.getterCalled();
        return this.getWrappedSet().size();
    }

    public Object[] toArray() {
        this.getterCalled();
        return this.getWrappedSet().toArray();
    }

    public Object[] toArray(Object[] a) {
        this.getterCalled();
        return this.getWrappedSet().toArray(a);
    }

    public String toString() {
        this.getterCalled();
        return this.getWrappedSet().toString();
    }

    protected void getterCalled() {
        ObservableTracker.getterCalled((IObservable)this);
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean isStale() {
        return this.stale;
    }

    public void setStale(boolean stale) {
        boolean wasStale = this.stale;
        this.stale = stale;
        if (!wasStale && stale) {
            this.fireStale();
        }
    }

    protected void fireChange() {
        throw new RuntimeException("fireChange should not be called, use fireSetChange() instead");
    }

    public void dispose() {
        this.setChangeListeners = null;
        super.dispose();
    }
}

