/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.StaleEvent;

public abstract class AbstractObservable
implements IObservable {
    private Object changeListeners = null;
    private Object staleListeners = null;

    public void addChangeListener(IChangeListener listener) {
        ArrayList<IChangeListener> listenerList;
        if (this.changeListeners == null) {
            boolean hadListeners = this.hasListeners();
            this.changeListeners = listener;
            if (!hadListeners) {
                this.firstListenerAdded();
            }
            return;
        }
        if (this.changeListeners instanceof IChangeListener) {
            IChangeListener l = (IChangeListener)this.changeListeners;
            listenerList = new ArrayList<IChangeListener>();
            listenerList.add(l);
        } else {
            listenerList = (ArrayList<IChangeListener>)this.changeListeners;
        }
        if (listenerList.size() > 16) {
            HashSet<IChangeListener> listenerSet = new HashSet<IChangeListener>();
            listenerSet.addAll(listenerList);
            this.changeListeners = listenerList;
        }
        listenerList.add(listener);
    }

    public void removeChangeListener(IChangeListener listener) {
        if (this.changeListeners == listener) {
            this.changeListeners = null;
            if (!this.hasListeners()) {
                this.lastListenerRemoved();
            }
            return;
        }
        if (this.changeListeners instanceof Collection) {
            Collection listenerList = (Collection)this.changeListeners;
            listenerList.remove(listener);
            if (listenerList.size() == 0) {
                this.changeListeners = null;
                if (!this.hasListeners()) {
                    this.lastListenerRemoved();
                }
            }
        }
    }

    public void addStaleListener(IStaleListener listener) {
        ArrayList<IStaleListener> listenerList;
        if (this.staleListeners == null) {
            boolean hadListeners = this.hasListeners();
            this.staleListeners = listener;
            if (!hadListeners) {
                this.firstListenerAdded();
            }
            return;
        }
        if (this.staleListeners instanceof IStaleListener) {
            IStaleListener l = (IStaleListener)this.staleListeners;
            listenerList = new ArrayList<IStaleListener>();
            listenerList.add(l);
        } else {
            listenerList = (ArrayList<IStaleListener>)this.staleListeners;
        }
        if (listenerList.size() > 16) {
            HashSet<IStaleListener> listenerSet = new HashSet<IStaleListener>();
            listenerSet.addAll(listenerList);
            this.staleListeners = listenerList;
        }
        listenerList.add(listener);
    }

    public void removeStaleListener(IStaleListener listener) {
        if (this.staleListeners == listener) {
            this.staleListeners = null;
            if (!this.hasListeners()) {
                this.lastListenerRemoved();
            }
            return;
        }
        if (this.staleListeners instanceof Collection) {
            Collection listenerList = (Collection)this.staleListeners;
            listenerList.remove(listener);
            if (listenerList.size() == 0) {
                this.staleListeners = null;
                if (!this.hasListeners()) {
                    this.lastListenerRemoved();
                }
            }
        }
    }

    protected void fireChange() {
        if (this.changeListeners == null) {
            return;
        }
        ChangeEvent e = new ChangeEvent((IObservable)this);
        if (this.changeListeners instanceof IChangeListener) {
            ((IChangeListener)this.changeListeners).handleChange(e);
            return;
        }
        Collection changeListenerCollection = (Collection)this.changeListeners;
        IChangeListener[] listeners = changeListenerCollection.toArray(new IChangeListener[changeListenerCollection.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].handleChange(e);
            ++i;
        }
    }

    protected void fireStale() {
        if (this.staleListeners == null) {
            return;
        }
        StaleEvent e = new StaleEvent((IObservable)this);
        if (this.staleListeners instanceof IStaleListener) {
            ((IStaleListener)this.staleListeners).handleStale(e);
            return;
        }
        Collection changeListenerCollection = (Collection)this.staleListeners;
        IStaleListener[] listeners = changeListenerCollection.toArray(new IStaleListener[changeListenerCollection.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].handleStale(e);
            ++i;
        }
    }

    protected boolean hasListeners() {
        return this.changeListeners != null || this.staleListeners != null;
    }

    protected void firstListenerAdded() {
    }

    protected void lastListenerRemoved() {
    }

    public void dispose() {
        this.changeListeners = null;
        this.staleListeners = null;
    }
}

