/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.selection;

import com.ibm.team.repository.rcp.common.ChangeListenerList;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.selection.ITypedSelectionService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class SubTypedSelectionService
implements ITypedSelectionService {
    private ITypedSelectionService parent;
    private Map mapClassOntoChangeListenerList = new HashMap();
    private IChangeListener listener = new IChangeListener(){

        public void changed(Object source, Object property) {
            Class c = (Class)source;
            ChangeListenerList listeners = (ChangeListenerList)SubTypedSelectionService.this.mapClassOntoChangeListenerList.get(c);
            if (listeners != null) {
                listeners.notifyListeners((Object)c, property);
            }
        }
    };

    public SubTypedSelectionService(ITypedSelectionService parent) {
        this.parent = parent;
    }

    public void addListener(Class selectionType, IChangeListener l) {
        ChangeListenerList listeners = (ChangeListenerList)this.mapClassOntoChangeListenerList.get(selectionType);
        if (listeners == null) {
            listeners = new ChangeListenerList();
            this.mapClassOntoChangeListenerList.put(selectionType, listeners);
            this.parent.addListener(selectionType, this.listener);
        }
        listeners.add(l);
    }

    public void removeListener(Class selectionType, IChangeListener l) {
        ChangeListenerList listeners = (ChangeListenerList)this.mapClassOntoChangeListenerList.get(selectionType);
        if (listeners != null) {
            listeners.remove(l);
            if (listeners.isEmpty()) {
                this.mapClassOntoChangeListenerList.remove(selectionType);
                this.parent.removeListener(selectionType, this.listener);
            }
        }
    }

    public void dispose() {
        for (Map.Entry entry : this.mapClassOntoChangeListenerList.entrySet()) {
            Class c = (Class)entry.getKey();
            this.parent.removeListener(c, this.listener);
        }
        this.mapClassOntoChangeListenerList.clear();
    }

    public Collection getSelection(Class selectionType) {
        return this.parent.getSelection(selectionType);
    }
}

