/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.query;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PopupLayout
extends Layout {
    private Point preferredSize = new Point(150, 150);
    private Control mainControl = null;

    protected Point computeSize(Composite composite, int hint, int hint2, boolean flushCache) {
        return this.preferredSize;
    }

    public void setMainControl(Control mainControl) {
        this.mainControl = mainControl;
    }

    public void setPreferredSize(Point preferredSize) {
        this.preferredSize = preferredSize;
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle clientArea = composite.getClientArea();
        int currenty = clientArea.y;
        Control[] children = composite.getChildren();
        boolean foundMain = false;
        int i = 0;
        while (i < children.length) {
            Control next = children[i];
            if (next == this.mainControl) {
                foundMain = true;
                break;
            }
            if (next.getVisible()) {
                int height = this.getHeight(next, clientArea.width);
                next.setBounds(clientArea.x, currenty, clientArea.width, height);
                currenty += height;
            }
            ++i;
        }
        if (foundMain) {
            int remainy = clientArea.y + clientArea.height;
            int i2 = children.length - 1;
            while (i2 >= 0) {
                Control next = children[i2];
                if (next == this.mainControl) break;
                if (next.getVisible()) {
                    int height = this.getHeight(next, clientArea.width);
                    next.setBounds(clientArea.x, remainy - height, clientArea.width, height);
                    remainy -= height;
                }
                --i2;
            }
            this.mainControl.setBounds(clientArea.x, currenty, clientArea.width, Math.max(remainy - currenty, 0));
        }
    }

    private int getHeight(Control next, int width) {
        Point sz = next.computeSize(width, -1);
        return sz.y;
    }
}

