/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.query;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.query.IPageable;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.internal.layout.LayoutUtil;

public final class Pager {
    private Composite control;
    private IPageable pageable = null;
    private IChangeListener enablementListener = new IChangeListener(){

        public void handleChange(ChangeEvent event) {
            if (Pager.this.control.isDisposed()) {
                return;
            }
            Pager.this.updateEnablement();
        }
    };
    private Link more;
    private Label label;

    public Pager(Composite parent, WidgetFactoryContext context) {
        WidgetToolkit ft = context.getToolkit();
        this.control = ft.createComposite(parent);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.control);
        Composite linkWrapper = ft.createComposite(this.control);
        this.more = new Link(linkWrapper, 0);
        this.more.setText(Messages.Pager_3);
        this.more.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Pager.this.goMore();
            }
        });
        this.more.setBackground(linkWrapper.getBackground());
        this.more.setEnabled(false);
        this.label = ft.createLabel(this.control, "");
        GridDataFactory.fillDefaults().grab(true, false).align(16384, 4).applyTo((Control)linkWrapper);
        GridLayoutFactory.fillDefaults().numColumns(linkWrapper.getChildren().length).equalWidth(false).generateLayout(linkWrapper);
        GridDataFactory.fillDefaults().grab(false, false).align(131072, 0x1000008).applyTo((Control)this.label);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).generateLayout(this.control);
    }

    protected void updateEnablement() {
        if (this.pageable == null) {
            this.more.setEnabled(false);
        } else {
            this.more.setEnabled(this.pageable.hasMore().getValue().equals(true));
            String newLabelText = "";
            if ((Long)this.pageable.totalSize().getValue() > 0L) {
                newLabelText = NLS.bind((String)Messages.Pager_4, (Object[])new Object[]{this.pageable.fetchedSize().getValue(), this.pageable.totalSize().getValue()});
            }
            if (this.label != null && !this.label.getText().equals(newLabelText)) {
                this.label.setText(newLabelText);
                LayoutUtil.resize((Control)this.label);
            }
        }
    }

    protected void goMore() {
        if (this.pageable != null) {
            this.pageable.goMore();
        }
    }

    public void setInput(IPageable pageable) {
        if (pageable == this.pageable) {
            return;
        }
        if (this.pageable != null) {
            this.pageable.hasMore().removeChangeListener(this.enablementListener);
            this.pageable.fetchedSize().removeChangeListener(this.enablementListener);
        }
        this.pageable = pageable;
        if (this.pageable != null) {
            this.pageable.hasMore().addChangeListener(this.enablementListener);
            this.pageable.fetchedSize().addChangeListener(this.enablementListener);
        }
        this.updateEnablement();
    }

    public Composite getControl() {
        return this.control;
    }
}

