/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import com.ibm.team.repository.rcp.common.ChangeListenerList;
import com.ibm.team.repository.rcp.common.IChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.util.Util;

public class UndoStack {
    public static final Object PROP_CHANGED = new Object();
    private ChangeListenerList listeners = new ChangeListenerList();
    private Object[] stack;
    private int index = 0;
    private int startIndex = 0;
    private int endIndex = 0;
    private int stackSize = 10;

    public UndoStack(int stackSize) {
        this.stackSize = stackSize;
        this.stack = new Object[stackSize];
    }

    public void push(Object toPush) {
        if (toPush == null) {
            return;
        }
        if (Util.equals((Object)this.getCurrent(), (Object)toPush)) {
            return;
        }
        int prevIndex = (this.index + this.stackSize - 1) % this.stackSize;
        int search = this.startIndex;
        while (search != this.index && search != prevIndex) {
            if (Util.equals((Object)this.stack[search], (Object)toPush)) {
                this.shiftEntries(search, prevIndex);
                this.index = prevIndex;
                break;
            }
            search = (search + 1) % this.stackSize;
        }
        if (this.index != this.endIndex) {
            this.clearRange(this.index, this.endIndex);
            this.endIndex = this.index;
        }
        this.stack[this.index] = toPush;
        this.endIndex = this.index = (this.index + 1) % this.stackSize;
        if (this.startIndex == this.endIndex) {
            this.stack[this.startIndex] = null;
            this.startIndex = (this.startIndex + 1) % this.stackSize;
        }
        this.fireChangeEvent(PROP_CHANGED);
    }

    private void shiftEntries(int start, int index2) {
        int search = start;
        while (search != index2) {
            this.stack[search] = this.stack[(search + 1) % this.stackSize];
            search = (search + 1) % this.stackSize;
        }
    }

    public void clear() {
        this.clearRange(this.startIndex, this.endIndex);
        this.endIndex = 0;
        this.startIndex = 0;
        this.index = 0;
        this.fireChangeEvent(PROP_CHANGED);
    }

    private void clearRange(int start, int end) {
        int i = start;
        while (i != end) {
            this.stack[i] = null;
            i = (i + 1) % this.stackSize;
        }
    }

    public Object getCurrent() {
        return this.stack[(this.index + this.stackSize - 1) % this.stackSize];
    }

    public boolean hasBackEntries() {
        return this.index != this.startIndex + 1 && this.index != this.startIndex;
    }

    public boolean hasForwardEntries() {
        return this.index != this.endIndex;
    }

    public List getBackEntries() {
        return this.getRange(this.startIndex, (this.index + this.stackSize - 1) % this.stackSize);
    }

    public List getForwardEntries() {
        return this.getRange(this.index, this.endIndex);
    }

    public Set getKnownEntries() {
        HashSet knownEntries = new HashSet();
        knownEntries.addAll(this.getBackEntries());
        knownEntries.addAll(this.getForwardEntries());
        return knownEntries;
    }

    public Object getEntryAt(int position) {
        return this.stack[(this.index + position + this.stackSize - 1) % this.stackSize];
    }

    public void moveForward(int distance) {
        this.index += distance + this.stackSize;
        this.index %= this.stackSize;
        this.fireChangeEvent(PROP_CHANGED);
    }

    public void moveTo(Object toSelect) {
        int i = 0;
        while (i < this.stack.length) {
            Object next = this.stack[i];
            if (Util.equals((Object)next, (Object)toSelect)) {
                this.index = (i + this.stackSize + 1) % this.stackSize;
                this.fireChangeEvent(PROP_CHANGED);
                return;
            }
            ++i;
        }
    }

    private void fireChangeEvent(Object event) {
        this.listeners.notifyListeners((Object)this, event);
    }

    public void addListener(IChangeListener newListener) {
        this.listeners.add(newListener);
    }

    public void removeListener(IChangeListener oldListener) {
        this.listeners.remove(oldListener);
    }

    private List getRange(int startIndex2, int index2) {
        ArrayList<Object> result = new ArrayList<Object>((index2 + this.stackSize - startIndex2) % this.stackSize);
        int i = startIndex2;
        while (i != index2) {
            result.add(this.stack[i]);
            i = (i + 1) % this.stackSize;
        }
        return result;
    }
}

