/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.rcp.core.preferences.PreferencesUtil;
import com.ibm.team.repository.rcp.core.preferences.RecursivePreferenceListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.RepositoryUiPlugin;
import com.ibm.team.repository.rcp.ui.internal.parts.IPreferenceProvider;
import com.ibm.team.repository.rcp.ui.internal.parts.PreferenceProviderInputFactory;
import com.ibm.team.repository.rcp.ui.workingcopy.AbstractWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.IPreferencesWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.SaveConflictException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class PreferenceProviderWorkingCopy
extends AbstractWorkingCopy
implements IPreferencesWorkingCopy {
    private IEclipsePreferences original;
    private IEclipsePreferences workingCopy;
    private RecursivePreferenceListener modifiedListener = new RecursivePreferenceListener(new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!PreferenceProviderWorkingCopy.this.ignoreConflicts) {
                PreferenceProviderWorkingCopy.this.setConflict(true);
            }
        }
    });
    private RecursivePreferenceListener dirtyListener;
    private PreferenceProviderInputFactory factory;
    private boolean ignoreConflicts = false;

    public PreferenceProviderWorkingCopy(PreferenceProviderInputFactory factory) throws BackingStoreException {
        this.factory = factory;
        if (factory.toEdit != null) {
            this.original = factory.preferenceProvider.getState(factory.toEdit);
            PreferencesUtil.copyTree((Preferences)this.workingCopy, (Preferences)this.original, null);
            this.modifiedListener.attachTo(this.original);
        }
        this.workingCopy = PreferencesUtil.createPreferences();
        this.dirtyListener = new RecursivePreferenceListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (!PreferenceProviderWorkingCopy.this.ignoreConflicts) {
                    PreferenceProviderWorkingCopy.this.setDirty(true);
                }
            }
        });
        this.dirtyListener.attachTo(this.workingCopy);
    }

    public IEclipsePreferences getPreferences() {
        return this.workingCopy;
    }

    public void save(IProgressMonitor progress) throws CoreException, SaveConflictException {
        if (this.hasConflict()) {
            throw new SaveConflictException();
        }
        this.saveAndOverwrite(progress);
    }

    public void dispose() {
        try {
            this.modifiedListener.detachFrom(this.original);
            this.dirtyListener.detachFrom(this.workingCopy);
            this.workingCopy.removeNode();
        }
        catch (BackingStoreException e) {
            RepositoryUiPlugin.log(e);
        }
    }

    public ImageDescriptor getImage() {
        return null;
    }

    public String getName() {
        return this.factory.name;
    }

    public String getToolTipText() {
        return "";
    }

    public void revert(IProgressMonitor progress) throws CoreException {
        try {
            try {
                this.ignoreConflicts = true;
                if (this.original == null) {
                    PreferencesUtil.copyTree((Preferences)this.workingCopy, (Preferences)PreferencesUtil.getEmptyPreferences(), (IProgressMonitor)progress);
                } else {
                    PreferencesUtil.copyTree((Preferences)this.workingCopy, (Preferences)this.original, (IProgressMonitor)progress);
                }
            }
            catch (BackingStoreException e) {
                throw new CoreException(StatusUtil.newStatus((Object)this, (Throwable)e));
            }
        }
        finally {
            this.ignoreConflicts = false;
        }
        this.setConflict(false);
        this.setDirty(false);
    }

    public void saveAndOverwrite(IProgressMonitor progress) throws CoreException {
        try {
            try {
                this.ignoreConflicts = true;
                if (this.factory.toEdit == null) {
                    this.factory.toEdit = this.factory.sharedObjectStore.createInstance((Preferences)this.workingCopy);
                    this.factory.preferenceProvider = (IPreferenceProvider)Adapters.getAdapter((Object)this.factory.toEdit, IPreferenceProvider.class);
                    this.original = this.factory.preferenceProvider.getState(this.factory.toEdit);
                    this.modifiedListener.attachTo(this.original);
                } else {
                    PreferencesUtil.copyTree((Preferences)this.original, (Preferences)this.workingCopy, (IProgressMonitor)progress);
                    this.original.flush();
                }
            }
            catch (BackingStoreException e) {
                throw new CoreException(StatusUtil.newStatus((Object)this, (Throwable)e));
            }
        }
        finally {
            this.ignoreConflicts = false;
        }
        this.setConflict(false);
        this.setDirty(false);
    }
}

