/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.repository.rcp.ui.internal.menus.EmptyMenu;
import com.ibm.team.repository.rcp.ui.internal.menus.MenuExtContributionItem;
import com.ibm.team.repository.rcp.ui.internal.parts.EnhancedFillLayout;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSearchPageSite;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSearchResult;
import com.ibm.team.repository.rcp.ui.internal.viewers.IRefreshable;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IMenuProvider;
import com.ibm.team.repository.rcp.ui.parts.IReusablePart;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageSite;

public class PartSearchPageHost
implements ISearchResultPage {
    private PartSearchResult searchResult;
    private ISearchResultViewPart viewPart;
    private IPageSite pageSite;
    private String id;
    private IActionBars actionBars;
    private PartSearchPageSite site;
    private AbstractPart part;
    private String label = "";
    private Composite control;
    private Composite partControl;
    private MenuExtContributionItem toolbarContribution;
    private MenuExtContributionItem menuContribution;

    public String getID() {
        return NullUtil.safeString((String)this.id);
    }

    public String getLabel() {
        return this.label;
    }

    public Object getUIState() {
        return null;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setInput(ISearchResult search, Object uiState) {
        if (search instanceof PartSearchResult) {
            PartSearchResult newSearchResult = (PartSearchResult)search;
            PartSearchResult oldSearchResult = this.searchResult;
            this.searchResult = newSearchResult;
            this.label = this.searchResult.getLabel();
            IReusablePart reusablePart = null;
            if (this.part != null) {
                reusablePart = (IReusablePart)Adapters.getAdapter((Object)this.part, IReusablePart.class);
            }
            if (reusablePart != null && oldSearchResult.getPartQuery().getFactory().equals(newSearchResult.getPartQuery().getFactory())) {
                reusablePart.setInput(this.searchResult.getPartQuery().getInput());
            } else {
                this.disposeControls();
                this.checkForCreation();
            }
        }
        this.actionBars.updateActionBars();
    }

    public void setViewPart(ISearchResultViewPart part) {
        this.viewPart = part;
        this.checkForCreation();
    }

    public IPageSite getSite() {
        return this.pageSite;
    }

    public void init(IPageSite site) throws PartInitException {
        this.pageSite = site;
        this.checkForCreation();
    }

    public void setActionBars(IActionBars actionBars) {
        this.actionBars = actionBars;
        this.toolbarContribution = new MenuExtContributionItem();
        this.menuContribution = new MenuExtContributionItem();
        actionBars.getToolBarManager().add((IContributionItem)this.toolbarContribution);
        actionBars.getMenuManager().add((IContributionItem)this.menuContribution);
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 262144);
        this.control.setLayout((Layout)new EnhancedFillLayout());
        this.checkForCreation();
    }

    private void checkForCreation() {
        if (this.part == null && this.control != null && this.searchResult != null && this.pageSite != null && this.viewPart != null && this.actionBars != null) {
            this.partControl = new Composite(this.control, 262144);
            this.site = new PartSearchPageSite(this.partControl, this);
            this.part = this.searchResult.getPartQuery().getFactory().createPart(this.site, this.searchResult.getPartQuery().getInput());
            this.enableMenus(true);
            this.control.layout(true);
        }
    }

    private void enableMenus(boolean enableMenus) {
        IMenuProvider menuProvider = null;
        if (this.part != null) {
            menuProvider = (IMenuProvider)Adapters.getAdapter((Object)this.part, IMenuProvider.class);
        }
        if (menuProvider != null && enableMenus) {
            this.toolbarContribution.setMenu(menuProvider.getToolbarContributions());
            this.menuContribution.setMenu(menuProvider.getMenuContributions());
        } else {
            this.toolbarContribution.setMenu(EmptyMenu.getInstance());
            this.menuContribution.setMenu(EmptyMenu.getInstance());
        }
    }

    private void disposeControls() {
        if (this.partControl != null) {
            this.partControl.dispose();
            this.partControl = null;
            this.site = null;
            this.part = null;
            this.enableMenus(false);
        }
    }

    public void dispose() {
        this.disposeControls();
        this.control.dispose();
        this.control = null;
    }

    public Control getControl() {
        return this.control;
    }

    Composite getComposite() {
        return this.control;
    }

    public void setLabel(String newLabel) {
        this.label = newLabel;
        this.viewPart.updateLabel();
    }

    PartSearchResult getSearchResult() {
        return this.searchResult;
    }

    ISearchResultViewPart getViewPart() {
        return this.viewPart;
    }

    IPageSite getPageSite() {
        return this.pageSite;
    }

    IActionBars getActionBars() {
        return this.actionBars;
    }

    public void refresh() {
        IRefreshable refreshable = (IRefreshable)Adapters.getAdapter((Object)this.part, IRefreshable.class);
        if (refreshable != null) {
            refreshable.refresh();
        }
    }
}

