/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import com.ibm.team.repository.rcp.ui.parts.IBusyHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.services.IDisposable;

public class PartBusyHandler
implements IBusyHandler,
IDisposable {
    private IWorkbenchSiteProgressService service;
    private Job progressJob;
    private Object blockMutex = new Object();
    private int busyCount = 0;
    private boolean disposed = false;
    private boolean scheduled;

    public PartBusyHandler(IWorkbenchPartSite site) {
        this.service = (IWorkbenchSiteProgressService)site.getAdapter(IWorkbenchSiteProgressService.class);
        this.progressJob = new Job(site.getRegisteredName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Object object = PartBusyHandler.this.blockMutex;
                    synchronized (object) {
                        try {
                            if (!monitor.isCanceled()) {
                                PartBusyHandler.this.blockMutex.wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                finally {
                    monitor.done();
                    PartBusyHandler.this.scheduled = false;
                }
                return Status.OK_STATUS;
            }
        };
        this.progressJob.setSystem(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBusy(boolean isBusy) {
        Object object = this.blockMutex;
        synchronized (object) {
            if (this.disposed) {
                return;
            }
            this.busyCount = isBusy ? ++this.busyCount : --this.busyCount;
            if (this.busyCount > 0) {
                if (!this.scheduled) {
                    this.scheduled = true;
                    this.service.schedule(this.progressJob);
                }
            } else {
                this.scheduled = false;
                this.progressJob.cancel();
                this.blockMutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.blockMutex;
        synchronized (object) {
            this.disposed = true;
            this.scheduled = false;
            this.blockMutex.notifyAll();
        }
        this.setBusy(false);
    }
}

