/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.repository.rcp.ui.internal.parts.ViewId;
import com.ibm.team.repository.rcp.ui.parts.IPinnablePart;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;

public class PageViewRegistry {
    private static Map<IWorkbenchPage, PageViewRegistry> pageMap = new WeakHashMap<IWorkbenchPage, PageViewRegistry>();
    private IPartListener2 listener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (partRef instanceof IViewReference) {
                IViewReference vr = (IViewReference)partRef;
                PageViewRegistry.this.viewClosed(ViewId.forView(vr));
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            if (partRef instanceof IViewReference) {
                IViewReference vr = (IViewReference)partRef;
                ViewId vid = ViewId.forView(vr);
                IWorkbenchPart wp = partRef.getPart(false);
                IPinnablePart rp = (IPinnablePart)Adapters.getAdapter((Object)wp, IPinnablePart.class);
                if (rp != null && PageViewRegistry.this.viewList.contains(vid)) {
                    PageViewRegistry.this.pinnedState.put(vid, rp.isPinned());
                }
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (partRef instanceof IViewReference) {
                IViewReference vr = (IViewReference)partRef;
                ViewId vid = ViewId.forView(vr);
                if (PageViewRegistry.this.viewList.contains(vid)) {
                    PageViewRegistry.this.pinnedState.remove(vid);
                }
            }
        }
    };
    private Set<ViewId> viewList = new HashSet<ViewId>();
    private IWorkbenchPage page;
    private Map<ViewId, Object> inputMap = new HashMap<ViewId, Object>();
    private Map<ViewId, Boolean> pinnedState = new HashMap<ViewId, Boolean>();
    private IPageListener pageListener = new IPageListener(){

        public void pageActivated(IWorkbenchPage page) {
        }

        public void pageClosed(IWorkbenchPage page) {
            PageViewRegistry.this.dispose();
        }

        public void pageOpened(IWorkbenchPage page) {
        }
    };

    public PageViewRegistry(IWorkbenchPage page) {
        this.page = page;
        page.addPartListener(this.listener);
        page.getWorkbenchWindow().addPageListener(this.pageListener);
    }

    protected void viewClosed(ViewId viewId) {
        this.viewList.remove(viewId);
        this.inputMap.remove(viewId);
    }

    public void addView(ViewId toTrack) {
        this.viewList.add(toTrack);
    }

    public void dispose() {
        this.page.removePartListener(this.listener);
        this.page.getWorkbenchWindow().removePageListener(this.pageListener);
        pageMap.remove(this);
    }

    public ViewId generateViewId(String viewId) {
        long count = System.currentTimeMillis();
        String id;
        while (this.page.findViewReference(viewId, id = "" + count) != null) {
            ++count;
        }
        return new ViewId(viewId, id);
    }

    public ViewId findViewForInput(String viewId, Object input) {
        for (Map.Entry<ViewId, Object> next : this.inputMap.entrySet()) {
            if (!next.getKey().getPrimaryId().equals(viewId) || !NullUtil.equals((Object)next.getValue(), (Object)input)) continue;
            return next.getKey();
        }
        ViewId result = null;
        IViewReference[] views = this.page.getViewReferences();
        int i = 0;
        while (i < views.length) {
            block8: {
                IViewReference reference;
                block9: {
                    IViewPart part;
                    reference = views[i];
                    if (!reference.getId().equals(viewId) || (part = reference.getView(true)) == null) break block8;
                    IPinnablePart pinnablePart = (IPinnablePart)part.getAdapter(IPinnablePart.class);
                    if (pinnablePart == null) break block9;
                    Object nextInput = pinnablePart.getInput();
                    if (Util.equals((Object)nextInput, (Object)input)) {
                        result = ViewId.forView(reference);
                        break;
                    }
                    if (pinnablePart.isPinned()) break block8;
                }
                result = ViewId.forView(reference);
            }
            ++i;
        }
        if (result == null) {
            for (Map.Entry<ViewId, Boolean> next : this.pinnedState.entrySet()) {
                if (!next.getKey().getPrimaryId().equals(viewId) || next.getValue().booleanValue()) continue;
                return next.getKey();
            }
        }
        return result;
    }

    public void setInput(ViewId existingPart, Object input) {
        this.inputMap.put(existingPart, input);
    }

    public static PageViewRegistry findRegistryForPage(IWorkbenchPage where) {
        PageViewRegistry registry = pageMap.get(where);
        if (registry == null) {
            registry = new PageViewRegistry(where);
            pageMap.put(where, registry);
        }
        return registry;
    }
}

