/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.PushAction;
import com.ibm.team.repository.rcp.ui.internal.utils.ToolkitUtil;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.ControlSiteDecorator;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.WorkingCopies;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class OkayCancelPart
extends AbstractPart
implements IAdaptable {
    private IChangeListener inputListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            OkayCancelPart.this.handleInputEvent(property);
        }
    };
    private Composite bbar;
    private AbstractPart part;
    private Set<IWorkingCopy> inputs = new HashSet<IWorkingCopy>();
    private IControlSite site;
    private PushAction applyAction;
    private PushAction okayAction;
    private PushAction cancelAction;

    public OkayCancelPart(IControlSite site, IPartFactory body, Object initialInput, boolean applyButton) {
        super(site, initialInput);
        WidgetToolkit toolkit = site.getToolkit();
        this.site = site;
        Composite parent = site.getParent();
        IControlSite childSite = ControlSiteDecorator.createDynamicDecorator(new ControlSiteDecorator(site){

            public void addInput(IWorkingCopy newInput) {
                if (OkayCancelPart.this.inputs.contains(newInput)) {
                    return;
                }
                OkayCancelPart.this.inputAdded(newInput);
                super.addInput(newInput);
            }

            public boolean removeInput(IWorkingCopy oldInput, boolean force) {
                boolean result = super.removeInput(oldInput, force);
                if (result) {
                    OkayCancelPart.this.inputRemoved(oldInput);
                }
                return result;
            }
        }, site);
        this.part = body.createPart(childSite, initialInput);
        this.bbar = toolkit.createComposite(parent);
        this.okayAction = new PushAction(IDialogConstants.OK_LABEL, new Runnable(){

            public void run() {
                OkayCancelPart.this.doOkay();
            }
        });
        this.applyAction = new PushAction(Messages.OkayCancelPart_0, new Runnable(){

            public void run() {
                OkayCancelPart.this.doApply();
            }
        });
        this.cancelAction = new PushAction(IDialogConstants.CANCEL_LABEL, new Runnable(){

            public void run() {
                OkayCancelPart.this.doCancel();
            }
        });
        ToolkitUtil.createButton(toolkit, this.bbar, (IActionExt)this.okayAction);
        ToolkitUtil.createButton(toolkit, this.bbar, (IActionExt)this.cancelAction);
        if (applyButton) {
            ToolkitUtil.createButton(toolkit, this.bbar, (IActionExt)this.applyAction);
        }
        GridLayoutFactory.fillDefaults().numColumns(this.bbar.getChildren().length).generateLayout(this.bbar);
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)this.bbar);
        parent.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.character == '\r') {
                    OkayCancelPart.this.doOkay();
                }
                if (e.keyCode == 27) {
                    OkayCancelPart.this.doCancel();
                }
            }
        });
        GridLayoutFactory.fillDefaults().generateLayout(parent);
        this.updateButtonEnablement();
    }

    protected void inputRemoved(IWorkingCopy oldInput) {
        oldInput.removeListener(this.inputListener);
        this.inputs.remove(oldInput);
        this.updateButtonEnablement();
    }

    protected void inputAdded(IWorkingCopy newInput) {
        this.inputs.add(newInput);
        newInput.addListener(this.inputListener);
        if (this.bbar != null) {
            this.updateButtonEnablement();
        }
    }

    protected void handleInputEvent(Object property) {
        if (property == IWorkingCopy.PROP_DIRTY || property == IWorkingCopy.PROP_VALID) {
            this.updateButtonEnablement();
        }
    }

    protected void doApply() {
        WorkingCopies.performSave(this.getSite().getShell(), this.inputs, (IProgressMonitor)new NullProgressMonitor());
    }

    protected IControlSite getSite() {
        return this.site;
    }

    private void updateButtonEnablement() {
        if (this.bbar != null) {
            boolean dirty = this.isDirty();
            boolean valid = this.isValid();
            this.okayAction.setEnabled(valid);
            this.applyAction.setEnabled(valid && dirty);
        }
    }

    private boolean isValid() {
        for (IWorkingCopy next : this.inputs) {
            if (next.isValid()) continue;
            return false;
        }
        return true;
    }

    private boolean isDirty() {
        boolean isDirty = false;
        for (IWorkingCopy next : this.inputs) {
            if (!next.isDirty()) continue;
            isDirty = true;
        }
        return isDirty;
    }

    protected void doOkay() {
        if (this.isValid() && WorkingCopies.performSave(this.getSite().getShell(), this.inputs, (IProgressMonitor)new NullProgressMonitor())) {
            this.getSite().close();
        }
    }

    protected void doCancel() {
        this.getSite().close();
    }

    public Object getAdapter(Class adapter) {
        return Adapters.getAdapter((Object)this.part, (Class)adapter);
    }

    protected void dispose() {
        for (IWorkingCopy next : this.inputs) {
            next.removeListener(this.inputListener);
        }
        super.dispose();
    }
}

