/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import com.ibm.team.repository.rcp.ui.internal.parts.NullMnemonicGenerator;
import com.ibm.team.repository.rcp.ui.internal.parts.PartBusyHandler;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.internal.selection.ITypedSelectionService;
import com.ibm.team.repository.rcp.ui.internal.selection.SelectionServiceRegistry;
import com.ibm.team.repository.rcp.ui.internal.selection.SubTypedSelectionService;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.parts.AbstractControlSite;
import com.ibm.team.repository.rcp.ui.parts.INameable;
import com.ibm.team.repository.rcp.ui.parts.IPartSite;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;

public class ConvertingPartSite
extends AbstractControlSite
implements IPartSite,
INameable {
    private IWorkbenchPart part;
    private PartSiteJobRunner runner;
    private PartBusyHandler progressService;
    private SubTypedSelectionService selectionService;
    private IWorkbenchPartSite site;
    private int menuCounter = 0;
    private PartSiteJobRunner userRunner;

    public ConvertingPartSite(Composite theControl, IWorkbenchPart part) {
        super(theControl);
        this.site = part.getSite();
        this.part = part;
        this.progressService = new PartBusyHandler(this.site);
        this.selectionService = new SubTypedSelectionService(SelectionServiceRegistry.getService(this.site.getPage()));
    }

    protected MnemonicGenerator createMnemonicGenerator() {
        return new MnemonicGenerator(new NullMnemonicGenerator());
    }

    protected IOperationRunner getParentOperationRunner() {
        if (this.runner == null) {
            this.runner = new PartSiteJobRunner(this.site, false);
        }
        return this.runner;
    }

    protected IOperationRunner getUserOperationRunner() {
        if (this.userRunner == null) {
            this.userRunner = new PartSiteJobRunner(this.site, true);
        }
        return this.userRunner;
    }

    public void setName(String newName) {
        if (this.runner != null) {
            this.runner.setName(newName);
        }
        super.setName(newName);
    }

    protected void dispose() {
        this.selectionService.dispose();
        this.progressService.dispose();
        if (this.runner != null) {
            this.runner.dispose();
        }
        super.dispose();
    }

    public final void close() {
        if (this.part instanceof IEditorPart) {
            IEditorPart editor = (IEditorPart)this.part;
            this.getPage().closeEditor(editor, true);
        }
        if (this.part instanceof IViewPart) {
            IViewPart view = (IViewPart)this.part;
            this.getPage().hideView(view);
        }
    }

    protected WidgetToolkit createToolkit() {
        return WidgetToolkit.createFormToolkit();
    }

    public final IWorkbenchPage getPage() {
        return this.part.getSite().getPage();
    }

    public final void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider) {
        if (this.menuCounter == 0) {
            this.part.getSite().registerContextMenu(menuManager, selectionProvider);
        } else {
            String id = String.valueOf(this.part.getSite().getId()) + this.menuCounter;
            this.part.getSite().registerContextMenu(id, menuManager, selectionProvider);
        }
        ++this.menuCounter;
    }

    public final void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider) {
        this.part.getSite().registerContextMenu(menuId, menuManager, selectionProvider);
    }

    public final void setBusy(boolean isBusy) {
        this.progressService.setBusy(isBusy);
    }

    public final ITypedSelectionService getSelectionService() {
        return this.selectionService;
    }

    public final IWorkbenchWindow getWorkbenchWindow() {
        return this.part.getSite().getWorkbenchWindow();
    }

    public final IWorkbenchPart getPart() {
        return this.part;
    }

    public final void setSelectionProvider(ISelectionProvider selectionProvider) {
        this.part.getSite().setSelectionProvider(selectionProvider);
    }
}

