/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.menus;

import com.ibm.team.repository.rcp.ui.internal.menus.AbstractMenuViewer;
import com.ibm.team.repository.rcp.ui.internal.menus.ActionUtil;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolbarViewer
extends AbstractMenuViewer {
    private static final String DIRTY = "dirty";
    static final String DISABLED_IMAGE_DESCRIPTOR = "disabled_image_descriptor";
    static final String IMAGE_DESCRIPTOR = "image_descriptor";
    static final String HOVER_IMAGE_DESCRIPTOR = "hot_image";
    private ToolBar theMenu;
    private HashMap mapActionsOntoToolItems = new HashMap();

    public ToolbarViewer(ToolBar theMenu, IMenuExt entries) {
        super((Widget)theMenu, entries);
        this.theMenu = theMenu;
    }

    protected void dirty(IActionExt ext) {
        ToolItem item = (ToolItem)this.mapActionsOntoToolItems.get(ext);
        if (item != null) {
            this.setDirty(item);
        }
    }

    protected void removeEntry(IActionExt ext) {
        this.unmap(ext);
        super.removeEntry(ext);
    }

    private void unmap(IActionExt ext) {
        ToolItem item = (ToolItem)this.mapActionsOntoToolItems.get(ext);
        if (item != null) {
            this.mapActionsOntoToolItems.remove(ext);
            ActionUtil.updateAction(item, this.getResources(), null);
            item.dispose();
        }
    }

    protected void update() {
        ToolItem[] toolItems = this.theMenu.getItems();
        int itemIndex = 0;
        List actions = this.getSortedEntries();
        for (IActionExt next : actions) {
            ToolItem item;
            IActionExt action;
            if (!next.isVisible()) {
                this.unmap(next);
                continue;
            }
            if (itemIndex < toolItems.length && (action = (IActionExt)(item = this.theMenu.getItem(itemIndex)).getData()) == next) {
                if (this.isDirty(item)) {
                    this.clearDirty(item);
                    ActionUtil.updateAction(item, this.getResources(), next);
                }
                ++itemIndex;
                continue;
            }
            this.unmap(next);
            item = ActionUtil.createItem(this.theMenu, this.getResources(), itemIndex, next);
            if (item == null) continue;
            item.setData((Object)next);
            this.mapActionsOntoToolItems.put(next, item);
            ++itemIndex;
        }
    }

    private void setDirty(ToolItem temp) {
        temp.setData(DIRTY, (Object)DIRTY);
    }

    private void clearDirty(ToolItem temp) {
        temp.setData(DIRTY, null);
    }

    private boolean isDirty(ToolItem temp) {
        return temp.getData(DIRTY) == DIRTY;
    }

    protected boolean isUpdating() {
        return this.theMenu.isVisible();
    }
}

