/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.menus;

import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.menus.ActionUtil;
import com.ibm.team.repository.rcp.ui.internal.menus.EmptyMenu;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.AddRemoveConverter;
import com.ibm.team.repository.rcp.ui.internal.viewers.IAddRemoveListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class MenuExtContributionItem
extends ContributionItem {
    protected static final String ITEM_DATA = "item_data";
    private IMenuExt action;
    private boolean dirty = false;
    protected Display display;
    private ResourceManager resources = null;
    private Runnable updator = new Runnable(){

        public void run() {
            IContributionManager top = MenuExtContributionItem.this.getParent();
            if (top != null) {
                top.update(false);
                return;
            }
        }
    };
    private ISetListener<IActionExt> entryListener = new AddRemoveConverter<IActionExt>(new IAddRemoveListener<IActionExt>(){

        @Override
        public void added(IActionExt newAction) {
            MenuExtContributionItem.this.actionAdded(newAction);
        }

        @Override
        public void removed(IActionExt oldAction) {
            MenuExtContributionItem.this.actionRemoved(oldAction);
        }
    });
    private IChangeListener actionListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            if (property == IActionExt.PROP_APPEARANCE || property == IActionExt.PROP_ENABLEMENT || property == IActionExt.PROP_SELECTED) {
                MenuExtContributionItem.this.updateAction((IActionExt)source);
            } else if (property == IActionExt.PROP_VISIBILITY) {
                MenuExtContributionItem.this.markDirty();
            }
        }
    };
    private HashMap mapElementOntoItem = new HashMap();
    private DisposeListener itemDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            Widget w = e.widget;
            IActionExt action = (IActionExt)w.getData(MenuExtContributionItem.ITEM_DATA);
            if (action != null) {
                MenuExtContributionItem.this.mapElementOntoItem.remove(action);
            }
        }
    };

    public MenuExtContributionItem() {
        this(EmptyMenu.getInstance());
    }

    public MenuExtContributionItem(IMenuExt action) {
        this.display = Display.getCurrent();
        this.resources = new LocalResourceManager(JFaceResources.getResources());
        this.action = action;
        action.getEntries().addListener(this.entryListener);
        for (IActionExt next : action.getEntries().toCollection()) {
            this.actionAdded(next);
        }
    }

    public void setMenu(IMenuExt newMenu) {
        Assert.isNotNull((Object)newMenu);
        for (IActionExt next : this.action.getEntries().toCollection()) {
            this.actionRemoved(next);
        }
        this.action.getEntries().removeListener(this.entryListener);
        this.action = newMenu;
        for (IActionExt next : this.action.getEntries().toCollection()) {
            this.actionAdded(next);
        }
        this.action.getEntries().addListener(this.entryListener);
    }

    public void setParent(IContributionManager parent) {
        super.setParent(parent);
    }

    protected void markDirty() {
        if (!this.dirty) {
            this.dirty = true;
            if (this.getParent() != null) {
                this.getParent().markDirty();
                SWTUtil.runOnce(this.display, this.updator);
            }
        }
    }

    protected void updateAction(IActionExt ext) {
        Object item = this.getItem(ext);
        if (item instanceof ToolItem) {
            ToolItem toolitem = (ToolItem)item;
            ActionUtil.updateAction(toolitem, this.resources, ext);
        } else if (item instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)item;
            ActionUtil.updateAction(menuItem, this.resources, ext);
        }
    }

    private Object getItem(IActionExt ext) {
        Object result = this.mapElementOntoItem.get(ext);
        return result;
    }

    protected void actionRemoved(IActionExt oldAction) {
        oldAction.removeChangeListener(this.actionListener);
        if (oldAction.isVisible()) {
            this.markDirty();
        }
    }

    protected void actionAdded(IActionExt newAction) {
        newAction.addChangeListener(this.actionListener);
        if (newAction.isVisible()) {
            this.markDirty();
        }
    }

    public void dispose() {
        this.setMenu(EmptyMenu.getInstance());
        this.resources.dispose();
        super.dispose();
    }

    private List getSortedItems() {
        return ActionUtil.getSortedEntries(this.action);
    }

    public void fill(Menu parent, int index) {
        this._fill(parent, index);
    }

    private void _fill(Object parent, int index) {
        List sortedItems = this.getSortedItems();
        for (IActionExt next : sortedItems) {
            if (!next.isVisible()) continue;
            MenuItem menuItem = null;
            if (parent instanceof Menu) {
                menuItem = ActionUtil.createItem((Menu)parent, this.resources, index, next);
            } else if (parent instanceof ToolBar) {
                menuItem = ActionUtil.createItem((ToolBar)parent, this.resources, index, next);
            }
            if (menuItem == null) continue;
            menuItem.setData(ITEM_DATA, (Object)next);
            this.mapElementOntoItem.put(next, menuItem);
            menuItem.addDisposeListener(this.itemDisposeListener);
            ++index;
        }
        this.display = Display.getCurrent();
    }

    public void fill(ToolBar parent, int index) {
        this._fill(parent, index);
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isVisible() {
        for (IActionExt next : this.action.getEntries().toCollection()) {
            if (!next.isVisible()) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        for (IActionExt next : this.action.getEntries().toCollection()) {
            if (!next.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public boolean isSeparator() {
        boolean empty = true;
        for (IActionExt next : this.action.getEntries().toCollection()) {
            if (next.getStyle() != 2) {
                return false;
            }
            empty = false;
        }
        return !empty;
    }
}

