/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.menus;

import com.ibm.team.repository.rcp.ui.internal.menus.ActionToActionExtAdapter;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import com.ibm.team.repository.rcp.ui.internal.menus.MenuViewer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ActionUtil {
    private ActionUtil() {
    }

    public static IActionExt convertAction(IAction action) {
        return new ActionToActionExtAdapter(action);
    }

    static List getSortedEntries(IMenuExt menu) {
        ArrayList sorted = new ArrayList();
        sorted.addAll(menu.getEntries().toCollection());
        Collections.sort(sorted, menu.getOrder());
        boolean foundFirst = false;
        IActionExt lastSeparator = null;
        ArrayList<IActionExt> result = new ArrayList<IActionExt>();
        for (IActionExt next : sorted) {
            if (next.getStyle() == 2) {
                if (!foundFirst) continue;
                lastSeparator = next;
                continue;
            }
            if (lastSeparator != null) {
                result.add(lastSeparator);
                lastSeparator = null;
            }
            foundFirst = true;
            result.add(next);
        }
        return result;
    }

    private static void setImage(MenuItem item, ResourceManager resources, ImageDescriptor newImage) {
        ImageDescriptor oldImage = (ImageDescriptor)item.getData("image_descriptor");
        if (Util.equals((Object)newImage, (Object)oldImage)) {
            return;
        }
        if (newImage != null) {
            item.setImage(resources.createImageWithDefault(newImage));
        } else {
            item.setImage(null);
        }
        if (oldImage != null) {
            resources.destroy((DeviceResourceDescriptor)oldImage);
        }
        item.setData("image_descriptor", (Object)newImage);
    }

    static void updateAction(MenuItem item, ResourceManager resources, IActionExt next) {
        if (next == null) {
            ActionUtil.setImage(item, resources, null);
            return;
        }
        String text = next.getText();
        if (!Util.equals((Object)text, (Object)item.getText())) {
            item.setText(text);
        }
        ActionUtil.setImage(item, resources, next.getImage());
        if (item.getEnabled() != next.isEnabled()) {
            item.setEnabled(next.isEnabled());
        }
        if (item.getSelection() != next.getSelection()) {
            item.setSelection(next.getSelection());
        }
    }

    private static void setHoverImage(ToolItem item, ResourceManager resources, ImageDescriptor newImage) {
        ImageDescriptor oldImage = (ImageDescriptor)item.getData("hot_image");
        if (Util.equals((Object)newImage, (Object)oldImage)) {
            return;
        }
        if (newImage != null) {
            item.setHotImage(resources.createImageWithDefault(newImage));
        } else {
            item.setHotImage(null);
        }
        if (oldImage != null) {
            resources.destroy((DeviceResourceDescriptor)oldImage);
        }
        item.setData("hot_image", (Object)newImage);
    }

    private static void setDisabledImage(ToolItem item, ResourceManager resources, ImageDescriptor newImage) {
        ImageDescriptor oldImage = (ImageDescriptor)item.getData("disabled_image_descriptor");
        if (Util.equals((Object)newImage, (Object)oldImage)) {
            return;
        }
        if (newImage != null) {
            item.setDisabledImage(resources.createImageWithDefault(newImage));
        } else {
            item.setDisabledImage(null);
        }
        if (oldImage != null) {
            resources.destroy((DeviceResourceDescriptor)oldImage);
        }
        item.setData("disabled_image_descriptor", (Object)newImage);
    }

    private static void setImage(ToolItem item, ResourceManager resources, ImageDescriptor newImage) {
        ImageDescriptor oldImage = (ImageDescriptor)item.getData("image_descriptor");
        if (Util.equals((Object)newImage, (Object)oldImage)) {
            return;
        }
        if (newImage != null) {
            item.setImage(resources.createImageWithDefault(newImage));
        } else {
            item.setImage(null);
        }
        if (oldImage != null) {
            resources.destroy((DeviceResourceDescriptor)oldImage);
        }
        item.setData("image_descriptor", (Object)newImage);
    }

    static void updateAction(ToolItem item, ResourceManager resources, IActionExt next) {
        if (next == null) {
            ActionUtil.setHoverImage(item, resources, null);
            ActionUtil.setImage(item, resources, null);
            return;
        }
        String text = next.getTooltipText();
        if (text.equals("")) {
            text = null;
        }
        if (!Util.equals((Object)text, (Object)item.getToolTipText())) {
            item.setToolTipText(text);
        }
        ActionUtil.setImage(item, resources, next.getImage());
        ActionUtil.setDisabledImage(item, resources, next.getDisabledImage());
        ActionUtil.setHoverImage(item, resources, next.getHoverImage());
        if (item.getEnabled() != next.isEnabled()) {
            item.setEnabled(next.isEnabled());
        }
        if (item.getSelection() != next.getSelection()) {
            item.setSelection(next.getSelection());
        }
    }

    static ToolItem createItem(ToolBar theMenu, ResourceManager mgr, int itemIndex, final IActionExt next) {
        int style = next.getStyle();
        if (style == 64) {
            style = 8;
        }
        final ToolItem item = new ToolItem(theMenu, style, itemIndex);
        IMenuExt children = next.getSubmenu();
        Menu theSubmenu = null;
        if (children != null) {
            theSubmenu = ActionUtil.createNestedMenu(item);
            new MenuViewer(theSubmenu, children);
        }
        final Menu submenu = theSubmenu;
        if (next.getStyle() == 64) {
            item.addListener(3, new Listener(){

                public void handleEvent(Event e) {
                    if (submenu != null) {
                        Point p = new Point(e.x, e.y);
                        p = Display.getCurrent().map((Control)item.getParent(), null, p);
                        submenu.setLocation(p);
                        submenu.setVisible(true);
                    }
                }
            });
        } else {
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail == 4) {
                        if (submenu != null) {
                            Point p = new Point(e.x, e.y);
                            p = Display.getCurrent().map((Control)item.getParent(), null, p);
                            submenu.setLocation(p);
                            submenu.setVisible(true);
                        }
                    } else {
                        next.run();
                    }
                }
            });
        }
        ActionUtil.updateAction(item, mgr, next);
        return item;
    }

    static MenuItem createItem(Menu theMenu, ResourceManager mgr, int itemIndex, final IActionExt next) {
        IMenuExt children;
        int style = next.getStyle();
        if (style == 4) {
            style = 8;
        }
        MenuItem item = new MenuItem(theMenu, style, itemIndex);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                next.run();
            }
        });
        if (style == 64 && (children = next.getSubmenu()) != null) {
            Menu submenu = ActionUtil.createNestedMenu(item);
            new MenuViewer(submenu, children);
        }
        ActionUtil.updateAction(item, mgr, next);
        return item;
    }

    private static Menu createNestedMenu(MenuItem parent) {
        final Menu submenu = new Menu(parent);
        parent.setMenu(submenu);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                submenu.dispose();
            }
        });
        return submenu;
    }

    private static Menu createNestedMenu(ToolItem parent) {
        final Menu submenu = new Menu((Control)parent.getParent());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                submenu.dispose();
            }
        });
        return submenu;
    }
}

