/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.databinding;

import com.ibm.team.repository.rcp.common.NullUtil;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;

public final class CrossRealmValue
extends AbstractObservableValue {
    private IObservableValue toObserve;
    private Object cachedValue = null;
    private boolean isDisposed = false;
    private Realm otherRealm;
    private IChangeListener changeListener = new IChangeListener(){

        public void handleChange(ChangeEvent event) {
            CrossRealmValue.this.updateValue();
        }
    };

    public CrossRealmValue(Realm theRealm, IObservableValue toObserve) {
        super(theRealm);
        this.otherRealm = toObserve.getRealm();
        this.toObserve = toObserve;
        if (this.otherRealm.isCurrent()) {
            this.attachListener();
        } else {
            this.otherRealm.asyncExec(new Runnable(){

                public void run() {
                    CrossRealmValue.this.attachListener();
                }
            });
        }
    }

    protected void attachListener() {
        this.toObserve.addChangeListener(this.changeListener);
        this.updateValue();
    }

    protected void updateValue() {
        if (!this.otherRealm.isCurrent()) {
            throw new IllegalStateException("Method invoked from wrong realm");
        }
        final Object newValue = this.toObserve.getValue();
        this.getRealm().asyncExec(new Runnable(){

            public void run() {
                if (CrossRealmValue.this.isDisposed) {
                    return;
                }
                Object oldValue = CrossRealmValue.this.cachedValue;
                if (!NullUtil.equals((Object)newValue, (Object)oldValue)) {
                    CrossRealmValue.this.cachedValue = newValue;
                    CrossRealmValue.this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)newValue));
                }
            }
        });
    }

    protected Object doGetValue() {
        return this.cachedValue;
    }

    public Object getValueType() {
        return new Object();
    }

    public synchronized void dispose() {
        this.isDisposed = true;
        this.otherRealm.asyncExec(new Runnable(){

            public void run() {
                CrossRealmValue.this.toObserve.removeChangeListener(CrossRealmValue.this.changeListener);
            }
        });
        super.dispose();
    }
}

