/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.UndoCmdOpts;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.rcp.core.operations.UndoChangesOperation;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.ProducesOrphansInConfigurationException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

public class UndoCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine subargs = config.getSubcommandCommandLine();
        List changeSelectors = subargs.getOptions((IOptionKey)UndoCmdOpts.OPT_CHANGES);
        boolean verbose = subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
        List workspaces = RepoUtil.getWorkspaceConnections((ICopyFileAreaView)cfaView, (boolean)true);
        ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
        for (IWorkspaceConnection wsConn : workspaces) {
            List cpHandles;
            try {
                cpHandles = wsConn.getComponents();
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.UndoCmd_12);
            }
            for (IComponentHandle cpHandle : cpHandles) {
                lcm.syncPendingChanges((IContextHandle)wsConn.getResolvedWorkspace(), cpHandle, cfaView.getRoot());
            }
        }
        LinkedList<ILocalChange> toUndoLocal = new LinkedList<ILocalChange>();
        HashMap toUndo = new HashMap();
        for (String changeSelector : changeSelectors) {
            Object wsConn3;
            boolean foundLocalChange = false;
            IPath changePath = SubcommandUtil.makePath((IClientConfiguration)config, (String)changeSelector);
            if (changePath != null) {
                changePath = changePath.makeAbsolute();
            }
            for (IWorkspaceConnection wsConn2 : workspaces) {
                List cpHandles;
                try {
                    cpHandles = wsConn2.getComponents();
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.UndoCmd_12);
                }
                for (IComponentHandle cpHandle : cpHandles) {
                    ILocalChange[] localChanges = lcm.getPendingChanges((IContextHandle)wsConn2.getResolvedWorkspace(), cpHandle, cfaView.getRoot());
                    ILocalChange[] iLocalChangeArray = localChanges;
                    int n = localChanges.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILocalChange localChange = iLocalChangeArray[n2];
                        if (localChange.getPath().equals((Object)changePath)) {
                            toUndoLocal.add(localChange);
                            foundLocalChange = true;
                            break;
                        }
                        ++n2;
                    }
                    if (foundLocalChange) break;
                }
                if (foundLocalChange) break;
            }
            if (foundLocalChange) continue;
            HashMap<IWorkspaceConnection, Object> curSelectorToUndo = new HashMap<IWorkspaceConnection, Object>();
            for (IWorkspaceConnection wsConn2 : workspaces) {
                Map tmpToUndo;
                try {
                    tmpToUndo = RepoUtil.findChangesByPath((IClientConfiguration)config, (IWorkspaceConnection)wsConn2, (String)changeSelector);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.UndoCmd_2);
                }
                if (tmpToUndo.isEmpty()) continue;
                curSelectorToUndo.put(wsConn2, tmpToUndo);
            }
            if (curSelectorToUndo.isEmpty()) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.UndoCmd_0, (Object)changeSelector));
            }
            boolean ambiguous = curSelectorToUndo.size() > 1;
            for (Object wsConn3 : curSelectorToUndo.keySet()) {
                Map tmpToUndo = (Map)curSelectorToUndo.get(wsConn3);
                ambiguous |= tmpToUndo.size() > 1;
                for (IChangeSetHandle csHandle : tmpToUndo.keySet()) {
                    ambiguous |= ((List)tmpToUndo.get(csHandle)).size() > 1;
                }
            }
            if (ambiguous) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.UndoCmd_3, (Object)changeSelector));
            }
            wsConn3 = curSelectorToUndo.keySet().iterator();
            while (wsConn3.hasNext()) {
                IWorkspaceConnection wsConn4 = (IWorkspaceConnection)wsConn3.next();
                if (!toUndo.containsKey(wsConn4)) {
                    toUndo.put(wsConn4, new HashMap());
                }
                Map csChangesDest = (Map)toUndo.get(wsConn4);
                Map csChangesSrc = (Map)curSelectorToUndo.get(wsConn4);
                for (IChangeSetHandle csHandle : csChangesSrc.keySet()) {
                    if (!csChangesDest.containsKey(csHandle)) {
                        csChangesDest.put(csHandle, new LinkedList());
                    }
                    List changesDest = (List)csChangesDest.get(csHandle);
                    changesDest.addAll((Collection)csChangesSrc.get(csHandle));
                }
            }
        }
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.enablePrinter(0);
        options.enablePrinter(1);
        options.enablePrinter(2);
        options.enablePrinter(8);
        options.enablePrinter(4);
        options.enablePrinter(6);
        options.enableFilter(0);
        options.enableFilter(1);
        options.enableFilter(2);
        options.enableFilter(4);
        options.enableFilter(6);
        HashMap<IWorkspaceConnection, UndoChangesOperation> undoers = new HashMap<IWorkspaceConnection, UndoChangesOperation>();
        for (IWorkspaceConnection wsConn : toUndo.keySet()) {
            UndoChangesOperation undoer = new UndoChangesOperation(wsConn, null);
            Map csChanges = (Map)toUndo.get(wsConn);
            undoers.put(wsConn, undoer);
            ArrayList csHandles = new ArrayList(csChanges.keySet());
            if (verbose) {
                List changeSets;
                options.addFilter((IItemHandle)wsConn.getResolvedWorkspace(), 0);
                try {
                    changeSets = wsConn.teamRepository().itemManager().fetchPartialItems(csHandles, 0, (Collection)Collections.singleton(IChangeSet.COMPONENT_PROPERTY), null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.UndoCmd_8);
                }
                for (IChangeSet cs : changeSets) {
                    options.addFilter((IItemHandle)cs.getComponent(), 1);
                }
            }
            for (IChangeSetHandle csHandle : csHandles) {
                List changes = (List)csChanges.get(csHandle);
                if (verbose) {
                    options.addFilter((IItemHandle)csHandle, 4);
                    for (IChange change : changes) {
                        options.addFilter((IItemHandle)change.item(), 6);
                    }
                }
                undoer.addChangesToUndo(csHandle, (Collection)changes);
            }
        }
        if (verbose) {
            for (ILocalChange localChange : toUndoLocal) {
                options.addFilter((IItemHandle)localChange.getShareable().getVersionable(), 2);
                options.addFilter((IItemHandle)localChange.getComponent(), 1);
                options.addFilter((IItemHandle)localChange.getConnection(), 0);
            }
            IndentingPrintStream ps = new IndentingPrintStream((OutputStream)System.out);
            if (config.isDryRun()) {
                ps.println((CharSequence)Messages.UndoCmd_4);
            } else {
                ps.println((CharSequence)Messages.UndoCmd_5);
            }
            PendingChangesUtil.printPendingChanges((boolean)false, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)ps.indent());
        }
        if (!config.isDryRun()) {
            try {
                lcm.undoChanges(toUndoLocal.toArray(new ILocalChange[0]), null, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.UndoCmd_14);
            }
            for (IWorkspaceConnection wsConn : undoers.keySet()) {
                try {
                    ((UndoChangesOperation)undoers.get(wsConn)).run(null);
                }
                catch (ProducesOrphansInConfigurationException e) {
                    throw StatusHelper.orphan((String)Messages.UndoCmd_10, (ProducesOrphansInConfigurationException)e);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.UndoCmd_6);
                }
            }
        }
    }
}

