/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.DownloadProgressWriter;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LoadCmdLauncher;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LoadCmdOptions;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILoadRule;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.rcp.core.IEclipseFileSystemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadCmd {
    public void run(IClientConfiguration config, ConnectionInfo connectionInfo, String wsSelector, List<String> cSelectors, boolean getAll, LoadCmdLauncher.LoadRuleConfig loadRuleConfig, boolean quiet) throws FileSystemClientException {
        IWorkspaceConnection wsConn;
        IWorkspaceHandle wsHandle;
        ResourcesPlugin.getWorkspace();
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)connectionInfo);
        try {
            wsHandle = RepoUtil.findNamedWorkspace((String)wsSelector, (boolean)true, (boolean)false, (ITeamRepository)repo);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.LoadCmd_2, (Object)wsSelector));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.LoadCmd_3, (Object)wsSelector));
        }
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        try {
            wsConn = manager.getWorkspaceConnection(wsHandle, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)NLS.bind((String)Messages.LoadCmd_4, (Object)wsSelector));
        }
        List<IComponentHandle> cHandles = this.getComponents(cSelectors, getAll, wsConn, repo);
        if (loadRuleConfig != null && cHandles.size() != 1) {
            String optName = config.getSubcommandCommandLine().getDefinition().getOption(LoadCmdOptions.OPT_REMOTE_LOADRULE_PATH).getName();
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmd_0, (Object)optName));
        }
        if (cHandles.size() < 1) {
            throw StatusHelper.disallowed((String)Messages.LoadCmd_5);
        }
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        }
        catch (CoreException e) {
            throw StatusHelper.failure((String)Messages.LoadCmd_6, (Throwable)e);
        }
        LoadProblemHandler handler = this.getHandler(config, cHandles);
        try {
            ILoadOperation op = IEclipseFileSystemManager.instance.getLoadOperation((LoadDilemmaHandler)handler);
            for (IComponentHandle component : cHandles) {
                Map children = wsConn.configuration(component).childEntriesForRoot(null);
                ArrayList<IFolderHandle> foldersToLoad = new ArrayList<IFolderHandle>(children.size());
                for (IVersionableHandle child : children.values()) {
                    if (!(child instanceof IFolderHandle)) continue;
                    foldersToLoad.add((IFolderHandle)child);
                }
                if (loadRuleConfig == null) {
                    op.requestLoad(wsConn, component, foldersToLoad);
                    continue;
                }
                List<ILoadRule> loadRules = this.populateLoadRuleFor(wsConn, component, loadRuleConfig);
                op.requestLoad(loadRules, null);
            }
            DownloadProgressWriter writer = null;
            if (!quiet) {
                writer = new DownloadProgressWriter((IProgressMonitor)new NullProgressMonitor(), false, quiet);
            }
            op.run(writer);
            if (writer != null) {
                writer.join();
            }
        }
        catch (OperationCanceledException e) {
            if (handler.failedDueToCollision() || handler.failedDueToOnDiskItem()) {
                StringBuffer msg = new StringBuffer(Messages.LoadCmd_7);
                if (handler.failedDueToCollision()) {
                    msg.append(Messages.LoadCmd_8);
                }
                if (handler.failedDueToOnDiskItem()) {
                    msg.append(Messages.LoadCmd_9);
                }
                throw StatusHelper.collision((String)msg.toString());
            }
            throw StatusHelper.failure((String)Messages.LoadCmd_10, (Throwable)e);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.LoadCmd_11);
        }
    }

    private List<IComponentHandle> getComponents(List<String> selectors, boolean getAll, IWorkspaceConnection wsConn, ITeamRepository repo) throws FileSystemClientException {
        List handles;
        if (selectors == null) {
            try {
                return wsConn.getComponents();
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.LoadCmd_13);
            }
        }
        try {
            handles = RepoUtil.findNamedComponents(selectors, (boolean)getAll, (IWorkspaceConnection)wsConn, (ITeamRepository)repo);
        }
        catch (RepoUtil.SelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e);
            throw StatusHelper.ambiguousSelector((String)Messages.LoadCmd_14);
        }
        return handles;
    }

    private LoadProblemHandler getHandler(IClientConfiguration config, List<IComponentHandle> cHandles) {
        ICommandLine subargs = config.getSubcommandCommandLine();
        return new OrderedLoadProblemHandler(subargs.hasOption((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR) ? cHandles : null, subargs.hasOption(LoadCmdOptions.OPT_FORCE));
    }

    public List<ILoadRule> populateLoadRuleFor(IWorkspaceConnection wsConn, IComponentHandle cHandle, LoadCmdLauncher.LoadRuleConfig loadRuleConfig) throws TeamRepositoryException, FileSystemClientException {
        String filename;
        InputStream in;
        assert (loadRuleConfig != null);
        ILoadRule loadRule = ILoadRule.loadRuleFactory.createLoadRule(wsConn, cHandle);
        IConfiguration config = wsConn.configuration(cHandle);
        if (loadRuleConfig instanceof LoadCmdLauncher.RemoteLoadRuleConfig) {
            LoadCmdLauncher.RemoteLoadRuleConfig remoteRule = (LoadCmdLauncher.RemoteLoadRuleConfig)loadRuleConfig;
            String[] path = StringUtil.splitEscapedPath((String)remoteRule.remotePath);
            IVersionableHandle fileHandle = config.resolvePath(config.rootFolderHandle(null), path, null);
            if (fileHandle == null) {
                String componentName = cHandle.getItemId().getUuidValue();
                try {
                    IComponent comp = (IComponent)wsConn.teamRepository().itemManager().fetchCompleteItem((IItemHandle)cHandle, 0, null);
                    componentName = comp.getName();
                }
                catch (TeamRepositoryException e) {
                    LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.cli.client", Messages.LoadCmd_26, (Throwable)e));
                }
                throw StatusHelper.misconfiguredRemoteFS((String)NLS.bind((String)Messages.LoadCmd_27, (Object)StringUtil.createPathString((String[])path), (Object)componentName));
            }
            if (!(fileHandle instanceof IFileItemHandle)) {
                throw StatusHelper.misconfiguredRemoteFS((String)NLS.bind((String)Messages.LoadCmd_28, (Object)StringUtil.createPathString((String[])path)));
            }
            try {
                loadRule.addLoadRules((IFileItemHandle)fileHandle, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.misconfiguredRemoteFS((String)NLS.bind((String)Messages.LoadCmd_29, (Object)StringUtil.createPathString((String[])path), (Object)e.getMessage()));
            }
        }
        assert (loadRuleConfig instanceof LoadCmdLauncher.LocalLoadRuleConfig);
        LoadCmdLauncher.LocalLoadRuleConfig localRule = (LoadCmdLauncher.LocalLoadRuleConfig)loadRuleConfig;
        if ("-".equals(localRule.localPath)) {
            in = System.in;
            filename = Messages.LoadCmd_30;
        } else {
            File localFile = new File(localRule.localPath);
            try {
                filename = localFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                filename = localRule.localPath;
            }
            if (!localFile.exists()) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmd_31, (Object)filename));
            }
            if (!localFile.isFile()) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmd_32, (Object)filename));
            }
            try {
                in = new FileInputStream(localFile);
            }
            catch (FileNotFoundException e) {
                throw StatusHelper.misconfiguredLocalFS((String)NLS.bind((String)Messages.LoadCmd_33, (Object)filename, (Object)e.getMessage()));
            }
        }
        try {
            loadRule.addLoadRules(in, Charset.defaultCharset().name(), null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.misconfiguredRemoteFS((String)NLS.bind((String)Messages.LoadCmd_34, (Object)filename, (Object)e.getMessage()));
        }
        return Collections.singletonList(loadRule);
    }

    static abstract class LoadProblemHandler
    extends LoadDilemmaHandler {
        boolean failedDueToMultiComponentCollision = false;
        boolean failedDueToOnDiskItem = false;

        LoadProblemHandler() {
        }

        public boolean failedDueToCollision() {
            return this.failedDueToMultiComponentCollision;
        }

        public boolean failedDueToOnDiskItem() {
            return this.failedDueToOnDiskItem;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrderedLoadProblemHandler
    extends LoadProblemHandler {
        final List<IComponentHandle> cHandles;
        final boolean overwrite;
        final MultiStatus failures;

        public OrderedLoadProblemHandler(List<IComponentHandle> handles, boolean force) {
            this.cHandles = handles;
            this.overwrite = force;
            this.failures = new MultiStatus("com.ibm.team.filesystem.cli.client", -1, Messages.LoadCmd_15, null);
        }

        public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
            for (ICollision collision : collisions) {
                ILoadLocation target = null;
                if (collision.getLocations().size() > 1) {
                    if (this.cHandles == null) {
                        this.reportMulticomponentCollision(collision);
                        this.failedDueToMultiComponentCollision = true;
                        return 1;
                    }
                    try {
                        target = this.getPreferredLoadLocation(collision);
                    }
                    catch (FileSystemClientException e) {
                        this.failures.add(e.getStatus());
                        return 2;
                    }
                }
                if (collision.collidedWithExistingContent()) {
                    if (this.overwrite) {
                        if (target == null) {
                            target = this.getFirstLoadLocation(collision);
                        }
                    } else {
                        IShareable shareable = collision.getShareable();
                        System.err.println(NLS.bind((String)Messages.LoadCmd_16, (Object)shareable.getLocalFullPath()));
                        this.failedDueToOnDiskItem = true;
                        return 1;
                    }
                }
                collision.setLoadLocation(target);
            }
            return 0;
        }

        private ILoadLocation getPreferredLoadLocation(ICollision collision) throws FileSystemClientException {
            for (IComponentHandle cHandle : this.cHandles) {
                for (ILoadLocation location : collision.getLocations()) {
                    if (!cHandle.sameItemId((IItemHandle)location.getComponent())) continue;
                    collision.setLoadLocation(location);
                    return location;
                }
            }
            throw StatusHelper.failure((String)Messages.LoadCmd_18, null);
        }

        private ILoadLocation getFirstLoadLocation(ICollision c) {
            return (ILoadLocation)c.getLocations().iterator().next();
        }

        private void reportMulticomponentCollision(ICollision collision) {
            IndentingPrintStream err = new IndentingPrintStream((OutputStream)System.err);
            err.println((CharSequence)NLS.bind((String)Messages.LoadCmd_22, (Object)this.getFirstLoadLocation(collision).getShareName()));
            err = err.indent();
            for (ILoadLocation location : collision.getLocations()) {
                err.println((CharSequence)NLS.bind((String)Messages.LoadCmd_24, (Object)AliasUtil.selector((String)location.getComponent().getName(), (UUID)location.getComponent().getItemId())));
            }
        }
    }
}

