/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LastModCmdOpts;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommand;
import com.ibm.team.filesystem.cli.core.util.ChattyRepoRunnable;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastModCmd
implements ISubcommand {
    private IClientConfiguration config;
    private static DateFormat shortDateFormat = new SimpleDateFormat("yyyyMMddhhmm");

    public void run(IClientConfiguration config) throws FileSystemClientException {
        this.config = config;
        try {
            this.execute();
        }
        finally {
            FileSystemCore.shutDown();
        }
    }

    private List<IShareable> consumeArguments(ICopyFileAreaView cfaView) throws FileSystemClientException {
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        shortDateFormat = new SimpleDateFormat(subargs.getOption((IOptionKey)LastModCmdOpts.OPT_DATE_FORMAT, "yyyyMMddhhmm"));
        List paths = subargs.getOptions((IOptionKey)LastModCmdOpts.OPT_TO_CALCULATE);
        return this.findFoldersInCFA(cfaView, paths);
    }

    private List<IShareable> findFoldersInCFA(ICopyFileAreaView cfaView, List<String> strPaths) throws FileSystemClientException {
        Path cfaRoot = new Path(this.config.getCurrentWorkingDirectory().getAbsolutePath());
        List paths = SubcommandUtil.makeAbsolutePaths((IPath)cfaRoot, strPaths);
        if (paths.contains(cfaRoot)) {
            IShare[] shares = cfaView.getLoadedShares();
            ArrayList<IShareable> commitRoots = new ArrayList<IShareable>(shares.length);
            IShare[] iShareArray = shares;
            int n = shares.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                commitRoots.add(SubcommandUtil.makeShareable((IShare)share));
                ++n2;
            }
            return commitRoots;
        }
        ArrayList<IShareable> commitRoots = new ArrayList<IShareable>(strPaths.size());
        for (IPath path : paths) {
            IShareable shareable = cfaView.findShareable(path);
            if (shareable.getShare() == null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LastModCmd_0, (Object)path));
            }
            commitRoots.add(shareable);
        }
        return commitRoots;
    }

    private Map<ItemId<IItem>, List<IShareable>> groupShareablesByConnection(List<IShareable> commitRoots) {
        HashMap<ItemId<IItem>, List<IShareable>> map = new HashMap<ItemId<IItem>, List<IShareable>>();
        for (IShareable shareable : commitRoots) {
            IShare share = shareable.getShare();
            IContextHandle handle = share.getSharingDescriptor().getConnectionHandle();
            ItemId id = ItemId.create((IItemHandle)handle);
            SubcommandUtil.addToMapOfLists(map, (Object)id, (Object)shareable);
        }
        return map;
    }

    private void verifyRoots(List<IShareable> commitRoots) throws FileSystemClientException {
        for (IShareable shareable : commitRoots) {
            IResource resource = (IResource)shareable.getAdapter(IResource.class);
            if (!resource.exists()) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LastModCmd_1, (Object)shareable.getLocalFullPath().toPortableString()));
            }
            if (shareable.getShare() != null) continue;
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LastModCmd_2, (Object)shareable.getLocalFullPath().toPortableString()));
        }
    }

    private void refreshRoots(List<IShareable> commitRoots) throws FileSystemClientException {
        for (IShareable shareable : commitRoots) {
            IResource resource = (IResource)shareable.getAdapter(IResource.class);
            try {
                resource.refreshLocal(2, null);
            }
            catch (CoreException e) {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.LastModCmd_3, (Object)shareable.getLocalFullPath()), (Throwable)e);
            }
        }
    }

    private void execute() throws FileSystemClientException {
        ResourcesPlugin.getWorkspace().getRoot();
        ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)this.config);
        List<IShareable> commitRoots = this.consumeArguments(cfaView);
        this.refreshRoots(commitRoots);
        this.verifyRoots(commitRoots);
        final Map<ItemId<IItem>, List<IShareable>> groupedByContext = this.groupShareablesByConnection(commitRoots);
        final HashMap item2conn = new HashMap();
        ChattyRepoRunnable runnable = new ChattyRepoRunnable(this.config){

            public void run(ICopyFileAreaView cfa, ICopyFileAreaView.IRepoView view, IWorkspaceConnection wsConn) throws FileSystemClientException {
                ItemId repoId = view.getItemId();
                for (ItemId candidateId : groupedByContext.keySet()) {
                    if (!candidateId.equals((Object)repoId)) continue;
                    item2conn.put(candidateId, wsConn);
                }
            }
        };
        cfaView.runOnEachRepo((ICopyFileAreaView.IRepoRunnable)runnable, this.config, (IOptionKey)CommonOptions.OPT_USERNAME, (IOptionKey)CommonOptions.OPT_PASSWORD);
        if (runnable.hadLoginFailure()) {
            throw StatusHelper.login();
        }
        if (this.config.isDryRun()) {
            return;
        }
        for (Map.Entry entry : item2conn.entrySet()) {
            this.commit((IWorkspaceConnection)entry.getValue(), groupedByContext.get(entry.getKey()));
        }
    }

    private void commit(IWorkspaceConnection wsConn, List<IShareable> shareables) throws FileSystemClientException {
        Map<ItemId<IComponent>, List<IShareable>> groupedByComponent = this.groupByComponent(shareables);
        for (Map.Entry<ItemId<IComponent>, List<IShareable>> entry : groupedByComponent.entrySet()) {
            IComponentHandle compHandle = (IComponentHandle)entry.getKey().toHandle();
            IShareable[] toCommit = new IShareable[entry.getValue().size()];
            toCommit = entry.getValue().toArray(toCommit);
            ArrayList<IFolderHandle> folders = new ArrayList<IFolderHandle>(toCommit.length);
            ArrayList<IShareable> folderShareables = new ArrayList<IShareable>(toCommit.length);
            int i = 0;
            while (i < toCommit.length) {
                IShareable shareable = toCommit[i];
                IVersionableHandle handle = shareable.getVersionable();
                if (handle instanceof IFolderHandle) {
                    folders.add((IFolderHandle)handle);
                    folderShareables.add(shareable);
                } else {
                    StatusHelper.createException((String)NLS.bind((String)Messages.LastModCmd_5, (Object)shareable.getLocalFullPath().toPortableString()), (int)4, null);
                }
                ++i;
            }
            FailProblemHandler handler = new FailProblemHandler();
            try {
                List baselines = wsConn.getMostRecentBaselinesAffecting(compHandle, folders, null);
                int i2 = 0;
                while (i2 < baselines.size()) {
                    IBaseline baseline = (IBaseline)baselines.get(i2);
                    IShareable shareable = (IShareable)folderShareables.get(i2);
                    System.out.println(NLS.bind((String)Messages.LastModCmd_6, (Object)shareable.getLocalFullPath().toOSString(), (Object)shortDateFormat.format(baseline.getCreationDate())));
                    ++i2;
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                if (!handler.failedDueToOutOfSync()) continue;
                throw StatusHelper.outOfSync((String)Messages.LastModCmd_7);
            }
            catch (TeamRepositoryException e) {
                StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.LastModCmd_8);
            }
        }
    }

    private Map<ItemId<IComponent>, List<IShareable>> groupByComponent(List<IShareable> shareables) {
        HashMap<ItemId<IComponent>, List<IShareable>> grouped = new HashMap<ItemId<IComponent>, List<IShareable>>();
        for (IShareable shareable : shareables) {
            IComponentHandle comp = shareable.getShare().getSharingDescriptor().getComponent();
            ItemId id = new ItemId(IComponent.ITEM_TYPE, comp.getItemId());
            SubcommandUtil.addToMapOfLists(grouped, (Object)id, (Object)shareable);
        }
        return grouped;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FailProblemHandler
    extends CommitDilemmaHandler {
        boolean failedDueToOutOfSync = false;

        private FailProblemHandler() {
        }

        public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
            System.out.println(Messages.LastModCmd_9);
            for (IShareOutOfSync oos : sharesOutOfSync) {
                System.out.println("  " + oos.getShare().getPath());
            }
            this.failedDueToOutOfSync = true;
            return 1;
        }

        public boolean willIgnoreAllSharesOutOfSync() {
            return false;
        }

        public boolean failedDueToOutOfSync() {
            return this.failedDueToOutOfSync;
        }
    }
}

