/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.ChangeDisplayer;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ConflictsCmdOpts;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ChattyRepoRunnable;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class ConflictsCmd
extends AbstractSubcommand {
    boolean verbose;
    boolean quiet;

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine subargs = config.getSubcommandCommandLine();
        this.verbose = subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        this.quiet = subargs.hasOption((IOptionKey)CommonOptions.OPT_QUIET);
        String mine = subargs.getOption((IOptionKey)ConflictsCmdOpts.OPT_CONFLICTS_MINE, null);
        String proposed = subargs.getOption((IOptionKey)ConflictsCmdOpts.OPT_CONFLICTS_PROPOSED, null);
        if (mine != null && proposed != null) {
            throw StatusHelper.argSyntax((String)Messages.ConflictsCmd_1);
        }
        if (mine == null && proposed == null) {
            this.showList(config);
            return;
        }
        Path path = mine != null ? new Path(mine) : new Path(proposed);
        ICopyFileAreaView cfa = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
        ConflictByPathResult result = this.findConflictByPath(config, cfa, (IPath)path);
        if (result == null) {
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ConflictsCmd_2, (Object)path.toString()));
        }
        if (!result.logical.isChangeType(4)) {
            throw StatusHelper.argSyntax((String)Messages.ConflictsCmd_3);
        }
        IVersionableHandle state = mine != null ? result.report.getOriginalSelectedContributorState() : result.report.getProposedContributorState();
        InputStream in = RepoUtil.findContentFor((ITeamRepository)result.wsConn.teamRepository(), (IPath)path, (IVersionableHandle)state);
        try {
            RepoUtil.transfer((InputStream)in, (OutputStream)System.out);
        }
        catch (IOException e) {
            throw StatusHelper.failure((String)Messages.ConflictsCmd_4, (Throwable)e);
        }
    }

    private ConflictByPathResult findConflictByPath(IClientConfiguration config, ICopyFileAreaView cfa, IPath item) throws FileSystemClientException {
        final String[] segments = item.segments();
        final ConflictByPathResult[] result = new ConflictByPathResult[1];
        ChattyRepoRunnable runnable = new ChattyRepoRunnable(config){

            public void run(ICopyFileAreaView cfa, ICopyFileAreaView.IRepoView view, IWorkspaceConnection wsConn) throws FileSystemClientException {
                ILogicalConflictReport conflictReport;
                IUpdateReport report = wsConn.conflictReport();
                IFileSystemView fsv = FileSystemCore.getFileSystemManager((ITeamRepository)wsConn.teamRepository()).getFileSystemView((IConnection)wsConn);
                try {
                    conflictReport = fsv.interpretConflicts(cfa.getRoot(), report.conflicts(), null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.ConflictsCmd_6);
                }
                for (IComponentHandle comp : ItemLists.idsToHandles((Collection)cfa.getLoadedComponents(view))) {
                    for (ILogicalConflict conflict : conflictReport.getConflictsForComponent(comp)) {
                        if (!Arrays.equals(segments, conflict.getPathHint())) continue;
                        for (IItemConflictReport itemReport : report.getConflictsForComponent(comp)) {
                            if (!conflict.item().sameItemId((IItemHandle)itemReport.item())) continue;
                            result[0] = new ConflictByPathResult(wsConn, conflict, itemReport);
                            return;
                        }
                    }
                }
            }
        };
        cfa.runOnEachRepo((ICopyFileAreaView.IRepoRunnable)runnable, config, (IOptionKey)CommonOptions.OPT_USERNAME, (IOptionKey)CommonOptions.OPT_USERNAME);
        if (runnable.hadLoginFailure()) {
            throw StatusHelper.login(null, null);
        }
        return result[0];
    }

    protected void showList(IClientConfiguration config) throws FileSystemClientException {
        final boolean[] hasConflicts = new boolean[1];
        ICopyFileAreaView cfa = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
        ChattyRepoRunnable runnable = new ChattyRepoRunnable(config){

            public void run(ICopyFileAreaView cfa, ICopyFileAreaView.IRepoView view, IWorkspaceConnection wsConn) throws FileSystemClientException {
                IUpdateReport report = wsConn.conflictReport();
                if (!hasConflicts[0]) {
                    for (ItemId itemId : cfa.getLoadedComponents(view)) {
                        boolean bl = hasConflicts[0] = report.getConflictsForComponent((IComponentHandle)itemId.toHandle()).size() > 0;
                    }
                }
                ChangeDisplayer.showConflicts(wsConn, cfa.getRoot(), report, new IndentingPrintStream((OutputStream)System.out));
            }
        };
        cfa.runOnEachRepo((ICopyFileAreaView.IRepoRunnable)runnable, config, (IOptionKey)CommonOptions.OPT_USERNAME, (IOptionKey)CommonOptions.OPT_PASSWORD);
        if (runnable.hadLoginFailure()) {
            if (hasConflicts[0]) {
                throw StatusHelper.login((String)Messages.ConflictsCmd_8, null);
            }
            throw StatusHelper.login((String)Messages.ConflictsCmd_9, null);
        }
        if (hasConflicts[0]) {
            throw StatusHelper.conflict((String)Messages.ConflictsCmd_10);
        }
    }

    private static class ConflictByPathResult {
        final IWorkspaceConnection wsConn;
        final ILogicalConflict logical;
        final IItemConflictReport report;

        ConflictByPathResult(IWorkspaceConnection wsConn, ILogicalConflict logical, IItemConflictReport report) {
            this.wsConn = wsConn;
            this.logical = logical;
            this.report = report;
        }
    }
}

