/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.CheckInCmdOptions;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ChattyRepoRunnable;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.utils.ExceptionUtil;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IFailedUpload;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.rcp.core.operations.NewCheckInOperation;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.utils.ContentLineDelimiterError;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.ItemAlreadyInActiveChangeSetException;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckInCmd
extends AbstractSubcommand {
    IClientConfiguration config;
    DelimiterControl delimPolicy = DelimiterControl.FAIL_ON_ERROR;
    String csSelector = null;

    public void run(IClientConfiguration config) throws FileSystemClientException {
        this.config = config;
        try {
            this.execute();
        }
        finally {
            FileSystemCore.shutDown();
        }
    }

    private List<IShareable> consumeArguments(ICopyFileAreaView cfaView) throws FileSystemClientException {
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        if (!subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_TO_COMMIT)) {
            throw StatusHelper.argSyntax((String)Messages.CheckInCmd_0);
        }
        List paths = subargs.getOptions((IOptionKey)CheckInCmdOptions.OPT_TO_COMMIT);
        this.csSelector = subargs.getOption((IOptionKey)CheckInCmdOptions.OPT_COMMIT_TARGET, null);
        if (subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_DELIM_CONSISTENT) && subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_DELIM_NONE)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CheckInCmd_MAY_NOT_SPECIFY_BOTH_DELIM_ARGS, (Object)CheckInCmdOptions.OPT_DELIM_CONSISTENT.toString(), (Object)CheckInCmdOptions.OPT_DELIM_NONE.toString()));
        }
        if (subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_DELIM_CONSISTENT)) {
            this.delimPolicy = DelimiterControl.REWRITE;
        } else if (subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_DELIM_NONE)) {
            this.delimPolicy = DelimiterControl.SET_NO_DELIM;
        }
        return this.findCommitRoots(cfaView, paths);
    }

    private List<IShareable> findCommitRoots(ICopyFileAreaView cfaView, List<String> strPaths) throws FileSystemClientException {
        Path cwd = new Path(this.config.getCurrentWorkingDirectory().getAbsolutePath());
        List paths = SubcommandUtil.makeAbsolutePaths((IPath)cwd, strPaths);
        if (paths.contains(cwd)) {
            IShare[] shares = cfaView.getLoadedShares();
            ArrayList<IShareable> commitRoots = new ArrayList<IShareable>(shares.length);
            IShare[] iShareArray = shares;
            int n = shares.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                commitRoots.add(SubcommandUtil.makeShareable((IShare)share));
                ++n2;
            }
            return commitRoots;
        }
        ArrayList<IShareable> commitRoots = new ArrayList<IShareable>(strPaths.size());
        for (IPath path : paths) {
            IShareable shareable = cfaView.findShareable(path);
            if (shareable.getShare() == null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CheckInCmd_1, (Object)path));
            }
            commitRoots.add(shareable);
        }
        return commitRoots;
    }

    private Map<ItemId<IItem>, List<IShareable>> groupShareablesByConnection(List<IShareable> commitRoots) {
        HashMap<ItemId<IItem>, List<IShareable>> map = new HashMap<ItemId<IItem>, List<IShareable>>();
        for (IShareable shareable : commitRoots) {
            IShare share = shareable.getShare();
            assert (share != null);
            IContextHandle handle = share.getSharingDescriptor().getConnectionHandle();
            ItemId id = ItemId.create((IItemHandle)handle);
            SubcommandUtil.addToMapOfLists(map, (Object)id, (Object)shareable);
        }
        return map;
    }

    private void execute() throws FileSystemClientException {
        ResourcesPlugin.getWorkspace().getRoot();
        ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)this.config);
        List<IShareable> commitRoots = this.consumeArguments(cfaView);
        this.refreshRoots(commitRoots);
        this.verifyRoots(commitRoots);
        final Map<ItemId<IItem>, List<IShareable>> groupedByContext = this.groupShareablesByConnection(commitRoots);
        final HashMap item2conn = new HashMap();
        ChattyRepoRunnable runnable = new ChattyRepoRunnable(this.config){

            public void run(ICopyFileAreaView cfa, ICopyFileAreaView.IRepoView view, IWorkspaceConnection wsConn) throws FileSystemClientException {
                ItemId repoId = view.getItemId();
                for (ItemId candidateId : groupedByContext.keySet()) {
                    if (!candidateId.equals((Object)repoId)) continue;
                    item2conn.put(candidateId, wsConn);
                }
            }
        };
        cfaView.runOnEachRepo((ICopyFileAreaView.IRepoRunnable)runnable, this.config, (IOptionKey)CommonOptions.OPT_USERNAME, (IOptionKey)CommonOptions.OPT_PASSWORD);
        if (runnable.hadLoginFailure()) {
            throw StatusHelper.login();
        }
        if (this.config.isDryRun()) {
            return;
        }
        LinkedList<Status> displayExceptions = new LinkedList<Status>();
        IndentingPrintStream out = new IndentingPrintStream((OutputStream)System.out);
        out.println((CharSequence)Messages.CheckInCmd_19);
        for (Map.Entry entry : item2conn.entrySet()) {
            Collection<IChangeSetHandle> csHandles = this.commit((IWorkspaceConnection)entry.getValue(), groupedByContext.get(entry.getKey()));
            try {
                this.showCommit((IWorkspaceConnection)entry.getValue(), new ArrayList<IChangeSetHandle>(csHandles), out);
            }
            catch (FileSystemClientException e) {
                displayExceptions.add(new Status(4, "com.ibm.team.filesystem.cli.client", Messages.CheckInCmd_20, (Throwable)e));
            }
            catch (TeamRepositoryException e) {
                displayExceptions.add(new Status(4, "com.ibm.team.filesystem.cli.client", Messages.CheckInCmd_21, (Throwable)e));
            }
        }
        if (displayExceptions.size() > 0) {
            System.err.println(Messages.CheckInCmd_22);
            if (displayExceptions.size() == 1) {
                LoggingHelper.log((IStatus)((IStatus)displayExceptions.get(0)));
            } else {
                LoggingHelper.log((IStatus)new MultiStatus("com.ibm.team.filesystem.cli.client", -1, displayExceptions.toArray(new IStatus[0]), Messages.CheckInCmd_23, null));
            }
        }
    }

    private void showCommit(IWorkspaceConnection wsConn, List<IChangeSetHandle> csHandles, IndentingPrintStream out) throws TeamRepositoryException, FileSystemClientException {
        PendingChangesUtil.PendingChangesOptions opts = new PendingChangesUtil.PendingChangesOptions();
        if (csHandles.isEmpty()) {
            return;
        }
        IItemManager man = wsConn.teamRepository().itemManager();
        List csComplete = man.fetchCompleteItems(csHandles, 0, null);
        opts.enableFilter(1);
        opts.enableFilter(4);
        opts.addFilters(csHandles, 4);
        for (IChangeSet cs : csComplete) {
            opts.addFilter((IItemHandle)cs.getComponent(), 1);
        }
        opts.enablePrinter(0);
        opts.enablePrinter(1);
        opts.enablePrinter(8);
        opts.enablePrinter(4);
        PendingChangesUtil.printWorkspace((IWorkspaceConnection)wsConn, (PendingChangesUtil.PendingChangesOptions)opts, (IndentingPrintStream)out);
    }

    private void verifyRoots(List<IShareable> commitRoots) throws FileSystemClientException {
        for (IShareable shareable : commitRoots) {
            IResource resource = (IResource)shareable.getAdapter(IResource.class);
            if (!resource.exists()) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CheckInCmd_3, (Object)shareable.getLocalFullPath().toPortableString()));
            }
            if (shareable.getShare() != null) continue;
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CheckInCmd_4, (Object)shareable.getLocalFullPath().toPortableString()));
        }
        if (this.csSelector != null) {
            IComponentHandle compHandle = null;
            for (IShareable shareable : commitRoots) {
                ISharingDescriptor desc = shareable.getShare().getSharingDescriptor();
                if (compHandle == null) {
                    compHandle = desc.getComponent();
                    continue;
                }
                if (compHandle.sameItemId((IItemHandle)desc.getComponent())) continue;
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.CheckInCmd_26, (Object)commitRoots.get(0).getLocalFullPath(), (Object)shareable.getLocalFullPath()));
            }
        }
    }

    private void refreshRoots(List<IShareable> commitRoots) throws FileSystemClientException {
        for (IShareable shareable : commitRoots) {
            IResource resource = (IResource)shareable.getAdapter(IResource.class);
            try {
                resource.refreshLocal(2, null);
            }
            catch (CoreException e) {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.CheckInCmd_5, (Object)shareable.getLocalFullPath()), (Throwable)e);
            }
        }
    }

    private IChangeSetHandle findActiveChangeSet(IWorkspaceConnection wsConn, IComponentHandle comp, String csSelector) throws FileSystemClientException {
        UUID uuid = RepoUtil.lookupUuid((String)csSelector);
        if (uuid == null) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.CheckInCmd_34, (Object)csSelector));
        }
        List candidates = wsConn.activeChangeSets(comp);
        for (IChangeSetHandle csHandle : candidates) {
            if (!uuid.equals((Object)csHandle.getItemId())) continue;
            return csHandle;
        }
        throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CheckInCmd_30, (Object)csSelector));
    }

    /*
     * Unable to fully structure code
     */
    private Collection<IChangeSetHandle> commit(IWorkspaceConnection wsConn, List<IShareable> shareables) throws FileSystemClientException {
        groupedByComponent = this.groupByComponent(shareables);
        csHandles = new ArrayList<IChangeSetHandle>(groupedByComponent.size());
        for (Map.Entry<ItemId<IComponent>, List<IShareable>> entry : groupedByComponent.entrySet()) {
            compHandle = (IComponentHandle)entry.getKey().toHandle();
            toCommit = new IShareable[entry.getValue().size()];
            toCommit = entry.getValue().toArray(toCommit);
            handler = new FailProblemHandler();
            if (this.csSelector == null) {
                op = new NewCheckInOperation(wsConn, compHandle, toCommit, "", (CommitDilemmaHandler)handler);
            } else {
                csHandle = this.findActiveChangeSet(wsConn, compHandle, this.csSelector);
                op = new NewCheckInOperation(wsConn, compHandle, toCommit, csHandle, null);
            }
            try {
                op.run(null);
                csHandles.addAll(op.getCommittedChangeSets());
                continue;
            }
            catch (ItemAlreadyInActiveChangeSetException e) {
                desc = e.getErrorDescription();
                throw StatusHelper.disallowed((String)NLS.bind((String)Messages.CheckInCmd_38, (Object[])new String[]{desc.getItemsPathInConfiguration(), AliasUtil.alias((IItemHandle)desc.getAttemptedTargetChangeSet()), AliasUtil.alias((IItemHandle)desc.getChangeSetWhichContainsItem())}));
            }
            catch (FileSystemClientException e) {
                type = this.computeErrorType(e);
                if (type == ErrorType.OTHER_CAUSE) {
                    throw e;
                }
                err = new IndentingPrintStream((OutputStream)System.err);
                err.println((CharSequence)Messages.CheckInCmd_17);
                err = err.indent();
                ** for (s : handler.failedUploades)
            }
lbl-1000:
            // 1 sources

            {
                err.println((CharSequence)s.getLocalFullPath().toString());
                continue;
            }
lbl31:
            // 1 sources

            if (type == ErrorType.ENTIRELY_DUE_TO_CHAR_CONVERSION) {
                throw StatusHelper.malformedInput((String)Messages.CheckInCmd_7);
            }
            throw e;
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.CheckInCmd_8);
            }
            catch (OperationCanceledException v0) {
                if (!handler.failedDueToOutOfSync()) continue;
                throw StatusHelper.outOfSync((String)Messages.CheckInCmd_9);
            }
        }
        return csHandles;
    }

    private ErrorType computeErrorType(FileSystemClientException e) {
        List exceptions = ExceptionUtil.flattenThrowable((Throwable)e);
        if (exceptions.size() <= 0) {
            return ErrorType.OTHER_CAUSE;
        }
        boolean hasCharConversionError = false;
        boolean hasOtherError = false;
        for (Throwable t : exceptions) {
            if (t instanceof CharacterCodingException || t instanceof ContentLineDelimiterError) {
                hasCharConversionError = true;
                continue;
            }
            hasOtherError = true;
        }
        if (hasOtherError) {
            if (hasCharConversionError) {
                return ErrorType.PARTIALLY_DUE_TO_CHAR_CONVERSION;
            }
            return ErrorType.OTHER_CAUSE;
        }
        return ErrorType.ENTIRELY_DUE_TO_CHAR_CONVERSION;
    }

    private Map<ItemId<IComponent>, List<IShareable>> groupByComponent(List<IShareable> shareables) {
        HashMap<ItemId<IComponent>, List<IShareable>> grouped = new HashMap<ItemId<IComponent>, List<IShareable>>();
        for (IShareable shareable : shareables) {
            IComponentHandle comp = shareable.getShare().getSharingDescriptor().getComponent();
            ItemId id = new ItemId(IComponent.ITEM_TYPE, comp.getItemId());
            SubcommandUtil.addToMapOfLists(grouped, (Object)id, (Object)shareable);
        }
        return grouped;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DelimiterControl {
        FAIL_ON_ERROR,
        SET_NO_DELIM,
        REWRITE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ErrorType {
        ENTIRELY_DUE_TO_CHAR_CONVERSION,
        PARTIALLY_DUE_TO_CHAR_CONVERSION,
        OTHER_CAUSE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FailProblemHandler
    extends CommitDilemmaHandler {
        boolean failedDueToOutOfSync = false;
        volatile boolean failedDueToMixedLineDelim = false;
        List<IShareable> failedUploades = new LinkedList<IShareable>();

        private FailProblemHandler() {
        }

        public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
            System.out.println(Messages.CheckInCmd_15);
            IndentingPrintStream out = new IndentingPrintStream((OutputStream)System.out).indent();
            for (IShareOutOfSync oos : sharesOutOfSync) {
                out.println((CharSequence)oos.getShare().getPath().toString());
            }
            this.failedDueToOutOfSync = true;
            return 1;
        }

        public boolean willIgnoreAllSharesOutOfSync() {
            return false;
        }

        public boolean failedDueToOutOfSync() {
            return this.failedDueToOutOfSync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lineDelimiterErrors(IFailedUpload failedFile) {
            switch (CheckInCmd.this.delimPolicy) {
                case FAIL_ON_ERROR: {
                    this.failedDueToMixedLineDelim = true;
                    List<IShareable> list = this.failedUploades;
                    synchronized (list) {
                        this.failedUploades.add(failedFile.getShareable());
                    }
                    return 2;
                }
                case REWRITE: {
                    failedFile.setForceConsistentDelimiters(true);
                    return 0;
                }
                case SET_NO_DELIM: {
                    failedFile.setForceConsistentDelimiters(false);
                    return 0;
                }
            }
            throw new IllegalStateException("Unknown policy: " + (Object)((Object)CheckInCmd.this.delimPolicy));
        }
    }
}

