/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListCmdContribOptions;
import com.ibm.team.filesystem.cli.client.internal.writers.ListCmdWriter;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.IContributorManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.query.BaseWorkspaceQueryModel;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListCmd
extends AbstractSubcommand {
    private static final String LIST_PROJECT_AREAS_ID = "com.ibm.team.filesystem.cli.client.list/com.ibm.team.filesystem.cli.client.list-projectareas";
    private static final String LIST_TEAM_AREAS_ID = "com.ibm.team.filesystem.cli.client.list/com.ibm.team.filesystem.cli.client.list-teamareas";
    private static final String LIST_STREAMS_ID = "com.ibm.team.filesystem.cli.client.list/com.ibm.team.filesystem.cli.client.list-streams";
    private static final String LIST_WORKSPACES_ID = "com.ibm.team.filesystem.cli.client.list/com.ibm.team.filesystem.cli.client.list-workspaces";
    private static final String LIST_CONTRIBUTORS_ID = "com.ibm.team.filesystem.cli.client.list/com.ibm.team.filesystem.cli.client.list-contributors";

    public void run(IClientConfiguration config) throws FileSystemClientException {
        String id;
        ICommandLine subargs = config.getSubcommandCommandLine();
        ConnectionInfo connection = config.getConnectionInfo();
        boolean verbose = subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        String contribName = connection.getUsername();
        if (subargs.hasOption(ListCmdContribOptions.OPT_CONTRIB)) {
            contribName = subargs.getOption(ListCmdContribOptions.OPT_CONTRIB);
        }
        if (LIST_PROJECT_AREAS_ID.equals(id = config.getSubcommandDefinition().getId())) {
            this.listProjectAreas(config, connection, verbose);
        } else if (LIST_TEAM_AREAS_ID.equals(id)) {
            this.listTeamAreas(config, connection, contribName, verbose);
        } else if (LIST_STREAMS_ID.equals(id)) {
            this.listStreams(config, connection, contribName, verbose);
        } else if (LIST_WORKSPACES_ID.equals(id)) {
            this.listWorkspaces(config, connection, contribName, verbose);
        } else if (LIST_CONTRIBUTORS_ID.equals(id)) {
            this.listContributors(config, connection, verbose);
        } else {
            throw StatusHelper.configurationFailure((String)NLS.bind((String)Messages.ListCmd_1, (Object)id));
        }
    }

    private void listProjectAreas(IClientConfiguration config, ConnectionInfo connection, boolean verbose) throws FileSystemClientException {
        List projectAreas;
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)connection);
        IProcessItemService itemService = (IProcessItemService)repo.getClientLibrary(IProcessItemService.class);
        try {
            projectAreas = itemService.findAllProjectAreas(IProcessClientService.ALL_PROPERTIES, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)NLS.bind((String)Messages.ListCmd_3, (Object)e.getMessage()));
        }
        for (IProjectArea projectArea : projectAreas) {
            List teamAreas;
            System.out.println(projectArea.getName());
            if (!verbose) continue;
            try {
                teamAreas = repo.itemManager().fetchPartialItems(projectArea.getTeamAreas(), 0, (Collection)Collections.singletonList("name"), null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((TeamRepositoryException)e, (String)NLS.bind((String)Messages.ListCmd_4, (Object)projectArea.getName()));
            }
            for (ITeamArea teamArea : teamAreas) {
                System.out.println("    " + teamArea.getName());
            }
        }
    }

    private void listTeamAreas(IClientConfiguration config, ConnectionInfo connection, String contribId, boolean verbose) throws FileSystemClientException {
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)connection);
        List<ITeamArea> teamAreas = this.findTeamAreasFor(config, connection, contribId, repo);
        for (ITeamArea teamArea : teamAreas) {
            System.out.println(teamArea.getName());
        }
    }

    private List<ITeamArea> findTeamAreasFor(IClientConfiguration config, ConnectionInfo connection, String contribName, ITeamRepository repo) throws FileSystemClientException {
        List projectAreas;
        IContributor currentContributor = this.getContributor(connection, contribName, repo);
        IProcessItemService itemService = (IProcessItemService)repo.getClientLibrary(IProcessItemService.class);
        try {
            projectAreas = itemService.findAllProjectAreas(IProcessClientService.ALL_PROPERTIES, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)NLS.bind((String)Messages.ListCmd_6, (Object)e.getMessage()));
        }
        ArrayList<ITeamArea> toReturn = new ArrayList<ITeamArea>(projectAreas.size());
        for (IProjectArea projectArea : projectAreas) {
            List teamAreas;
            try {
                teamAreas = itemService.findTeamAreas(currentContributor, (IProjectAreaHandle)projectArea, IProcessClientService.ALL_PROPERTIES, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.ListCmd_7);
            }
            toReturn.addAll(teamAreas);
        }
        return toReturn;
    }

    private void listStreams(IClientConfiguration config, ConnectionInfo connection, String contribName, boolean verbose) throws FileSystemClientException {
        List streams;
        DefaultListCmdWriter writer = new DefaultListCmdWriter();
        writer.setVerbose(verbose);
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)connection);
        List<ITeamArea> teamAreas = this.findTeamAreasFor(config, connection, contribName, repo);
        if (teamAreas.size() == 0) {
            System.err.println(Messages.ListCmd_9);
            return;
        }
        BaseWorkspaceQueryModel.WorkspaceQueryModel wsQueryModel = BaseWorkspaceQueryModel.WorkspaceQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)wsQueryModel);
        IPredicate taPredicate = null;
        for (ITeamArea teamArea : teamAreas) {
            IPredicate equals = wsQueryModel.owner()._eq((IItemHandle)teamArea);
            taPredicate = taPredicate == null ? equals : taPredicate._or(equals);
        }
        query.filter(wsQueryModel.stream()._eq(Boolean.TRUE)._and(taPredicate));
        try {
            streams = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).findItems(query, new Object[0]);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.ListCmd_10);
        }
        writer.listStreams(config, repo, streams);
    }

    private void listWorkspaces(IClientConfiguration config, ConnectionInfo connection, String contribId, boolean verbose) throws FileSystemClientException {
        List auditables;
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)connection);
        IContributor currentContributor = this.getContributor(connection, contribId, repo);
        BaseWorkspaceQueryModel.WorkspaceQueryModel queryModel = BaseWorkspaceQueryModel.WorkspaceQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
        query.filter(queryModel.owner()._eq(currentContributor.getItemHandle())._and(queryModel.stream()._eq(Boolean.FALSE)));
        try {
            auditables = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).findItems(query, new Object[0]);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.ListCmd_12);
        }
        HashMap<UUID, IComponent> components = new HashMap<UUID, IComponent>();
        HashMap<UUID, List> ws2component = new HashMap<UUID, List>();
        if (verbose) {
            LinkedList allComponentHandles = new LinkedList();
            for (IWorkspace workspace : auditables) {
                IWorkspaceConnection wsConn;
                IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                try {
                    wsConn = manager.getWorkspaceConnection((IWorkspaceHandle)workspace, null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((TeamRepositoryException)e, (String)NLS.bind((String)Messages.ListCmd_13, (Object)workspace.getName()));
                }
                try {
                    List handles = wsConn.getComponents();
                    ws2component.put(workspace.getItemId(), handles);
                    allComponentHandles.addAll(handles);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((TeamRepositoryException)e, (String)NLS.bind((String)Messages.ListCmd_14, (Object)workspace.getName()));
                }
            }
            List allComponents = null;
            try {
                allComponents = repo.itemManager().fetchPartialItems(allComponentHandles, 0, (Collection)Collections.singletonList(IComponent.NAME_PROPERTY), null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.ListCmd_15);
            }
            for (IComponent comp : allComponents) {
                components.put(comp.getItemId(), comp);
            }
        }
        IndentingPrintStream out = new IndentingPrintStream((OutputStream)System.out);
        for (IWorkspace workspace : auditables) {
            out.println((CharSequence)AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)workspace.getName(), (UUID)workspace.getItemId()));
            if (!verbose) continue;
            IndentingPrintStream verboseOut = out.indent();
            for (IComponentHandle handle : (List)ws2component.get(workspace.getItemId())) {
                String output = AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)((IComponent)components.get(handle.getItemId())).getName(), (UUID)handle.getItemId());
                verboseOut.println((CharSequence)output);
            }
        }
    }

    private void listContributors(IClientConfiguration config, ConnectionInfo connection, boolean verbose) throws FileSystemClientException {
        List contribs;
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)connection);
        IContributorManager lookup = repo.contributorManager();
        try {
            contribs = lookup.fetchAllContributors(null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.ListCmd_19);
        }
        for (IContributor contrib : contribs) {
            if (verbose) {
                String out = NLS.bind((String)Messages.ListCmd_20, (Object[])new Object[]{contrib.getUserId(), contrib.getName(), contrib.getEmailAddress()});
                System.out.println(out);
                continue;
            }
            System.out.println(contrib.getUserId());
        }
    }

    private IContributor getContributor(ConnectionInfo info, String contribName, ITeamRepository repo) throws FileSystemClientException {
        if (info.getUsername().equals(contribName)) {
            return repo.loggedInContributor();
        }
        IContributorManager lookup = repo.contributorManager();
        try {
            return lookup.fetchContributorByUserId(contribName, null);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListCmd_21, (Object)contribName));
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.ListCmd_22);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultListCmdWriter
    extends ListCmdWriter {
        private DefaultListCmdWriter() {
        }

        @Override
        public void listStreams(IClientConfiguration config, ITeamRepository repo, Collection<IWorkspace> streams) {
            super.listStreams(config, repo, streams);
            HashMap<String, Integer> count = new HashMap<String, Integer>();
            for (IWorkspace workspace : streams) {
                String name = workspace.getName();
                if (count.containsKey(name)) {
                    count.put(name, (Integer)count.get(name) + 1);
                    continue;
                }
                count.put(name, 1);
            }
            boolean verbose = this.getVerbose();
            for (IWorkspace workspace : streams) {
                boolean showUUID;
                String name = workspace.getName();
                boolean bl = showUUID = verbose || (Integer)count.get(name) > 1;
                if (showUUID) {
                    System.out.println(AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)name, (UUID)workspace.getItemId()));
                    continue;
                }
                System.out.println(name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ListableThing {
        PROJECT_AREAS,
        TEAM_AREAS,
        STREAMS,
        WORKSPACES,
        CONTRIBUTORS;

    }
}

