/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.flowcommands.conflicthandlers;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.DifferenceEngine;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.conflicthandlers.AbstractConflictHandler;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

public class InPlaceConflictHandler
extends AbstractConflictHandler {
    public static final String MARKER_MY_SECTION = "<<<<<<< mine";
    public static final String MARKER_PROPOSED = "=======";
    public static final String MARKER_END = ">>>>>>> proposed";
    private Map<UUID, IItemConflictReport> indexedConflicts = null;

    private IItemConflictReport findConflictFor(IVersionableHandle item) {
        IItemConflictReport report2;
        if (this.indexedConflicts == null) {
            this.indexedConflicts = new HashMap<UUID, IItemConflictReport>();
            for (IItemConflictReport report2 : this.getReport().conflicts()) {
                UUID key = report2.item().getItemId();
                this.indexedConflicts.put(key, report2);
            }
        }
        if ((report2 = this.indexedConflicts.get(item.getItemId())) == null) {
            throw new IllegalStateException(NLS.bind((String)Messages.InPlaceConflictHandler_0, (Object)item.getItemId().getUuidValue()));
        }
        return report2;
    }

    private void writeDiff(IPath toWrite, InputStream oldData, InputStream newData, OutputStream fileStream) throws FileSystemClientException {
        DifferenceEngine.TextLine[] newLines;
        DifferenceEngine.TextLine[] oldLines;
        try {
            oldLines = this.streamToTextLines(oldData, true);
        }
        catch (IOException e) {
            throw StatusHelper.failure((String)Messages.InPlaceConflictHandler_1, (Throwable)e);
        }
        try {
            newLines = this.streamToTextLines(newData, false);
        }
        catch (IOException e) {
            throw StatusHelper.failure((String)Messages.InPlaceConflictHandler_2, (Throwable)e);
        }
        DifferenceEngine diff = new DifferenceEngine();
        DifferenceEngine.TextLine[][] result = diff.longestCommonSubsequence(oldLines, newLines);
        Assert.isTrue((result.length == 2 ? 1 : 0) != 0);
        Assert.isTrue((result[0].length == result[1].length ? 1 : 0) != 0);
        int oldLn = 0;
        int newLn = 0;
        Writer writer = new Writer(fileStream);
        try {
            boolean oldConf;
            boolean newConf;
            int i = 0;
            while (i < result[0].length) {
                if (newLn == result[1][i].lineNumber() && oldLn == result[0][i].lineNumber()) {
                    writer.write(result[0][i].getText());
                } else {
                    writer.write(MARKER_MY_SECTION);
                    while (oldLn < result[0][i].lineNumber()) {
                        writer.write(oldLines[oldLn].getText());
                        ++oldLn;
                    }
                    writer.write(MARKER_PROPOSED);
                    while (newLn < result[1][i].lineNumber()) {
                        writer.write(newLines[newLn].getText());
                        ++newLn;
                    }
                    writer.write(MARKER_END);
                    writer.write(result[0][i].getText());
                }
                ++i;
                ++oldLn;
                ++newLn;
            }
            if (result[0].length == 0) {
                newConf = true;
                oldConf = true;
            } else {
                int lastRow = result[0].length - 1;
                oldConf = result[0][lastRow].lineNumber() != oldLines.length - 1;
                boolean bl = newConf = result[1][lastRow].lineNumber() != newLines.length - 1;
            }
            if (oldConf || newConf) {
                writer.write(MARKER_MY_SECTION);
                while (oldLn < oldLines.length) {
                    writer.write(oldLines[oldLn].getText());
                    ++oldLn;
                }
                writer.write(MARKER_PROPOSED);
                while (newLn < newLines.length) {
                    writer.write(newLines[newLn].getText());
                    ++newLn;
                }
                writer.write(MARKER_END);
            }
        }
        catch (IOException e) {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.InPlaceConflictHandler_3, (Object)toWrite), (Throwable)e);
        }
    }

    private DifferenceEngine.TextLine[] streamToTextLines(InputStream in, boolean original) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        ArrayList<DifferenceEngine.TextLine> lines = new ArrayList<DifferenceEngine.TextLine>();
        int i = 0;
        while ((line = reader.readLine()) != null) {
            lines.add(new DifferenceEngine.TextLine(i++, original, line));
        }
        return lines.toArray(new DifferenceEngine.TextLine[lines.size()]);
    }

    protected void writeConflict(IPath cfaRoot, IPath myPath, IPath proposedPath, IWorkspaceConnection wsConn, ILogicalChange change) throws FileSystemClientException {
        InputStream proposed;
        InputStream current;
        OutputStream out;
        ILogicalConflict conflict;
        block5: {
            if (change.kind() != 1) {
                return;
            }
            conflict = (ILogicalConflict)change;
            if (conflict.conflictType() != 9) {
                return;
            }
            Assert.isNotNull((Object)myPath);
            out = null;
            current = null;
            proposed = null;
            try {
                out = this.findOutputStreamFor(cfaRoot, myPath, conflict);
                if (out != null) break block5;
                this.safeClose(out);
                this.safeClose(current);
                this.safeClose(proposed);
                return;
            }
            catch (Throwable throwable) {
                this.safeClose(out);
                this.safeClose(current);
                this.safeClose(proposed);
                throw throwable;
            }
        }
        ITeamRepository repo = wsConn.teamRepository();
        current = RepoUtil.findContentFor((ITeamRepository)repo, (IPath)myPath, (IVersionableHandle)this.findConflictFor(conflict.item()).getOriginalSelectedContributorState());
        proposed = RepoUtil.findContentFor((ITeamRepository)repo, (IPath)myPath, (IVersionableHandle)conflict.afterState());
        Assert.isTrue((current != null && proposed != null ? 1 : 0) != 0);
        this.writeDiff(cfaRoot.append(myPath), current, proposed, out);
        this.safeClose(out);
        this.safeClose(current);
        this.safeClose(proposed);
    }

    private OutputStream findOutputStreamFor(IPath cfaRoot, IPath path, ILogicalConflict conflictReport) throws FileSystemClientException {
        if (conflictReport.beforeState() == null || conflictReport.afterState() == null) {
            return null;
        }
        try {
            return new FileOutputStream(cfaRoot.append(path).toFile());
        }
        catch (FileNotFoundException e) {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.InPlaceConflictHandler_4, (Object)path), (Throwable)e);
        }
    }

    private final void safeClose(Closeable toClose) {
        if (toClose != null) {
            try {
                toClose.close();
            }
            catch (IOException iOException) {}
        }
    }

    static final class Writer {
        private static final byte[] NEWLINE = System.getProperty("line.separator").getBytes();
        final OutputStream out;

        public Writer(OutputStream out) {
            this.out = out;
        }

        public void write(String s) throws IOException {
            this.out.write(s.getBytes());
            this.out.write(NEWLINE);
        }
    }
}

