/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.flowcommands.conflicthandlers;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.IConflictHandler;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConflictHandler
implements IConflictHandler {
    private boolean quiet = false;
    private boolean verbose = false;
    private IUpdateReport report;

    @Override
    public void configureQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Override
    public void configureVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected final boolean isQuiet() {
        return this.quiet;
    }

    protected final boolean isVerbose() {
        return this.verbose;
    }

    protected final IUpdateReport getReport() {
        return this.report;
    }

    @Override
    public void handleConflicts(IPath cfaRoot, IWorkspaceConnection wsConn, Iterable<IComponentHandle> components, IUpdateReport report) throws FileSystemClientException {
        ILogicalConflictReport conflictReport;
        this.report = report;
        IFileSystemView fsv = FileSystemCore.getFileSystemManager((ITeamRepository)wsConn.teamRepository()).getFileSystemView((IConnection)wsConn);
        try {
            conflictReport = fsv.interpretConflicts(cfaRoot, report.conflicts(), null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.AbstractConflictHandler_1);
        }
        for (IComponentHandle comp : components) {
            for (ILogicalConflict conflict : conflictReport.getConflictsForComponent(comp)) {
                this.handleConflict(cfaRoot, wsConn, (ILogicalChange)conflict);
            }
            for (ILogicalChange change : conflictReport.getIncidentalChangesForComponent(comp)) {
                this.handleConflict(cfaRoot, wsConn, change);
            }
            for (ILogicalChange change : conflictReport.getAutoMergeChangesForComponent(comp)) {
                this.handleConflict(cfaRoot, wsConn, change);
            }
        }
    }

    protected void handleConflict(IPath cfaRoot, IWorkspaceConnection wsConn, ILogicalChange change) throws FileSystemClientException {
        IPath myPath = this.getLocalPathFor(change.getPathHint());
        IPath proposedPath = this.getLocalPathFor(change.getNewPathHint());
        this.writeConflict(cfaRoot, myPath, proposedPath, wsConn, change);
    }

    protected abstract void writeConflict(IPath var1, IPath var2, IPath var3, IWorkspaceConnection var4, ILogicalChange var5) throws FileSystemClientException;

    private IPath getLocalPathFor(String[] path) {
        if (path == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < path.length) {
            buffer.append('/').append(path[i]);
            ++i;
        }
        return new Path(buffer.toString());
    }
}

