/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.daemon;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.daemon.DaemonStartCmd;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.rest.ILifecycleRestClient;
import com.ibm.team.filesystem.client.restproxy.FilesystemRestClientDiscovery;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import org.eclipse.osgi.util.NLS;

public class DaemonStopCmd
extends AbstractSubcommand
implements IOptionSource {
    public Options getOptions() throws ConflictingOptionException {
        Options opts = new Options(false);
        opts.addOption((IPositionalOptionDefinition)DaemonStartCmd.OPT_CFAROOT, Messages.DaemonStartCmd_0);
        return opts;
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine args = config.getSubcommandCommandLine();
        String cfaRootString = args.getOption((IOptionKey)DaemonStartCmd.OPT_CFAROOT);
        File cfaRoot = new File(cfaRootString);
        ILifecycleRestClient client = (ILifecycleRestClient)FilesystemRestClientDiscovery.RESOLVER.resolve(ILifecycleRestClient.class, cfaRoot, false, false);
        if (client == null) {
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DaemonStopCmd_0, (Object)cfaRoot.getAbsolutePath()));
        }
        if (config.isDryRun()) {
            return;
        }
        try {
            client.postShutdown();
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.DaemonStopCmd_1, (Object)cfaRoot.getAbsolutePath()), (Throwable)e);
        }
        System.out.println(Messages.DaemonStopCmd_2);
    }
}

