/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.daemon;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.INamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.NamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.PositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.daemon.JSONHandler;
import com.ibm.team.filesystem.client.daemon.JSONMethod;
import com.ibm.team.filesystem.client.daemon.events.ConnectionEvent;
import com.ibm.team.filesystem.client.daemon.events.IHttpServerEvent;
import com.ibm.team.filesystem.client.daemon.events.ILightweightEventListener;
import com.ibm.team.filesystem.client.daemon.events.ShutdownStartedEvent;
import com.ibm.team.filesystem.client.internal.daemon.FSDaemon;
import com.ibm.team.filesystem.client.internal.http.HttpContext;
import com.ibm.team.filesystem.client.internal.http.HttpHandler;
import com.ibm.team.filesystem.client.internal.http.constants.HttpMethod;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.ILifecycleRestClient;
import com.ibm.team.filesystem.client.restproxy.FilesystemRestClientDiscovery;
import com.ibm.team.repository.common.LogFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.eclipse.osgi.util.NLS;

public class DaemonStartCmd
extends AbstractSubcommand
implements IOptionSource {
    private static final Log log = LogFactory.getLog((String)DaemonStartCmd.class.getName());
    static PositionalOptionDefinition OPT_CFAROOT = new PositionalOptionDefinition("share-root", 1, 1);
    static NamedOptionDefinition OPT_CONNECTION_TIMEOUT = new NamedOptionDefinition("c", "connection-timeout", 1);
    static NamedOptionDefinition OPT_IDLE_TIMEOUT = new NamedOptionDefinition("i", "inactive-timeout", 1);

    public Options getOptions() throws ConflictingOptionException {
        Options opts = new Options(false);
        opts.addOption((IPositionalOptionDefinition)OPT_CFAROOT, Messages.DaemonStartCmd_0);
        opts.addOption((INamedOptionDefinition)OPT_CONNECTION_TIMEOUT, Messages.DaemonStartCmd_INITIAL_TIMEOUT_HELP);
        opts.addOption((INamedOptionDefinition)OPT_IDLE_TIMEOUT, Messages.DaemonStartCmd_IDLE_TIMEOUT_HELP);
        return opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine args = config.getSubcommandCommandLine();
        String cfaRootString = args.getOption((IOptionKey)OPT_CFAROOT);
        long maxConnectionWait = 0L;
        try {
            maxConnectionWait = new Long(args.getOption((IOptionKey)OPT_CONNECTION_TIMEOUT, "0"));
        }
        catch (NumberFormatException numberFormatException) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DaemonStartCmd_INVALID_INITIAL_TIMEOUT, (Object)OPT_CONNECTION_TIMEOUT.getName(), (Object)args.getOption((IOptionKey)OPT_CONNECTION_TIMEOUT)));
        }
        long idleTimeout = -1L;
        try {
            idleTimeout = new Long(args.getOption((IOptionKey)OPT_IDLE_TIMEOUT, "-1"));
        }
        catch (NumberFormatException numberFormatException) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DaemonStartCmd_INVALID_IDLE_TIMEOUT, (Object)OPT_IDLE_TIMEOUT.getName(), (Object)args.getOption((IOptionKey)OPT_IDLE_TIMEOUT)));
        }
        File cfaRoot = new File(cfaRootString);
        FSDaemon.ILockFile lockFile = null;
        try {
            lockFile = FSDaemon.readLock((File)cfaRoot);
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            throw StatusHelper.internalError((String)"Received interrupt while reading daemon location.");
        }
        if (lockFile != null) {
            this.displayConnectInfo(lockFile.getPort(), lockFile.getKey());
            throw StatusHelper.cfaInUse((String)NLS.bind((String)Messages.DaemonStartCmd_1, (Object)cfaRoot.getPath()));
        }
        if (config.isDryRun()) {
            return;
        }
        SubcommandUtil.initializeEclipseWorkspaceRoot((File)cfaRoot);
        Object o = FilesystemRestClientDiscovery.RESOLVER.resolve(IFilesystemRestClient.class, cfaRoot, true, true);
        FilesystemRestClientDiscovery.IClientLocation loc = FilesystemRestClientDiscovery.RESOLVER.findLocation(IFilesystemRestClient.class, cfaRoot);
        this.displayConnectInfo(loc.getPort(), loc.getKey());
        final InitialWaitEscapeReason[] gottenConnection = new InitialWaitEscapeReason[]{InitialWaitEscapeReason.TIMEOUT};
        FSDaemon fsd = loc.getInProcessServer();
        ILightweightEventListener<IHttpServerEvent> l = new ILightweightEventListener<IHttpServerEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void handleEvent(IHttpServerEvent event) {
                if (event instanceof ConnectionEvent && ((ConnectionEvent)event).getType() == ConnectionEvent.Type.OPENED) {
                    InitialWaitEscapeReason[] initialWaitEscapeReasonArray = gottenConnection;
                    synchronized (gottenConnection) {
                        gottenConnection[0] = InitialWaitEscapeReason.CONNECTION;
                        gottenConnection.notifyAll();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
                if (!(event instanceof ShutdownStartedEvent)) return;
                InitialWaitEscapeReason[] initialWaitEscapeReasonArray = gottenConnection;
                synchronized (gottenConnection) {
                    gottenConnection[0] = InitialWaitEscapeReason.SHUTDOWN;
                    gottenConnection.notifyAll();
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return;
                }
            }
        };
        InitialWaitEscapeReason[] initialWaitEscapeReasonArray = gottenConnection;
        synchronized (gottenConnection) {
            fsd.getHttpServer().addListener((ILightweightEventListener)l);
            if (maxConnectionWait > 0L) {
                try {
                    gottenConnection.wait(maxConnectionWait);
                }
                catch (InterruptedException e) {
                    log.error((Object)"Unexpected interruption while waiting for initial connection", (Throwable)e);
                }
            } else {
                gottenConnection[0] = InitialWaitEscapeReason.CONNECTION;
            }
            switch (gottenConnection[0]) {
                case CONNECTION: {
                    this.installShutdownTimer(fsd, idleTimeout);
                    break;
                }
                case SHUTDOWN: {
                    // ** MonitorExit[var15_13] (shouldn't be in output)
                    return;
                }
                case TIMEOUT: {
                    try {
                        fsd.getHttpServer().shutdown();
                    }
                    catch (IOException e) {
                        log.error((Object)("Exception while shutting down server: " + e.getMessage()), (Throwable)e);
                    }
                    throw StatusHelper.initialConnectionTimeout((long)maxConnectionWait);
                }
            }
            // ** MonitorExit[var15_13] (shouldn't be in output)
            FilesystemRestClientDiscovery.RESOLVER.joinInProcess(o);
            return;
        }
    }

    private void installShutdownTimer(FSDaemon fsd, long idleTimeout) throws FileSystemClientException {
        if (idleTimeout < 0L) {
            return;
        }
        HttpContext ctx = fsd.getHttpServer().getContextFor(HttpMethod.POST, new String[]{"service"});
        HttpHandler handler = ctx.getHandler();
        JSONMethod method = ((JSONHandler)handler).getMethod(HttpMethod.POST, new String[]{"service", ILifecycleRestClient.class.getName(), "Timeout"});
        try {
            method.getMethod().invoke(method.getReceiver(), new ILifecycleRestClient.TimeoutParam(idleTimeout));
        }
        catch (IllegalArgumentException e) {
            throw StatusHelper.failure((String)"Unable to set timeout", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw StatusHelper.failure((String)"Unable to set timeout", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw StatusHelper.failure((String)"Unable to set timeout", (Throwable)e);
        }
    }

    private void displayConnectInfo(int port, String key) {
        System.out.println("Port: " + port);
        System.out.println("Key: " + key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InitialWaitEscapeReason {
        CONNECTION,
        SHUTDOWN,
        TIMEOUT;

    }
}

