/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetAssociateWorkitemOptions;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import org.eclipse.osgi.util.NLS;

public abstract class ChangesetWorkitemBase
extends AbstractSubcommand {
    public String csSelector;
    public int wiId;
    public String wsSelector;
    public String repoUri;
    public IWorkItemHandle wiHandle;
    public IChangeSetHandle csHandle;

    public void run(IClientConfiguration config) throws FileSystemClientException {
        this.getArgs(config);
        IWorkspaceConnection wsConn = this.connect(config);
        this.resolveArguments(wsConn);
        this.doIt(wsConn);
    }

    protected abstract void doIt(IWorkspaceConnection var1) throws FileSystemClientException;

    private void getArgs(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine cli = config.getSubcommandCommandLine();
        if (cli.hasOption(ChangesetCommonOptions.OPT_CHANGESET.getId())) {
            this.csSelector = cli.getOption(ChangesetCommonOptions.OPT_CHANGESET.getId());
            UUID csId = RepoUtil.lookupUuid((String)this.csSelector);
            if (csId == null) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ChangesetAssociateWorkitemCmd_0, (Object)this.csSelector));
            }
        } else {
            throw StatusHelper.argSyntax((String)Messages.ChangesetAssociateWorkitemCmd_1);
        }
        if (cli.hasOption(ChangesetAssociateWorkitemOptions.OPT_WORKITEM.getId())) {
            String wi = cli.getOption(ChangesetAssociateWorkitemOptions.OPT_WORKITEM.getId());
            try {
                this.wiId = Integer.parseInt(wi);
            }
            catch (NumberFormatException numberFormatException) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ChangesetAssociateWorkitemCmd_2, (Object)wi));
            }
        } else {
            throw StatusHelper.argSyntax((String)Messages.ChangesetAssociateWorkitemCmd_3);
        }
        this.wsSelector = cli.getOption(ChangesetCommonOptions.OPT_WORKSPACE_NAME.getId(), null);
        this.repoUri = cli.getOption((IOptionKey)CommonOptions.OPT_URI, null);
    }

    private IWorkspaceConnection connect(IClientConfiguration config) throws FileSystemClientException {
        return RepoUtil.findWorkspaceConnection((IClientConfiguration)config, (String)this.repoUri, (String)this.wsSelector);
    }

    private void resolveArguments(IWorkspaceConnection wsConn) throws FileSystemClientException {
        ITeamRepository repo = wsConn.teamRepository();
        try {
            this.wiHandle = RepoUtil.findWorkitem((ITeamRepository)repo, (int)this.wiId);
        }
        catch (RepoUtil.SelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ChangesetAssociateWorkitemCmd_4, (Object)this.wsSelector));
        }
        try {
            this.csHandle = RepoUtil.findNamedChangeSet((ITeamRepository)repo, (String)this.csSelector);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ChangesetAssociateWorkitemCmd_5, (Object)e.getSelector()));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ChangesetAssociateWorkitemCmd_6, (Object)e.getSelector()));
        }
    }
}

