/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetRelocateCmdOptions;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommand;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.CompletedChangeSetException;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangesetRelocateCmd
extends AbstractSubcommand
implements ISubcommand {
    IWorkspaceConnection wsConn = null;
    IComponentHandle componentHint = null;

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine cli = config.getSubcommandCommandLine();
        ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
        if (!cli.hasOption(ChangesetRelocateCmdOptions.OPT_CHANGES.getId())) {
            throw StatusHelper.argSyntax((String)Messages.ChangesetRelocateCmd_0);
        }
        List selectors = cli.getOptions(ChangesetRelocateCmdOptions.OPT_CHANGES.getId());
        List<UUID> uuidsToMove = this.findUuids(config, cfaView, selectors);
        assert (uuidsToMove.size() == selectors.size());
        this.dedupUuids(uuidsToMove, selectors);
        if (this.wsConn == null) {
            this.wsConn = RepoUtil.findWorkspaceConnection((IClientConfiguration)config, (String)cli.getOption((IOptionKey)CommonOptions.OPT_URI, null), (String)cli.getOption(CommonOptions.OPT_WORKSPACE, null));
        }
        ArrayList<IVersionableHandle> items = new ArrayList<IVersionableHandle>(selectors.size());
        ArrayList<IChangeSet> sourceChangesets = new ArrayList<IChangeSet>(selectors.size());
        this.findChangesetModifying(this.wsConn, this.componentHint, uuidsToMove, selectors, items, sourceChangesets);
        assert (sourceChangesets.size() == selectors.size());
        assert (items.size() == selectors.size());
        String csSelector = cli.getOption(ChangesetRelocateCmdOptions.OPT_DST_CHANGESET.getId());
        IChangeSetHandle csHandle = this.findTarget(this.wsConn, csSelector);
        if (!config.isDryRun()) {
            this.relocate(this.wsConn, csHandle, items, sourceChangesets);
        }
        System.out.println(Messages.ChangesetRelocateCmd_5);
    }

    private void dedupUuids(List<UUID> uuidsToMove, List<String> selectors) throws FileSystemClientException {
        HashMap<UUID, String> uuids = new HashMap<UUID, String>();
        int i = 0;
        while (i < selectors.size()) {
            String prev = (String)uuids.get(uuidsToMove.get(i));
            if (prev != null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ChangesetRelocateCmd_17, (Object[])new Object[]{AliasUtil.alias((UUID)uuidsToMove.get(i)), uuids.get(uuidsToMove.get(i)), selectors.get(i)}));
            }
            uuids.put(uuidsToMove.get(i), selectors.get(i));
            ++i;
        }
    }

    private void findChangesetModifying(IWorkspaceConnection wsConn, IComponentHandle componentHint, List<UUID> uuidsToMove, List<String> selectors, List<IVersionableHandle> changedItems, List<IChangeSet> sourceChanges) throws FileSystemClientException {
        List possibleSourceComplete;
        List possibleSourceHandles = componentHint == null ? wsConn.activeChangeSets() : wsConn.activeChangeSets(componentHint);
        try {
            possibleSourceComplete = wsConn.teamRepository().itemManager().fetchCompleteItems(possibleSourceHandles, 0, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.ChangesetRelocateCmd_13);
        }
        int i = 0;
        while (i < uuidsToMove.size()) {
            block9: {
                for (IChangeSet cs : possibleSourceComplete) {
                    if (componentHint != null && !cs.getComponent().sameItemId((IItemHandle)componentHint)) continue;
                    List changes = cs.changes();
                    for (IChange change : changes) {
                        if (!uuidsToMove.get(i).equals((Object)change.item().getItemId())) continue;
                        changedItems.add(change.item());
                        sourceChanges.add(cs);
                        if (componentHint == null) {
                            componentHint = cs.getComponent();
                        }
                        break block9;
                    }
                }
                if (componentHint == null) {
                    throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.ChangesetRelocateCmd_14, (Object)selectors.get(i), (Object)wsConn.getName()));
                }
                String compName = "";
                try {
                    IComponent comp = (IComponent)wsConn.teamRepository().itemManager().fetchCompleteItem((IItemHandle)componentHint, 0, null);
                    compName = comp.getName();
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    System.err.println(NLS.bind((String)Messages.ChangesetRelocateCmd_15, (Object)componentHint.getItemId().getUuidValue()));
                }
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.ChangesetRelocateCmd_16, (Object[])new Object[]{AliasUtil.selector((String)selectors.get(i), (UUID)uuidsToMove.get(i)), wsConn.getName(), AliasUtil.selector((String)compName, (UUID)componentHint.getItemId())}));
            }
            ++i;
        }
    }

    private List<UUID> findUuids(IClientConfiguration config, ICopyFileAreaView cfaView, List<String> toQuery) throws FileSystemClientException {
        ArrayList<UUID> toReturn = new ArrayList<UUID>();
        ISharingDescriptor originalDesc = null;
        String settingSelector = null;
        for (String pathOrUuid : toQuery) {
            UUID uuid = RepoUtil.lookupUuid((String)pathOrUuid);
            if (uuid == null) {
                IShareable shareable = cfaView.findShareable((IPath)new Path(pathOrUuid));
                if (shareable == null || shareable.getRemote() == null) {
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ChangesetRelocateCmd_7, (Object)pathOrUuid));
                }
                IShare share = shareable.getShare();
                if (share == null) {
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ChangesetRelocateCmd_8, (Object)pathOrUuid));
                }
                ISharingDescriptor desc = share.getSharingDescriptor();
                if (originalDesc == null) {
                    originalDesc = desc;
                    settingSelector = pathOrUuid;
                    this.componentHint = desc.getComponent();
                } else {
                    if (!desc.getConnectionHandle().sameItemId((IItemHandle)originalDesc.getConnectionHandle())) {
                        throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ChangesetRelocateCmd_9, (Object)settingSelector, (Object)pathOrUuid));
                    }
                    if (!desc.getComponent().sameItemId((IItemHandle)originalDesc.getComponent())) {
                        throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ChangesetRelocateCmd_10, (Object)settingSelector, (Object)pathOrUuid));
                    }
                    assert (this.componentHint.sameItemId((IItemHandle)desc.getComponent()));
                }
                uuid = shareable.getRemote().getItemId();
            }
            toReturn.add(uuid);
        }
        if (originalDesc != null) {
            IWorkspaceHandle wsHandle = (IWorkspaceHandle)originalDesc.getConnectionHandle();
            ConnectionInfo info = config.getConnectionInfo(originalDesc.getRepositoryUri());
            ITeamRepository repoConn = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)info);
            IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repoConn);
            try {
                this.wsConn = manager.getWorkspaceConnection(wsHandle, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((TeamRepositoryException)e, (String)NLS.bind((String)Messages.ChangesetRelocateCmd_11, (Object)info.getURI(), (Object)info.getUsername()));
            }
        }
        return toReturn;
    }

    private IChangeSetHandle findTarget(IWorkspaceConnection wsConn, String csSelector) throws FileSystemClientException {
        try {
            return RepoUtil.findNamedChangeSet((ITeamRepository)wsConn.teamRepository(), (String)csSelector);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ChangesetCloseCmd_7, (Object)e.getSelector()));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ChangesetCloseCmd_8, (Object)e.getSelector()));
        }
    }

    private void relocate(IWorkspaceConnection wsConn, IChangeSetHandle target, List<IVersionableHandle> items, List<IChangeSet> sourceCses) throws FileSystemClientException {
        int size = items.size();
        ArrayList<IChangeSetHandle> targetChangeSets = new ArrayList<IChangeSetHandle>(size);
        int i = 0;
        while (i < items.size()) {
            targetChangeSets.add(target);
            ++i;
        }
        try {
            wsConn.relocateChanges(targetChangeSets, items, sourceCses, null);
        }
        catch (CompletedChangeSetException completedChangeSetException) {
            throw StatusHelper.inappropriateArgument((String)Messages.ChangesetRelocateCmd_6);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.ChangesetRelocateCmd_4);
        }
    }
}

