/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.osgi.util.NLS;

public class ChangesetCloseCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        IChangeSetHandle csHandle;
        ICommandLine cli = config.getSubcommandCommandLine();
        String uri = cli.getOption((IOptionKey)CommonOptions.OPT_URI, null);
        String wsSelector = cli.getOption(ChangesetCommonOptions.OPT_WORKSPACE_NAME.getId(), null);
        IWorkspaceConnection wsConn = RepoUtil.findWorkspaceConnection((IClientConfiguration)config, (String)uri, (String)wsSelector);
        try {
            csHandle = RepoUtil.findNamedChangeSet((ITeamRepository)wsConn.teamRepository(), (String)cli.getOption(ChangesetCommonOptions.OPT_CHANGESET.getId()));
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ChangesetCloseCmd_7, (Object)e.getSelector()));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e));
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ChangesetCloseCmd_8, (Object)e.getSelector()));
        }
        try {
            wsConn.ensureClosed((Collection)Collections.singletonList(csHandle), null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((TeamRepositoryException)e, (String)Messages.ChangesetCloseCmd_9);
        }
        System.out.println(Messages.ChangesetCloseCmd_10);
    }
}

