/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.repo;

import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.ResourceImpl;
import com.ibm.rational.wvcm.ri.repo.RiProvider;
import com.ibm.rational.wvcm.ri.repo.RiRepo;
import com.ibm.rational.wvcm.ri.repo.RiRepoBaseline;
import com.ibm.rational.wvcm.ri.repo.RiRepoConfiguration;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoFolderVersion;
import com.ibm.rational.wvcm.ri.repo.RiRepoIFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoStream;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersion;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersionHistory;
import com.ibm.rational.wvcm.ri.repo.RiRepoWorkspace;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RiRepoResource
extends SrvcResource {
    protected RiRepo _repo;
    protected String _id;
    private Map<PropertyNameList.PropertyName<?>, Object> _properties = new HashMap();
    protected byte[] _content;
    protected String _stringContent;
    protected boolean _creationInProgress;
    static final PropertyNameList.PropertyName<RiRepoIFolder.RepoBinding> PARENT_BINDING_LIST = new PropertyNameList.PropertyName("com.ibm.rational.wvcm.ri", "parent-binding-list");
    private static List<String> providerList = new ArrayList<String>();
    static int contentIdentifierCounter;

    static {
        providerList.add(SrvcProvider.class.getName());
        contentIdentifierCounter = 0;
    }

    @Override
    public Class<?> get_proxyClass() {
        return ResourceImpl.class;
    }

    protected RiRepoResource(RiRepoResource parent, String bindingName, SrvcProvider provider, RiRepo repo) {
        this.initialize(parent, bindingName, provider, repo);
    }

    public RiRepo get_repo() {
        return this._repo;
    }

    public String get_id() {
        return this._id;
    }

    private void initialize(RiRepoResource parent, String bindingName, SrvcProvider provider, RiRepo repo) {
        this._provider = provider;
        this._repo = repo;
        Date date = new Date();
        this.createProperty(Resource.CREATION_DATE, date);
        this.createProperty(Resource.LAST_MODIFIED, date);
        this.createProperty(Resource.CONTENT_IDENTIFIER, null);
        this.createProperty(Resource.CONTENT_LENGTH, new Long(0L));
        this.createProperty(Resource.CONTENT_CHARACTER_SET, null);
        this.createProperty(Resource.CONTENT_LANGUAGE, null);
        this.createProperty(Resource.CONTENT_TYPE, null);
        this.createProperty(Resource.COMMENT, null);
        this.createProperty(Resource.CREATOR_DISPLAY_NAME, ((RiProvider)this.get_provider()).get_userName());
        this.createProperty(Resource.DISPLAY_NAME, bindingName);
        this.createProperty(Resource.IS_EXECUTABLE, false);
        this.createProperty(Resource.PROVIDER_LIST, providerList);
        this._id = this.get_repo().getNextResourceIdentifier();
        String resourceId = this.get_repo().uuidLoc(this._id).string();
        this.createProperty(Resource.RESOURCE_IDENTIFIER, resourceId);
        this.get_repo().stableResourceMap.put(this._id, this);
        this.createProperty(Resource.WORKSPACE_FOLDER_LIST, null);
        this.createProperty(PARENT_BINDING_LIST, new ArrayList());
        if (parent != null) {
            if (!(parent instanceof RiRepoIFolder)) {
                throw new IllegalStateException("Parent repository resource was expected to be of type Folder");
            }
            parent.setupBinding(bindingName, this);
        }
        this.createProperty(Resource.PARENT_LIST, null);
    }

    protected void destroy() {
        this.get_repo().stableResourceMap.remove(this.get_id());
    }

    public static Exception[] convertListToExceptionArray(List<WvcmException> exceptions) {
        Exception[] ret = new Exception[exceptions.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (Exception)((Object)exceptions.get(i));
            ++i;
        }
        return ret;
    }

    public RiRepoIFolder.RepoBinding lookupBinding(String bindingName) {
        List members;
        if (this instanceof RiRepoIFolder && (members = this.getListProperty(RiRepoIFolder.CHILD_BINDING_LIST)) != null) {
            int i = 0;
            while (i < members.size()) {
                RiRepoIFolder.RepoBinding memberBinding = (RiRepoIFolder.RepoBinding)members.get(i);
                if (bindingName.equals(memberBinding.get_bindingName())) {
                    return memberBinding;
                }
                ++i;
            }
        }
        return null;
    }

    public RiRepoResource lookupBoundMember(String bindingName) {
        RiRepoIFolder.RepoBinding binding = this.lookupBinding(bindingName);
        if (binding != null) {
            return binding.get_bindingMember();
        }
        return null;
    }

    void updateLastModified() {
        Date date = new Date();
        this._properties.put(Resource.LAST_MODIFIED, date);
    }

    public static boolean isStandardProperty(PropertyNameList.PropertyName<?> propertyName) {
        return propertyName.getNamespace() == null;
    }

    public static boolean isCustomProperty(PropertyNameList.PropertyName<?> propertyName) {
        String namespace = propertyName.getNamespace();
        return namespace != null && !namespace.equals("com.ibm.rational.wvcm.ri");
    }

    void setProperty(PropertyNameList.PropertyName<?> propertyName, Object value) {
        if (propertyName.getNamespace() == null && !this._properties.containsKey(propertyName)) {
            throw new IllegalArgumentException("No such property " + propertyName + " on repository object type " + this.getClass());
        }
        this._properties.put(propertyName, value);
        if (!propertyName.equals((Object)Resource.LAST_MODIFIED)) {
            this.updateLastModified();
        }
    }

    protected void setProperty_AppendUniqueToList(PropertyNameList.PropertyName<?> propertyName, Object resource) {
        List resources = this.getListProperty(propertyName);
        int which = resources.indexOf(resource);
        if (which == -1) {
            resources.add(resource);
        }
        this.updateLastModified();
    }

    protected void setProperty_AppendToList(PropertyNameList.PropertyName<?> propertyName, Object resource) {
        List resources = this.getListProperty(propertyName);
        resources.add(resource);
        this.updateLastModified();
    }

    protected void setProperty_RemoveFromList(PropertyNameList.PropertyName<?> propertyName, Object resource) {
        List resources = (List)this.getProperty(propertyName);
        int which = resources.indexOf(resource);
        if (which != -1) {
            resources.remove(which);
        }
        this.updateLastModified();
    }

    @Override
    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (initialize && this._properties.get(propertyName) != null) {
            throw new WvcmException("Property already set", WvcmException.ReasonCode.CANNOT_OVERWRITE);
        }
        if (propertyName.getNamespace() == null) {
            this.setPropertyEx(propertyName, value);
        } else {
            this.setProperty(propertyName, value);
        }
    }

    protected void setPropertyEx(PropertyNameList.PropertyName<?> propertyName, Object value) {
        Object oldValue = this.getProperty(propertyName);
        this.setProperty(propertyName, value);
        if (value instanceof ArrayList) {
            int i;
            if (oldValue != null) {
                List oldValueList = (List)oldValue;
                i = 0;
                while (i < oldValueList.size()) {
                    this.postSetPropertyEx(propertyName, oldValueList.get(i), null);
                    ++i;
                }
            }
            List valueList = (List)value;
            i = 0;
            while (i < valueList.size()) {
                this.postSetPropertyEx(propertyName, null, valueList.get(i));
                ++i;
            }
        } else {
            this.postSetPropertyEx(propertyName, oldValue, value);
        }
    }

    protected void setPropertyEx_AppendUniqueToList(PropertyNameList.PropertyName<?> propertyName, Object resource) {
        this.setProperty_AppendUniqueToList(propertyName, resource);
        this.postSetPropertyEx(propertyName, null, resource);
    }

    protected void setPropertyEx_AppendToList(PropertyNameList.PropertyName<?> propertyName, Object resource) {
        this.setProperty_AppendToList(propertyName, resource);
        this.postSetPropertyEx(propertyName, null, resource);
    }

    protected void setPropertyEx_RemoveFromList(PropertyNameList.PropertyName<?> propertyName, Object resource) {
        this.setProperty_RemoveFromList(propertyName, resource);
        this.postSetPropertyEx(propertyName, resource, null);
    }

    protected void postSetPropertyEx(PropertyNameList.PropertyName<?> propertyName, Object oldValue, Object value) {
    }

    @Override
    public void removePropertyFromClient(PropertyNameList.PropertyName<?> propertyName, SrvcFeedback feedback) throws WvcmException {
        if (controlledProperties.contains(propertyName)) {
            this.autoCheckoutControlledContent();
        }
        this._properties.remove(propertyName);
        this.updateLastModified();
    }

    protected void autoCheckoutControlledContent() throws WvcmException {
        if (this instanceof RiRepoControllableResource && this.getProperty(ControllableResource.CHECKED_IN) != null && !this.getPropertyAsBoolean(ControllableResource.IS_CHECKED_OUT)) {
            RiRepoControllableResource r = (RiRepoControllableResource)this;
            r.doCheckout(null, null);
        }
    }

    void createProperty(PropertyNameList.PropertyName<?> propertyName, Object value) {
        this._properties.put(propertyName, value);
    }

    public Object getProperty(PropertyNameList.PropertyName<?> propertyName) {
        Object[] calculatedValue = new Object[1];
        if (this.handleCalculatedProperties(propertyName, calculatedValue)) {
            return calculatedValue[0];
        }
        if (!this._properties.containsKey(propertyName)) {
            throw new IllegalArgumentException("No such property " + propertyName + " on repository object type " + this.getClass().getName());
        }
        return this._properties.get(propertyName);
    }

    protected boolean handleCalculatedProperties(PropertyNameList.PropertyName<?> propertyName, Object[] calculatedValue) {
        if (propertyName.equals((Object)Resource.PATHNAME_LOCATION)) {
            try {
                calculatedValue[0] = this.get_provider().location(this.calculatePath());
                return true;
            }
            catch (WvcmException wvcmException) {}
        } else {
            if (propertyName.equals((Object)Resource.PARENT_LIST)) {
                List pbl = this.getListProperty(PARENT_BINDING_LIST);
                ArrayList<RiRepoIFolder> pl = new ArrayList<RiRepoIFolder>();
                int i = 0;
                while (i < pbl.size()) {
                    RiRepoIFolder.RepoBinding binding = (RiRepoIFolder.RepoBinding)pbl.get(i);
                    RiRepoIFolder parentFolder = binding.get_bindingFolder();
                    pl.add(parentFolder);
                    ++i;
                }
                calculatedValue[0] = pl;
                return true;
            }
            if (propertyName.equals((Object)Resource.WORKSPACE_FOLDER_LIST)) {
                calculatedValue[0] = this.get_repo().getWorkspaceFolderList();
                return true;
            }
        }
        return false;
    }

    public boolean getPropertyAsBoolean(PropertyNameList.PropertyName<?> propertyName) {
        Boolean obj = (Boolean)this.getProperty(propertyName);
        return obj;
    }

    protected RiRepoIFolder.RepoBinding getParentBinding(Location loc) {
        RiRepoResource parent = this.getParentResource(loc);
        String bindingName = loc.lastSegment();
        RiRepoIFolder.RepoBinding binding = null;
        List parentBindings = this.getListProperty(PARENT_BINDING_LIST);
        int i = 0;
        while (i < parentBindings.size()) {
            RiRepoIFolder.RepoBinding parentBinding = (RiRepoIFolder.RepoBinding)parentBindings.get(i);
            RiRepoResource parentFolder = (RiRepoResource)((Object)parentBinding.get_bindingFolder());
            if (parent == parentFolder && bindingName.equals(parentBinding.get_bindingName())) {
                binding = parentBinding;
            }
            ++i;
        }
        if (binding == null) {
            throw new IllegalStateException("doUnbind: Parent binding not found");
        }
        return binding;
    }

    RiRepoResource getParentResource() {
        RiRepoResource res = null;
        List parentBindings = this.getListProperty(PARENT_BINDING_LIST);
        if (parentBindings.size() > 0) {
            RiRepoIFolder.RepoBinding binding = (RiRepoIFolder.RepoBinding)parentBindings.get(0);
            res = (RiRepoResource)((Object)binding.get_bindingFolder());
        }
        return res;
    }

    RiRepoResource getParentResource(Location loc) {
        return RiRepoResource.getParentResource(this.get_provider(), loc);
    }

    public static RiRepoResource getParentResource(SrvcProvider provider, Location loc) {
        Location parentLoc = loc.parent();
        if (parentLoc != null) {
            return (RiRepoResource)provider.lookup(parentLoc, null);
        }
        RiRepoResource res = (RiRepoResource)provider.lookup(loc, null);
        if (res == null) {
            return null;
        }
        return res.getParentResource();
    }

    Map<PropertyNameList.PropertyName<?>, Object> get_properties() {
        return this._properties;
    }

    byte[] get_content() {
        return this._content;
    }

    void set_content(byte[] content) {
        this._content = content;
        if (content != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                out.write(content);
                this._stringContent = out.toString();
            }
            catch (Exception exception) {}
        }
    }

    void setContent(byte[] content, String contentIdentifier) throws WvcmException {
        String oldContentIdentifier;
        if (this instanceof RiRepoVersion) {
            throw new WvcmException("Cannot modify the content of a Version", WvcmException.ReasonCode.CANNOT_MODIFY_VERSION);
        }
        this.autoCheckoutControlledContent();
        if (contentIdentifier != null && (oldContentIdentifier = (String)this.getProperty(Resource.CONTENT_IDENTIFIER)) != null && !oldContentIdentifier.equals(contentIdentifier)) {
            throw new WvcmException("Cannot write content because new content identifier does not match old one", WvcmException.ReasonCode.CONFLICT);
        }
        this.setProperty(Resource.CONTENT_IDENTIFIER, "" + contentIdentifierCounter++);
        this._content = content;
        if (content != null) {
            this.setProperty(Resource.CONTENT_LENGTH, new Long(content.length));
        }
    }

    @Override
    public Location calculateLocation() {
        try {
            return this.get_provider().location((String)this.getProperty(Resource.RESOURCE_IDENTIFIER));
        }
        catch (WvcmException e) {
            throw new RuntimeException("unexpected exception", e);
        }
    }

    public String calculatePath() {
        ArrayList<String> segments = new ArrayList<String>();
        List<RiRepoIFolder.RepoBinding> parentBindings = this.getParentBindingList();
        while (parentBindings != null && !parentBindings.isEmpty()) {
            RiRepoIFolder.RepoBinding parentBinding = parentBindings.get(0);
            RiRepoResource parent = (RiRepoResource)((Object)parentBinding.get_bindingFolder());
            String childName = parentBinding.get_bindingName();
            segments.add(childName);
            parentBindings = parent.getParentBindingList();
        }
        StringBuffer pathBuffer = new StringBuffer();
        pathBuffer.append(this.get_repo().rootFolderLocation.string());
        int i = segments.size() - 1;
        while (i >= 0) {
            pathBuffer.append("/");
            pathBuffer.append((String)segments.get(i));
            --i;
        }
        String path = pathBuffer.toString();
        if (path.equals("")) {
            path = "/";
        }
        return path;
    }

    public Location calculatePathLocation() throws WvcmException {
        return this.get_provider().location(this.calculatePath());
    }

    private RiRepoResource checkValidCRDestination(Location destination) throws WvcmException {
        RiRepoResource parent = this.getParentResource(destination);
        if (parent == null) {
            throw new WvcmException("Not a valid location; resource must be within a workspace", WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION);
        }
        if (!(parent instanceof RiRepoControllableResource) || parent.getProperty(ControllableResource.WORKSPACE) == null) {
            throw new WvcmException("Not a valid location; resource must be within a workspace", WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION);
        }
        return parent;
    }

    private static SrvcResource prepareQuery(Resource query) throws WvcmException {
        SrvcResource context = null;
        RiProvider provider = (RiProvider)query.provider();
        for (Map.Entry<PropertyNameList.PropertyName<?>, PropValue> entry : ((ResourceImpl)query).getPropMap().entrySet()) {
            PropertyNameList.PropertyName<?> propName = entry.getKey();
            PropValue propValue = entry.getValue();
            if (!propValue.isOK()) continue;
            Object value = propValue.get_value();
            if (value instanceof ArrayList) {
                List queryList = (List)value;
                int i = 0;
                while (i < queryList.size()) {
                    if (queryList.get(i) instanceof ResourceImpl) {
                        ResourceImpl resourceValue = (ResourceImpl)queryList.get(i);
                        Object locValue = resourceValue.lookupProperty(Resource.PATHNAME_LOCATION);
                        if (locValue instanceof Location) {
                            Location location = (Location)locValue;
                            RiRepoResource resource = (RiRepoResource)provider.lookup(location, null);
                            if (resource == null) {
                                throw new WvcmException("query location not found: " + location, WvcmException.ReasonCode.NOT_FOUND);
                            }
                            if (resource instanceof RiRepoStream || resource instanceof RiRepoWorkspace) {
                                context = resource;
                            }
                            queryList.set(i, resource);
                        } else {
                            SrvcResource nestedContext = RiRepoResource.prepareQuery(resourceValue);
                            if (context == null) {
                                context = nestedContext;
                            }
                        }
                    }
                    ++i;
                }
                continue;
            }
            if (!(value instanceof ResourceImpl)) continue;
            ResourceImpl resourceValue = (ResourceImpl)value;
            Object locValue = resourceValue.lookupProperty(Resource.PATHNAME_LOCATION);
            if (locValue instanceof Location) {
                Location location = (Location)locValue;
                if (!Resource.class.isAssignableFrom((Class)propertyValueType.get(propName))) continue;
                RiRepoResource resource = (RiRepoResource)provider.lookup(location, null);
                if (resource instanceof RiRepoStream || resource instanceof RiRepoWorkspace) {
                    context = resource;
                }
                if (resource == null) {
                    throw new WvcmException("query location not found: " + location, WvcmException.ReasonCode.NOT_FOUND);
                }
                propValue.set_value(resource);
                continue;
            }
            SrvcResource nestedContext = RiRepoResource.prepareQuery(resourceValue);
            if (context != null) continue;
            context = nestedContext;
        }
        return context;
    }

    private void recurseExecuteQuery(Resource query, Set<Resource> results, PropertyRequestItem.PropertyRequest propertyRequest, SrvcResource context, boolean all, SrvcFeedback feedback) throws WvcmException {
        if (this.testForQueryMatch(query)) {
            ResourceImpl resource = this.buildProxy(propertyRequest, context, feedback);
            results.add(resource);
            if (!all) {
                return;
            }
        }
        if (this instanceof RiRepoIFolder && !(this instanceof RiRepoFolderVersion)) {
            List bindings = this.getListProperty(RiRepoIFolder.CHILD_BINDING_LIST);
            int i = 0;
            while (i < bindings.size()) {
                RiRepoIFolder.RepoBinding binding = (RiRepoIFolder.RepoBinding)bindings.get(i);
                RiRepoResource member = binding.get_bindingMember();
                member.recurseExecuteQuery(query, results, propertyRequest, context, all, feedback);
                if (!all && results.size() > 0) {
                    return;
                }
                ++i;
            }
        }
    }

    private boolean testForQueryMatch(Object query) {
        if (query instanceof RiRepoResource) {
            return this.equals(query);
        }
        if (!query.getClass().isAssignableFrom(this.get_proxyClass())) {
            return false;
        }
        for (Map.Entry<PropertyNameList.PropertyName<?>, PropValue> entry : ((ResourceImpl)query).getPropMap().entrySet()) {
            List rList;
            PropertyNameList.PropertyName<?> propName = entry.getKey();
            PropValue queryPropValue = entry.getValue();
            if (!queryPropValue.isOK()) continue;
            Object queryValue = queryPropValue.get_value();
            Object rPropValue = null;
            try {
                rPropValue = this.getProperty(propName);
            }
            catch (Exception exception) {
                return false;
            }
            if (queryValue instanceof ResourceList) {
                ResourceList queryList = (ResourceList)queryValue;
                if (this.testForQueryMatch(rPropValue, (List<?>)queryList)) continue;
                return false;
            }
            if (queryValue instanceof Resource) {
                if (rPropValue instanceof RiRepoResource) {
                    if (((RiRepoResource)rPropValue).testForQueryMatch(queryValue)) continue;
                    return false;
                }
                if (rPropValue instanceof List) {
                    if (this.testForQueryMatch((List)rPropValue, (Resource)queryValue)) continue;
                    return false;
                }
                return false;
            }
            if (queryValue instanceof List) {
                List vList = (List)queryValue;
                if (!(rPropValue instanceof ArrayList)) {
                    return false;
                }
                List rList2 = (List)rPropValue;
                if (rList2.containsAll(vList)) continue;
                return false;
            }
            if (!(rPropValue instanceof ArrayList ? !(rList = (List)rPropValue).contains(queryValue) : !queryValue.equals(rPropValue))) continue;
            return false;
        }
        return true;
    }

    private boolean testForQueryMatch(List<?> list, Object query) {
        int i = 0;
        while (i < list.size()) {
            Object val = list.get(i);
            if (val instanceof RiRepoResource && ((RiRepoResource)val).testForQueryMatch(query)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean testForQueryMatch(Object val, List<?> queryList) {
        int i = 0;
        while (i < queryList.size()) {
            Object query = queryList.get(i);
            if (val instanceof RiRepoResource ? ((RiRepoResource)val).testForQueryMatch(query) : val instanceof List && this.testForQueryMatch((List)val, query)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean is_creationInProgress() {
        return this._creationInProgress;
    }

    public void set_creationInProgress(boolean creationInProgress) {
        this._creationInProgress = creationInProgress;
    }

    @Override
    protected void readCustomProperties(ResourceImpl resource, PropertyRequestItem.PropertyRequest propertyRequest, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        for (PropertyNameList.PropertyName<?> propertyName : this._properties.keySet()) {
            if (!RiRepoResource.isCustomProperty(propertyName)) continue;
            this.readThisProperty(resource, propertyName, propertyRequest, configuration, feedback);
        }
    }

    RiRepoIFolder.RepoBinding setupBinding(String bindingName, RiRepoResource child) {
        if (this.lookupBoundMember(bindingName) != null) {
            throw new RuntimeException("folder " + this.calculatePath() + " already has child named " + bindingName);
        }
        RiRepoIFolder.RepoBinding binding = new RiRepoIFolder.RepoBinding((RiRepoIFolder)((Object)this), child, bindingName);
        this.setProperty_AppendToList(RiRepoIFolder.CHILD_BINDING_LIST, binding);
        child.setProperty_AppendToList(PARENT_BINDING_LIST, binding);
        return binding;
    }

    public Map<RiRepoVersionHistory, RiRepoVersion> getVersionMap() {
        throw new RuntimeException("getVersionMap() not supported by this resource");
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (this.versionKnowsParent() && propertyName.getNamespace() == null && this instanceof RiRepoFolderVersion) {
            RiRepoFolderVersion fv = (RiRepoFolderVersion)this;
            if (propertyName.getName().equals("child-map")) {
                return configuration.getFolderVersionChildMap(fv);
            }
            if (propertyName.getName().equals("child-list")) {
                return configuration.getFolderVersionChildList(fv);
            }
        }
        try {
            return this.getProperty(propertyName);
        }
        catch (Exception exception) {
            throw new WvcmException("Property not defined on this resource.  " + propertyName.toString(), WvcmException.ReasonCode.PROPERTY_NOT_DEFINED_FOR_RESOURCE);
        }
    }

    @Override
    public PropertyNameList doGetPropertyNameList(String namespace) throws WvcmException {
        ArrayList propNameList = new ArrayList();
        for (PropertyNameList.PropertyName<?> propertyName : this._properties.keySet()) {
            if (!RiRepoResource.isStandardProperty(propertyName) && !RiRepoResource.isCustomProperty(propertyName)) continue;
            propNameList.add(propertyName);
        }
        PropertyNameList.PropertyName[] propNameArray = new PropertyNameList.PropertyName[propNameList.size()];
        int i = 0;
        while (i < propNameList.size()) {
            propNameArray[i] = (PropertyNameList.PropertyName)propNameList.get(i);
            ++i;
        }
        return new PropertyNameList(propNameArray);
    }

    @Override
    public void doReadContent(OutputStream content, SrvcFeedback feedback) throws WvcmException {
        byte[] bytes = this._content;
        try {
            try {
                if (bytes != null) {
                    content.write(bytes);
                }
            }
            catch (IOException ex) {
                throw new WvcmException("IOException writing content to output stream: " + ex.getMessage(), null, WvcmException.ReasonCode.WRITE_FAILED, (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            try {
                content.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            content.close();
        }
        catch (IOException iOException) {}
    }

    @Override
    public void doWriteContent(InputStream content, String contentIdentifier, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        this.doWriteProperties(updates, updated, feedback);
        try {
            try {
                byte[] allBytes = new byte[]{};
                int numRead = 0;
                byte[] buf = new byte[8192];
                while ((numRead = content.read(buf)) != -1) {
                    byte[] prevBytes = allBytes;
                    allBytes = new byte[prevBytes.length + numRead];
                    System.arraycopy(prevBytes, 0, allBytes, 0, prevBytes.length);
                    System.arraycopy(buf, 0, allBytes, prevBytes.length, numRead);
                }
                this.setContent(allBytes, contentIdentifier);
            }
            catch (IOException ex) {
                throw new WvcmException("IOException reading content from input stream: " + ex.getMessage(), null, WvcmException.ReasonCode.READ_FAILED, (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            try {
                content.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            content.close();
        }
        catch (IOException iOException) {}
    }

    @Override
    public void doCopy(Location destination, Resource.CopyFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        RiRepoResource destinationResource;
        boolean destinationExists;
        boolean overwrite = false;
        if (flags != null) {
            int i = 0;
            while (i < flags.length) {
                if (flags[i] == Resource.CopyFlag.OVERWRITE) {
                    overwrite = true;
                }
                ++i;
            }
        }
        boolean bl = destinationExists = (destinationResource = (RiRepoResource)this.get_provider().lookup(destination, feedback)) != null;
        if (destinationExists && !overwrite) {
            throw new WvcmException("There already is a resource at the destination, and overwrite is false", WvcmException.ReasonCode.CANNOT_OVERWRITE);
        }
        if (this instanceof RiRepoFolderVersion) {
            throw new WvcmException("Cannot copy resource type FolderVersion", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
        if (this instanceof RiRepoVersionHistory) {
            throw new WvcmException("Cannot copy resource type VersionHistory", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
        if (this instanceof RiRepoConfiguration || this instanceof RiRepoBaseline || this.getClass() == RiRepoFolder.class) {
            throw new WvcmException("Cannot copy this resource type: " + this.getClass(), WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
        if (this instanceof RiRepoVersion) {
            RiRepoResource parent = this.checkValidCRDestination(destination);
            if (!(parent instanceof RiRepoControllableFolder)) {
                throw new WvcmException("Destination location is invalid: " + destination, WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION);
            }
            RiRepoVersion version = (RiRepoVersion)this;
            RiRepoControllableResource resource = (RiRepoControllableResource)this.get_provider().lookup(destination, feedback);
            if (resource == null) {
                resource = (RiRepoControllableResource)RiRepoControllableResource.doCreateControllableResource(this.get_provider(), destination, null, null, feedback);
            }
            resource.setContent(version.get_content(), (String)resource.getProperty(Resource.CONTENT_IDENTIFIER));
        } else if (this instanceof RiRepoControllableResource) {
            RiRepoResource parent = this.checkValidCRDestination(destination);
            if (this.getClass() == RiRepoControllableResource.class && !(parent instanceof RiRepoControllableFolder)) {
                throw new WvcmException("Destination location is invalid: " + destination, WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION);
            }
            RiRepoControllableResource resource2 = (RiRepoControllableResource)this;
            resource2.copyControllableResourceContent(destination);
        } else {
            throw new WvcmException("Cannot copy this type of resource." + destination, WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
    }

    public static List<Object> doFind(Resource query, PropertyRequestItem.PropertyRequest propertyRequest, boolean all, SrvcFeedback feedback) throws WvcmException {
        RiRepo repo = RiRepo.get_Repo(query.location(), (SrvcProvider)((RiProvider)query.provider()));
        HashSet<Resource> set = new HashSet<Resource>();
        RiRepoFolder topRes = repo.getRootFolder();
        SrvcResource context = RiRepoResource.prepareQuery(query);
        super.recurseExecuteQuery(query, set, propertyRequest, context, all, feedback);
        ArrayList<Object> results = new ArrayList<Object>(set.size());
        results.addAll(set);
        return results;
    }

    @Override
    public void doUnbindAll(SrvcFeedback feedback) throws WvcmException {
        List origBindings = this.getListProperty(PARENT_BINDING_LIST);
        ArrayList parentBindings = new ArrayList(origBindings);
        int i = 0;
        while (i < parentBindings.size()) {
            RiRepoIFolder.RepoBinding parentBinding = (RiRepoIFolder.RepoBinding)parentBindings.get(i);
            RiRepoIFolder parentFolder = parentBinding.get_bindingFolder();
            parentFolder.doUnbindChild(parentBinding.get_bindingName(), feedback);
            ++i;
        }
    }

    public List<RiRepoIFolder.RepoBinding> getParentBindingList() {
        return this.getListProperty(PARENT_BINDING_LIST);
    }

    public <T, U> Map<T, U> getMapProperty(PropertyNameList.PropertyName<?> propertyName) {
        return (Map)this.getProperty(propertyName);
    }

    public <T> List<T> getListProperty(PropertyNameList.PropertyName<?> propertyName) {
        return (List)this.getProperty(propertyName);
    }
}

