/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.repo;

import com.ibm.rational.wvcm.ri.impl.ConfigurationImpl;
import com.ibm.rational.wvcm.ri.repo.RiRepo;
import com.ibm.rational.wvcm.ri.repo.RiRepoActivity;
import com.ibm.rational.wvcm.ri.repo.RiRepoBaseline;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersion;
import com.ibm.rational.wvcm.ri.repo.RiRepoWorkspace;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.wvcm.Baseline;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableResource;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiRepoConfiguration
extends RiRepoControllableResource {
    @Override
    public Class<?> get_proxyClass() {
        return ConfigurationImpl.class;
    }

    protected RiRepoConfiguration(RiRepoResource parent, String bindingName, SrvcProvider provider, RiRepo repo) {
        super(parent, bindingName, provider, repo);
        this.initialize();
    }

    private void initialize() {
        this.createProperty(Configuration.ROOT_FOLDER, null);
    }

    public void bind(String destination, boolean overwrite) throws WvcmException {
        throw new WvcmException("doBindChild not supported for this resource type", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public void unbind(String location) throws WvcmException {
        throw new WvcmException("doUnbindChild not supported for this resource type", WvcmException.ReasonCode.CONFLICT);
    }

    public void rebind(String source, String destination, boolean overwrite) throws WvcmException {
        throw new WvcmException("doRebindChild not supported for this resource type", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean canAutoMerge(RiRepoVersion srcVersion) throws WvcmException {
        RiRepoWorkspace workspace = this.getWorkspace();
        RiRepoBaseline sourceBaseline = (RiRepoBaseline)srcVersion;
        List<RiRepoVersion> sourceVersions = sourceBaseline.getVersionList();
        int i = 0;
        while (i < sourceVersions.size()) {
            RiRepoVersion sourceBaselineVersion = sourceVersions.get(i);
            RiRepoControllableResource target = workspace.locateByHistoryReport(sourceBaselineVersion.getVersionHistory());
            if (target != null && !target.isNoCheckoutMerge(sourceBaselineVersion, false)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void autoMergeBaseline(RiRepoBaseline oldBaseline, RiRepoBaseline newBaseline, Workspace.MergeFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        this.setProperty_AppendUniqueToList(ControllableResource.AUTO_MERGE_LIST, newBaseline);
        this.getWorkspace().doMerge(newBaseline.getVersionList(), flags, feedback);
    }

    @Override
    protected boolean isControlledStateDifferent(RiRepoVersion version) {
        RiRepoActivity otherAct;
        RiRepoBaseline baseline = (RiRepoBaseline)version;
        if (super.isControlledStateDifferent(baseline)) {
            return true;
        }
        RiRepoActivity thisAct = (RiRepoActivity)this.getProperty(Configuration.ACTIVITY);
        if (thisAct != (otherAct = (RiRepoActivity)baseline.getProperty(Baseline.ACTIVITY))) {
            return true;
        }
        List<RiRepoVersion> versionList1 = baseline.getVersionList();
        ArrayList<RiRepoVersion> versionList2 = new ArrayList<RiRepoVersion>();
        this.getRootFolder().createBaselineVersionList(versionList2);
        HashSet<RiRepoVersion> set1 = new HashSet<RiRepoVersion>(versionList1);
        HashSet<RiRepoVersion> set2 = new HashSet<RiRepoVersion>(versionList2);
        return !set1.equals(set2);
    }

    public RiRepoControllableFolder getRootFolder() {
        return (RiRepoControllableFolder)this.getProperty(Configuration.ROOT_FOLDER);
    }
}

