/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.impl;

import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.ResourceImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Baseline;
import javax.wvcm.ControllableResource;
import javax.wvcm.Feedback;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WvcmServiceConverter {
    protected static PropertyRequestItem.PropertyRequest getPropertyRequestForResult(Feedback feedback) {
        if (feedback == null) {
            return null;
        }
        return feedback.getPropertyRequestForResult();
    }

    protected static PropertyRequestItem.PropertyRequest getPropertyRequestForModified(Feedback feedback) {
        if (feedback == null) {
            return null;
        }
        return feedback.getPropertyRequestForModified();
    }

    protected static Map<PropertyNameList.PropertyName<?>, PropValue> collectUpdates(Map<PropertyNameList.PropertyName<?>, PropValue> propMap) {
        HashMap updates = new HashMap();
        for (PropertyNameList.PropertyName<?> pName : propMap.keySet()) {
            PropValue pValue = propMap.get(pName);
            if (!pValue.is_updated() && !pValue.is_removed()) continue;
            PropValue newPValue = WvcmServiceConverter.convertToRemotable(pValue);
            updates.put(pName, newPValue);
        }
        return updates;
    }

    private static PropValue convertToRemotable(PropValue pValue) {
        if (!pValue.is_updated()) {
            return pValue;
        }
        PropertyNameList.PropertyName<?> pName = pValue.get_propertyName();
        Object value = pValue.get_value();
        if (value instanceof Resource) {
            PropValue newPV = new PropValue(pName, ((Resource)value).location());
            newPV.set_updated(true);
            return newPV;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() == 0 || !(list.get(0) instanceof Resource)) {
                return pValue;
            }
            ArrayList<Location> newList = new ArrayList<Location>(list.size());
            int i = 0;
            while (i < list.size()) {
                Resource r = (Resource)list.get(i);
                newList.add(r.location());
                ++i;
            }
            PropValue newPV = new PropValue(pName, newList);
            newPV.set_updated(true);
            return newPV;
        }
        return pValue;
    }

    private static List<Map<PropertyNameList.PropertyName<?>, PropValue>> collectUpdates(ResourceList<?> resourceList) {
        ArrayList updatesList = new ArrayList();
        int i = 0;
        while (i < resourceList.size()) {
            ResourceImpl resource = (ResourceImpl)resourceList.get(i);
            updatesList.add(WvcmServiceConverter.collectUpdates(resource.getPropMap()));
            ++i;
        }
        return updatesList;
    }

    protected static void processResults(ResourceImpl thisResource, List<PropertyNameList.PropertyName<?>> updated, Feedback feedback, List<Resource> modified) {
        PropertyRequestItem.PropertyRequest propertyRequest;
        HashMap<PropertyNameList.PropertyName<?>, PropValue> resourcePropMap = thisResource.getPropMap();
        if (updated != null) {
            for (PropertyNameList.PropertyName<?> pNameUpdated : updated) {
                PropValue pValueInResource = (PropValue)resourcePropMap.get(pNameUpdated);
                if (pValueInResource == null) {
                    String message = String.format("unexpected property (%s) update on resource at: %s", pNameUpdated.toString(), thisResource.location().string());
                    throw new RuntimeException(message);
                }
                if (pValueInResource.is_removed()) {
                    resourcePropMap.remove(pNameUpdated);
                    continue;
                }
                if (pValueInResource.is_updated()) {
                    pValueInResource.set_updated(false);
                    continue;
                }
                String message = String.format("unexpected property (%s) update on resource at: %s", pNameUpdated.toString(), thisResource.location().string());
                throw new RuntimeException(message);
            }
        }
        if (modified != null && (propertyRequest = WvcmServiceConverter.getPropertyRequestForModified(feedback)) != null) {
            int i = 0;
            while (i < modified.size()) {
                feedback.notifyIsModified(modified.get(i));
                ++i;
            }
        }
        if (feedback != null) {
            feedback.notifyPercentComplete(100);
        }
    }

    private static void processResults(ResourceList<?> resourceList, List<List<PropertyNameList.PropertyName<?>>> updatedList, Feedback feedback, List<Resource> modified) {
        int i = 0;
        while (i < resourceList.size()) {
            ResourceImpl resource = (ResourceImpl)resourceList.get(i);
            List<PropertyNameList.PropertyName<?>> updated = updatedList != null && updatedList.size() > i ? updatedList.get(i) : null;
            WvcmServiceConverter.processResults(resource, updated, feedback, modified);
            ++i;
        }
    }

    public static Resource doCreateControllableResource(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doCreateControllableResource(location, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doCreateVersionControlledResource(ResourceImpl thisResource, Location versionLoc, Feedback feedback) throws WvcmException {
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doCreateVersionControlledResource(location, versionLoc, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doCreateControllableSymbolicLink(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doCreateControllableSymbolicLink(location, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doCreateControllableFolder(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doCreateControllableFolder(location, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doCreateBaselineControlledFolder(ResourceImpl thisResource, Location baselineLoc, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doCreateBaselineControlledFolder(location, baselineLoc, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doCreateWorkspace(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doCreateWorkspace(location, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doCreateGeneratedWorkspace(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doCreateGeneratedWorkspace(location, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doCreateActivity(ResourceImpl thisResource, boolean isStream, Feedback feedback) throws WvcmException {
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doCreateActivity(location, isStream, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doCreateGeneratedActivity(ResourceImpl thisResource, boolean isStream, Feedback feedback) throws WvcmException {
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doCreateGeneratedActivity(location, isStream, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doCreateGeneratedTask(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doCreateGeneratedTask(location, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doFind(ResourceImpl thisResource, ResourceImpl query, Feedback feedback) throws WvcmException {
        Resource result = null;
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        try {
            try {
                result = provider.service().doFind(query, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static List<Object> doFindAll(ResourceImpl thisResource, ResourceImpl query, Feedback feedback) throws WvcmException {
        List<Object> result = null;
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        try {
            try {
                result = provider.service().doFindAll(query, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static PropertyNameList doGetPropertyNameList(ResourceImpl thisResource, String namespace, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        PropertyNameList result = null;
        try {
            try {
                result = provider.service().doGetPropertyNameList(location, namespace, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doReadProperties(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doUpdateProperties(location, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doWriteProperties(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doUpdateProperties(location, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doReadContent(ResourceImpl thisResource, OutputStream content, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doReadContent(location, content, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doWriteContent(ResourceImpl thisResource, InputStream content, String contentIdentifier, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doWriteContent(location, content, contentIdentifier, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doCopy(ResourceImpl thisResource, Location destination, Resource.CopyFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            result = provider.service().doCopy(location, destination, flags, updates, updated, feedback);
        }
        catch (WvcmException ex) {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            thisResource.wrapEx(ex);
        }
        WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        return result;
    }

    public static void doUnbindAll(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        try {
            provider.service().doUnbindAll(location, updates, updated, feedback);
        }
        catch (WvcmException ex) {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            thisResource.wrapEx(ex);
        }
        WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
    }

    public static Resource doBindChild(ResourceImpl thisResource, String bindingName, Location childLocation, Folder.BindFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doBindChild(location, bindingName, childLocation, flags, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doRebindChild(ResourceImpl thisResource, String bindingName, Location sourceFolderLocation, String sourceBindingName, Folder.RebindFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doRebindChild(location, bindingName, sourceFolderLocation, sourceBindingName, flags, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doRebindAll(ResourceImpl thisResource, String bindingName, Location sourceLocation, Folder.RebindFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doRebindAll(location, bindingName, sourceLocation, flags, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doUnbindChild(ResourceImpl thisResource, String bindingName, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doUnbindChild(location, bindingName, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static List<Object> doReadMemberList(ResourceImpl thisResource, boolean deep, Feedback feedback) throws WvcmException {
        List<Object> result = null;
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        try {
            try {
                result = provider.service().doReadMemberList(location, deep, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doVersionControl(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doVersionControl(location, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doCheckin(ResourceImpl thisResource, ControllableResource.CheckinFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doCheckin(location, flags, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doCheckout(ResourceImpl thisResource, ControllableResource.CheckoutFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doCheckout(location, flags, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doUncheckout(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doUncheckout(location, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doSetLabel(ResourceImpl thisResource, String label, boolean overwrite, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doSetLabel(location, label, overwrite, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doRemoveLabel(ResourceImpl thisResource, String label, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doRemoveLabel(location, label, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doReadLabelledVersionProperties(ResourceImpl thisResource, String label, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource version = null;
        try {
            try {
                version = provider.service().doReadLabelledVersionProperties(location, label, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return version;
    }

    public static Resource doBaselineControl(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doBaselineControl(location, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static List<Object> doCompareReport(ResourceImpl thisResource, Location otherLocation, Baseline.CompareFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        List<Object> result = null;
        try {
            try {
                result = provider.service().doCompareReport(location, otherLocation, flags, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static <T extends Resource> List<Object> doMergePreviewReport(ResourceImpl thisResource, List<T> sourceList, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        ArrayList<Location> sourceLocations = new ArrayList<Location>();
        int i = 0;
        while (i < sourceList.size()) {
            Resource r = (Resource)sourceList.get(i);
            if (r == null) {
                throw new WvcmException("Cannot have null entry in doMergePreview source list", (Resource)thisResource, WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
            }
            sourceLocations.add(r.location());
            ++i;
        }
        List<Object> result = null;
        try {
            try {
                result = provider.service().doMergePreviewReport(location, sourceLocations, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static <T extends Resource> Resource doMerge(ResourceImpl thisResource, List<T> sourceList, Workspace.MergeFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        ArrayList<Location> sourceLocations = new ArrayList<Location>();
        int i = 0;
        while (i < sourceList.size()) {
            Resource r = (Resource)sourceList.get(i);
            if (r == null) {
                throw new WvcmException("Cannot have null entry in doMerge source list", (Resource)thisResource, WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
            }
            sourceLocations.add(r.location());
            ++i;
        }
        Resource result = null;
        try {
            try {
                result = provider.service().doMerge(location, sourceLocations, flags, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static <T extends Resource> Resource doUpdate(ResourceImpl thisResource, List<T> sourceList, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        ArrayList<Location> sourceLocations = new ArrayList<Location>();
        int i = 0;
        while (i < sourceList.size()) {
            Resource r = (Resource)sourceList.get(i);
            if (r == null) {
                throw new WvcmException("Cannot have null entry in doUpdate source list", (Resource)thisResource, WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
            }
            sourceLocations.add(r.location());
            ++i;
        }
        Resource result = null;
        try {
            try {
                result = provider.service().doUpdate(location, sourceLocations, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doLatestActivityVersionReport(ResourceImpl thisResource, Location activityLoc, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doLatestActivityVersionReport(location, activityLoc, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static <T extends Resource> Resource doVersionControl(ResourceImpl thisResource, ResourceList<T> resources, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        ArrayList<Location> locations = new ArrayList<Location>();
        int i = 0;
        while (i < resources.size()) {
            Resource r = (Resource)resources.get(i);
            if (r == null) {
                throw new WvcmException("Cannot have null entry in doVersionControl resource list", (Resource)thisResource, WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
            }
            locations.add(r.location());
            ++i;
        }
        Resource result = null;
        try {
            try {
                result = provider.service().doVersionControl(location, locations, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static Resource doCheckinAll(ResourceImpl thisResource, String comment, ControllableResource.CheckinFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        Resource result = null;
        try {
            try {
                result = provider.service().doCheckinAll(location, comment, flags, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static <T extends Resource> Resource doCheckin(ResourceImpl thisResource, ResourceList<T> resources, String comment, ControllableResource.CheckinFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        ArrayList<Location> locations = new ArrayList<Location>();
        int i = 0;
        while (i < resources.size()) {
            Resource r = (Resource)resources.get(i);
            if (r == null) {
                throw new WvcmException("Cannot have null entry in doCheckin resource list", (Resource)thisResource, WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
            }
            locations.add(r.location());
            ++i;
        }
        Resource result = null;
        try {
            try {
                result = provider.service().doCheckin(location, locations, comment, flags, updates, updated, feedback);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, modified);
        }
        return result;
    }

    public static List<Object> doUpdateProperties(SrvcProvider provider, ResourceList<?> resources, Feedback feedback) throws WvcmException {
        List<Object> result = null;
        ArrayList updatedList = new ArrayList();
        List<Map<PropertyNameList.PropertyName<?>, PropValue>> updatesList = WvcmServiceConverter.collectUpdates(resources);
        ArrayList<Location> locations = new ArrayList<Location>();
        int i = 0;
        while (i < resources.size()) {
            Resource r = (Resource)resources.get(i);
            if (r == null) {
                throw new WvcmException("Cannot have null entry in doReadProperties resource list", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
            }
            locations.add(r.location());
            ++i;
        }
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        try {
            result = provider.service().doUpdateProperties(locations, updatesList, updatedList, feedback);
        }
        finally {
            WvcmServiceConverter.processResults(resources, updatedList, feedback, modified);
        }
        return result;
    }

    public static List<Object> doUpdateContextProperties(SrvcProvider provider, ResourceList<?> resources, Resource context, Feedback feedback) throws WvcmException {
        List<Object> result = null;
        ArrayList updatedList = new ArrayList();
        List<Map<PropertyNameList.PropertyName<?>, PropValue>> updatesList = WvcmServiceConverter.collectUpdates(resources);
        ArrayList<Location> locations = new ArrayList<Location>();
        int i = 0;
        while (i < resources.size()) {
            Resource r = (Resource)resources.get(i);
            if (r == null) {
                throw new WvcmException("Cannot have null entry in doReadProperties resource list", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
            }
            locations.add(r.location());
            ++i;
        }
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        try {
            result = provider.service().doUpdateContextProperties(locations, context.location(), updatesList, updatedList, feedback);
        }
        finally {
            WvcmServiceConverter.processResults(resources, updatedList, feedback, modified);
        }
        return result;
    }

    public static List<Object> doFind(SrvcProvider provider, ResourceList<?> queries, Feedback feedback) throws WvcmException {
        List<Object> result = null;
        ArrayList updatedList = new ArrayList();
        List<Map<PropertyNameList.PropertyName<?>, PropValue>> updatesList = WvcmServiceConverter.collectUpdates(queries);
        PropertyRequestItem.PropertyRequest modifiedPR = WvcmServiceConverter.getPropertyRequestForModified(feedback);
        ArrayList<Resource> modified = modifiedPR == null ? null : new ArrayList<Resource>();
        try {
            result = provider.service().doFind(queries, updatesList, updatedList, feedback);
        }
        finally {
            WvcmServiceConverter.processResults(queries, updatedList, feedback, modified);
        }
        return result;
    }
}

