/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.util;

import com.ibm.team.filesystem.cli.core.CommandLineCore;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry$IUuidAlias;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry$NoSuchAliasException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView$IRepoView;
import com.ibm.team.filesystem.cli.core.util.RepoUtil$1;
import com.ibm.team.filesystem.cli.core.util.RepoUtil$AmbiguousSelectorException;
import com.ibm.team.filesystem.cli.core.util.RepoUtil$SelectorException;
import com.ibm.team.filesystem.cli.core.util.RepoUtil$SelectorException$Type;
import com.ibm.team.filesystem.cli.core.util.RepoUtil$TripListener;
import com.ibm.team.filesystem.cli.core.util.RepoUtil$UnmatchedSelectorException;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.cli.core.util.WorkspaceComponentGrouping;
import com.ibm.team.filesystem.cli.core.util.datastructures.ItemMap;
import com.ibm.team.filesystem.cli.core.util.datastructures.ItemMap$Entry;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CompareInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentBaselineSetUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentFlowUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.links.common.ILink;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.scm.common.internal.query.BaseChangeSetQueryModel;
import com.ibm.team.scm.common.internal.query.BaseWorkspaceQueryModel;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import com.ibm.team.workitem.common.internal.model.query.BaseWorkItemQueryModel;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public abstract class RepoUtil {
    public static ITeamRepository loginUrlArgAnc(IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        ICopyFileAreaView iCopyFileAreaView;
        ICommandLine iCommandLine = iClientConfiguration.getSubcommandCommandLine();
        if (iCommandLine.hasOption(CommonOptions.OPT_URI)) {
            return RepoUtil.login(iClientConfiguration, iClientConfiguration.getConnectionInfo(iCommandLine.getOption(CommonOptions.OPT_URI)));
        }
        try {
            iCopyFileAreaView = SubcommandUtil.getAffectedComponentsAndShares(iClientConfiguration);
        }
        catch (FileSystemClientException fileSystemClientException) {
            throw (Throwable)StatusHelper.failure("Unexpected exception", fileSystemClientException);
        }
        Collection collection = iCopyFileAreaView.getLoadedWorkspaces();
        if (collection.size() != 1) {
            throw (Throwable)StatusHelper.argSyntax(Messages.RepoUtil_99);
        }
        if (!$assertionsDisabled && collection.size() != 1) {
            throw (Throwable)((Object)new AssertionError());
        }
        ICopyFileAreaView$IRepoView iCopyFileAreaView$IRepoView = (ICopyFileAreaView$IRepoView)collection.iterator().next();
        ConnectionInfo connectionInfo = iClientConfiguration.getConnectionInfo(iCopyFileAreaView$IRepoView.getURI());
        return RepoUtil.login(iClientConfiguration, connectionInfo);
    }

    public static ITeamRepository login(IClientConfiguration iClientConfiguration, ConnectionInfo connectionInfo) throws FileSystemClientException {
        if (connectionInfo.getUsername() == null) {
            throw (Throwable)new IllegalArgumentException(Messages.RepoUtil_1);
        }
        if (connectionInfo.getPassword() == null) {
            throw (Throwable)new IllegalArgumentException(Messages.RepoUtil_2);
        }
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        ITeamRepository iTeamRepository = null;
        try {
            iTeamRepository = TeamPlatform.getTeamRepositoryService().getTeamRepository(connectionInfo.getURI());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.RepoUtil_3, (Object)connectionInfo.getURI()));
        }
        if (IClientConfiguration.DEBUG_TRIPS) {
            iClientConfiguration.addApplicationEndListener(new RepoUtil$TripListener(iTeamRepository));
        }
        iTeamRepository.registerLoginHandler((ITeamRepository.ILoginHandler)new RepoUtil$1(connectionInfo));
        try {
            iTeamRepository.login(null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.login(connectionInfo, teamRepositoryException);
        }
        if (!iTeamRepository.loggedIn()) {
            throw (Throwable)StatusHelper.failure(Messages.RepoUtil_4, null);
        }
        return iTeamRepository;
    }

    public static List componentComplement(IFlowNodeConnection iFlowNodeConnection, Collection collection) throws FileSystemClientException {
        LinkedList linkedList = new LinkedList();
        try {
            List list = iFlowNodeConnection.getComponents();
            linkedList.addAll(list);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_6);
        }
        block2: for (List list : collection) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                IComponentHandle iComponentHandle = (IComponentHandle)iterator.next();
                if (!list.sameItemId((IItemHandle)iComponentHandle)) continue;
                iterator.remove();
                continue block2;
            }
        }
        return linkedList;
    }

    public static IWorkspaceHandle findNamedWorkspace(String string, boolean bl, boolean bl2, ITeamRepository iTeamRepository) throws FileSystemClientException, RepoUtil$UnmatchedSelectorException, RepoUtil$AmbiguousSelectorException {
        List list;
        UUID uUID = RepoUtil.lookupUuid(string);
        BaseWorkspaceQueryModel.WorkspaceQueryModel workspaceQueryModel = BaseWorkspaceQueryModel.WorkspaceQueryModel.ROOT;
        IItemQuery iItemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)workspaceQueryModel);
        IPredicate iPredicate = workspaceQueryModel.name()._eq(string);
        if (!bl || !bl2) {
            if (bl && !bl2) {
                iPredicate = iPredicate._and(workspaceQueryModel.stream()._eq(Boolean.FALSE));
            } else if (!bl && bl2) {
                iPredicate = iPredicate._and(workspaceQueryModel.stream()._eq(Boolean.TRUE));
            } else {
                throw (Throwable)new IllegalArgumentException(Messages.RepoUtil_8);
            }
        }
        if (uUID != null) {
            iPredicate = iPredicate._or(workspaceQueryModel.itemId()._eq(uUID));
        }
        iItemQuery.filter(iPredicate);
        try {
            list = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).findItems(iItemQuery, new Object[0]);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_9);
        }
        if (list.size() == 0) {
            throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.WORKSPACE, string, Collections.EMPTY_LIST);
        }
        if (list.size() > 1) {
            List list2;
            try {
                list2 = iTeamRepository.itemManager().fetchPartialItems(list, 0, (Collection)Collections.singletonList(IWorkspace.NAME_PROPERTY), null);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_10);
            }
            throw (Throwable)new RepoUtil$AmbiguousSelectorException(RepoUtil$SelectorException$Type.WORKSPACE, string, list2, list2);
        }
        return (IWorkspaceHandle)list.get(0);
    }

    public static UUID lookupUuid(String string) {
        try {
            IClientConfiguration iClientConfiguration = CommandLineCore.getConfig();
            if (iClientConfiguration != null) {
                IUuidAliasRegistry$IUuidAlias iUuidAliasRegistry$IUuidAlias = iClientConfiguration.getAliasRegistry().findAliasByName(string);
                return iUuidAliasRegistry$IUuidAlias.getUuid();
            }
        }
        catch (IUuidAliasRegistry$NoSuchAliasException iUuidAliasRegistry$NoSuchAliasException) {}
        try {
            return UUID.valueOf((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static IWorkspaceConnection findNamedWorkspaceConnection(String string, boolean bl, boolean bl2, ITeamRepository iTeamRepository) throws FileSystemClientException, RepoUtil$UnmatchedSelectorException, RepoUtil$AmbiguousSelectorException {
        IWorkspaceHandle iWorkspaceHandle = RepoUtil.findNamedWorkspace(string, bl, bl2, iTeamRepository);
        IWorkspaceManager iWorkspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository);
        try {
            return iWorkspaceManager.getWorkspaceConnection(iWorkspaceHandle, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, NLS.bind((String)Messages.RepoUtil_11, (Object)string));
        }
    }

    public static List findNamedComponents(List list, boolean bl, IWorkspaceConnection iWorkspaceConnection, ITeamRepository iTeamRepository) throws FileSystemClientException, RepoUtil$UnmatchedSelectorException, RepoUtil$AmbiguousSelectorException {
        List list2;
        LinkedList<IComponent> linkedList;
        if (list.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        try {
            linkedList = iWorkspaceConnection.getComponents();
            list2 = iTeamRepository.itemManager().fetchPartialItems((List)linkedList, 0, (Collection)Collections.singletonList(IComponent.NAME_PROPERTY), null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_14);
        }
        linkedList = new LinkedList<IComponent>();
        int n = 0;
        while (n < list.size()) {
            Object object = (String)list.get(n);
            try {
                IClientConfiguration iClientConfiguration = CommandLineCore.getConfig();
                if (iClientConfiguration != null) {
                    object = iClientConfiguration.getAliasRegistry().findAliasByName((String)object).getUuid().getUuidValue();
                }
            }
            catch (IUuidAliasRegistry$NoSuchAliasException iUuidAliasRegistry$NoSuchAliasException) {}
            int n2 = 0;
            LinkedList<IComponent> linkedList2 = new LinkedList<IComponent>();
            for (IComponent iComponent : list2) {
                if (!iComponent.getName().equals(object) && !iComponent.getItemId().getUuidValue().equals(object)) continue;
                ++n2;
                linkedList.add(iComponent);
                linkedList2.add(iComponent);
            }
            if (n2 == 0) {
                throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.COMPONENT, (String)object, list2);
            }
            if (n2 > 1) {
                throw (Throwable)new RepoUtil$AmbiguousSelectorException(RepoUtil$SelectorException$Type.COMPONENT, (String)object, list2, linkedList2);
            }
            ++n;
        }
        if (bl) {
            for (IComponent iComponent : list2) {
                if (linkedList.contains(iComponent)) continue;
                linkedList.add(iComponent);
            }
        }
        return linkedList;
    }

    public static List pruneToNamedChangeSets(IWorkspaceConnection iWorkspaceConnection, List list, Collection collection, Set set) throws FileSystemClientException, RepoUtil$UnmatchedSelectorException {
        List<String> list2;
        Object object4;
        String string2;
        Object object2;
        if (list == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (set == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(list);
        Object object3 = linkedList.iterator();
        while (object3.hasNext()) {
            object2 = (IChangeSetHandle)object3.next();
            for (String string2 : collection) {
                if (!RepoUtil.uuidMatchesSelector(object2.getItemId(), string2)) continue;
                object3.remove();
                arrayList.add(object2);
                set.add(string2);
            }
        }
        if (arrayList.size() == collection.size()) {
            return arrayList;
        }
        try {
            object3 = iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItems((List)linkedList, 0, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_16);
        }
        object2 = object3.iterator();
        while (object2.hasNext()) {
            string2 = (IChangeSet)object2.next();
            for (Object object4 : collection) {
                if (!((String)object4).equals(string2.getComment())) continue;
                object2.remove();
                arrayList.add(string2);
                set.add(object4);
            }
        }
        linkedList = null;
        if (object3.size() == 0) {
            return arrayList;
        }
        object2 = new ItemMap();
        object4 = object3.iterator();
        while (object4.hasNext()) {
            string2 = (IChangeSet)object4.next();
            list2 = (List)((ItemMap)object2).get(string2.getComponent());
            if (list2 == null) {
                list2 = new LinkedList<String>();
                ((ItemMap)object2).put(string2.getComponent(), list2);
            }
            list2.add(string2);
        }
        block9: for (String string2 : collection) {
            list2 = ((ItemMap)object2).iterator();
            while (list2.hasNext()) {
                ItemMap$Entry itemMap$Entry = (ItemMap$Entry)list2.next();
                LinkedList linkedList2 = new LinkedList();
                boolean bl = false;
                try {
                    bl = RepoUtil.findNamedChangeSetByWorkItem(iWorkspaceConnection, (IComponentHandle)itemMap$Entry.getKey(), string2, (List)itemMap$Entry.getValue(), linkedList2);
                }
                catch (RepoUtil$SelectorException repoUtil$SelectorException) {
                    continue;
                }
                if (!bl) continue;
                set.add(string2);
                arrayList.addAll(linkedList2);
                list2.remove();
                continue block9;
            }
        }
        if (set.size() != collection.size()) {
            object2 = new HashSet();
            object2.addAll(collection);
            object2.removeAll(set);
            throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.CHANGESET, (Collection)object2, null);
        }
        return arrayList;
    }

    private static boolean uuidMatchesSelector(UUID uUID, String string) {
        UUID uUID2 = RepoUtil.lookupUuid(string);
        return uUID2 != null && uUID.equals((Object)uUID2);
    }

    public static List findBaseline(ITeamRepository iTeamRepository, IComponentHandle iComponentHandle, String string) throws TeamRepositoryException {
        UUID uUID = RepoUtil.lookupUuid(string);
        List list = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).findAllBaselines(iComponentHandle, "", null);
        List list2 = iTeamRepository.itemManager().fetchPartialItems(list, 0, (Collection)Collections.singleton(IBaseline.NAME_PROPERTY), null);
        ArrayList<IBaseline> arrayList = new ArrayList<IBaseline>();
        for (IBaseline iBaseline : list2) {
            if (uUID != null) {
                if (!iBaseline.getItemId().equals((Object)uUID)) break;
                arrayList.add(iBaseline);
                break;
            }
            if (!iBaseline.getName().equals(string)) continue;
            arrayList.add(iBaseline);
        }
        return arrayList;
    }

    public static IChangeSetHandle findNamedChangeSet(ITeamRepository iTeamRepository, String string) throws FileSystemClientException, RepoUtil$UnmatchedSelectorException, RepoUtil$AmbiguousSelectorException {
        List list;
        UUID uUID = RepoUtil.lookupUuid(string);
        if (uUID == null) {
            throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.CHANGESET, string, Collections.EMPTY_LIST);
        }
        BaseChangeSetQueryModel.ChangeSetQueryModel changeSetQueryModel = BaseChangeSetQueryModel.ChangeSetQueryModel.ROOT;
        IItemQuery iItemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)changeSetQueryModel);
        IPredicate iPredicate = changeSetQueryModel.itemId()._eq(uUID);
        iItemQuery.filter(iPredicate);
        try {
            list = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).findItems(iItemQuery, new Object[0]);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_9);
        }
        if (list.size() == 0) {
            throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.CHANGESET, string, Collections.EMPTY_LIST);
        }
        if (list.size() > 1) {
            List list2;
            try {
                list2 = iTeamRepository.itemManager().fetchPartialItems(list, 0, (Collection)Collections.singletonList(IWorkspace.NAME_PROPERTY), null);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_10);
            }
            throw (Throwable)new RepoUtil$AmbiguousSelectorException(RepoUtil$SelectorException$Type.WORKSPACE, string, list2, list2);
        }
        return (IChangeSetHandle)list.get(0);
    }

    /*
     * Unable to fully structure code
     */
    public static IChangeSetHandle findNamedChangeSet(IWorkspaceConnection var0, IComponentHandle var1_1, String var2_2) throws RepoUtil$UnmatchedSelectorException, FileSystemClientException, RepoUtil$AmbiguousSelectorException {
        block16: {
            var3_3 = RepoUtil.lookupUuid(var2_2);
            try {
                var5_4 = var0.changeHistory(var1_1).recent(null);
            }
            catch (TeamRepositoryException var6_5) {
                throw (Throwable)StatusHelper.wrap(var6_5, Messages.RepoUtil_18);
            }
            var4_8 = new LinkedList<IChangeSetHandle>();
            for (Object var6_6 : var5_4) {
                var4_8.add(var6_6.changeSet());
            }
            if (var4_8.size() < 1) {
                throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.CHANGESET, var2_2, Collections.EMPTY_LIST);
            }
            try {
                var5_4 = var0.teamRepository().itemManager().fetchPartialItems((List)var4_8, 0, (Collection)Collections.singletonList(IChangeSet.COMMENT_PROPERTY), null);
            }
            catch (TeamRepositoryException var6_7) {
                throw (Throwable)StatusHelper.wrap(var6_7, Messages.RepoUtil_19);
            }
            var6_6 = new LinkedList<E>();
            for (IChangeSet var7_9 : var5_4) {
                if (var7_9.getItemId().equals((Object)var3_3)) {
                    var6_6.add(var7_9);
                    continue;
                }
                if (!var2_2.equals(var7_9.getComment())) continue;
                var6_6.add(var7_9);
            }
            try {
                RepoUtil.findNamedChangeSetByWorkItem(var0, var1_1, var2_2, var5_4, (List)var6_6);
                break block16;
            }
            catch (RepoUtil$UnmatchedSelectorException v0) {
                break block16;
            }
            catch (RepoUtil$AmbiguousSelectorException var7_10) {
                ** for (var8_11 : var7_10.getMatched())
            }
lbl-1000:
            // 1 sources

            {
                var6_6.add((IChangeSet)var8_11);
                continue;
            }
        }
        switch (var6_6.size()) {
            case 0: {
                throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.CHANGESET, var2_2, var5_4);
            }
            case 1: {
                return (IChangeSetHandle)var6_6.get(0);
            }
        }
        throw (Throwable)new RepoUtil$AmbiguousSelectorException(RepoUtil$SelectorException$Type.CHANGESET, var2_2, var5_4, (List)var6_6);
    }

    /*
     * Unable to fully structure code
     */
    public static List findNamedChangeSetsForWorkspace(IWorkspaceConnection var0, String var1_1) throws TeamRepositoryException, FileSystemClientException {
        var2_2 = var0.getComponents();
        var3_3 = new LinkedList<IChangeSetHandle>();
        block3: for (IComponentHandle var4_5 : var2_2) {
            try {
                var6_6 = RepoUtil.findNamedChangeSet(var0, var4_5, var1_1);
                var3_3.add(var6_6);
                continue;
            }
            catch (RepoUtil$UnmatchedSelectorException v0) {
                continue;
            }
            catch (RepoUtil$AmbiguousSelectorException var6_7) {
                ** for (var7_8 : var6_7.getMatched())
            }
lbl-1000:
            // 1 sources

            {
                var3_3.add((IChangeSetHandle)var7_8);
                continue;
lbl16:
                // 1 sources

            }
        }
        return var3_3;
    }

    public static List findChangeSummariesByPath(IClientConfiguration iClientConfiguration, IWorkspaceConnection iWorkspaceConnection, String string) throws TeamRepositoryException, FileSystemClientException {
        return RepoUtil.findChangeSummariesByPath(iClientConfiguration, iWorkspaceConnection, string, true);
    }

    public static List findChangeSummariesByPath(IClientConfiguration iClientConfiguration, IWorkspaceConnection iWorkspaceConnection, String string, boolean bl) throws TeamRepositoryException, FileSystemClientException {
        Object object2;
        List list;
        IWorkspaceHandle iWorkspaceHandle = ComponentFlowUtil.getCurrentCollaboration((IWorkspaceConnection)iWorkspaceConnection);
        Collection collection = null;
        if (iWorkspaceHandle != null) {
            collection = iWorkspaceConnection.getFlowTable().getComponentScopes((IFlowNodeHandle)iWorkspaceHandle);
        }
        LinkedList<CompareInput> linkedList = new LinkedList<CompareInput>();
        if (collection == null || collection.isEmpty()) {
            try {
                list = iWorkspaceConnection.teamRepository().itemManager().fetchPartialItems(iWorkspaceConnection.getComponents(), 0, (Collection)Collections.singletonList(IComponent.NAME_PROPERTY), null);
                for (Object object2 : list) {
                    linkedList.add(new CompareInput((Object)iWorkspaceConnection, (Object)RepoUtil.getCurrentCollaboration(iWorkspaceConnection, (IComponentHandle)object2), Collections.singletonList(object2)));
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)StatusHelper.wrap(teamRepositoryException, NLS.bind((String)Messages.RepoUtil_58, (Object)iWorkspaceConnection.getName()));
            }
        } else {
            linkedList.add(new CompareInput((Object)iWorkspaceConnection, (Object)iWorkspaceHandle, (List)new ArrayList(collection)));
        }
        list = SubcommandUtil.makePath(iClientConfiguration, string);
        if (list != null) {
            list = list.makeAbsolute();
        }
        object2 = new LinkedList();
        for (CompareInput compareInput : linkedList) {
            IComponentSyncContext[] iComponentSyncContextArray;
            IComponentSyncModel iComponentSyncModel = ComponentBaselineSetUtil.create((CompareInput)compareInput, null);
            iComponentSyncModel.refresh(true, null);
            IComponentSyncContext[] iComponentSyncContextArray2 = iComponentSyncContextArray = iComponentSyncModel.getComponentSyncContexts();
            int n = iComponentSyncContextArray.length;
            int n2 = 0;
            while (n2 < n) {
                IComponentSyncContext iComponentSyncContext = iComponentSyncContextArray2[n2];
                List list2 = iComponentSyncContext.getOutgoingActivitySource().getActivities();
                for (IRemoteActivity iRemoteActivity : list2) {
                    if (bl && !iComponentSyncContext.isActive(iRemoteActivity)) continue;
                    List list3 = iRemoteActivity.getChanges();
                    for (IRemoteChangeSummary iRemoteChangeSummary : list3) {
                        Path path;
                        Path path2 = path = iRemoteChangeSummary.getChange().kind() == 16 ? new Path(iRemoteChangeSummary.getBeforePath()) : new Path(iRemoteChangeSummary.getAfterPath());
                        if (!path.equals((Object)list)) continue;
                        object2.add(iRemoteChangeSummary);
                    }
                }
                ++n2;
            }
        }
        return (List)object2;
    }

    public static Map findChangesByPath(IClientConfiguration iClientConfiguration, IWorkspaceConnection iWorkspaceConnection, String string) throws TeamRepositoryException, FileSystemClientException {
        List list = RepoUtil.findChangeSummariesByPath(iClientConfiguration, iWorkspaceConnection, string);
        HashMap<IChangeSetHandle, LinkedList<IChange>> hashMap = new HashMap<IChangeSetHandle, LinkedList<IChange>>();
        for (IRemoteChangeSummary iRemoteChangeSummary : list) {
            IChangeSetHandle iChangeSetHandle = iRemoteChangeSummary.getActivity().getChangeSetHandle();
            LinkedList<IChange> linkedList = (LinkedList<IChange>)hashMap.get(iChangeSetHandle);
            if (linkedList == null) {
                linkedList = new LinkedList<IChange>();
                hashMap.put(iChangeSetHandle, linkedList);
            }
            linkedList.add(iRemoteChangeSummary.getChange());
        }
        return hashMap;
    }

    public static IWorkspaceHandle getCurrentCollaboration(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle) {
        IWorkspaceHandle iWorkspaceHandle = ComponentFlowUtil.getCurrentCollaboration((IWorkspaceConnection)iWorkspaceConnection, (IComponentHandle)iComponentHandle);
        if (iWorkspaceHandle != null) {
            return iWorkspaceHandle;
        }
        iWorkspaceHandle = ComponentFlowUtil.getCurrentCollaboration((IWorkspaceConnection)iWorkspaceConnection);
        if (iWorkspaceHandle != null) {
            return iWorkspaceHandle;
        }
        return FlowUtils.getDefaultFlowTarget((IWorkspaceConnection)iWorkspaceConnection);
    }

    public static Map getWorkItemsForChangeSets(ITeamRepository iTeamRepository, List list, List list2) throws FileSystemClientException {
        Object object;
        Object object22;
        Object object322;
        List list3;
        try {
            list3 = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).getChangeSetLinkSummary((Collection)list2, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_22);
        }
        HashMap<UUID, IWorkItem> hashMap = new HashMap<UUID, IWorkItem>();
        HashMap<UUID, LinkedList<UUID>> hashMap2 = new HashMap<UUID, LinkedList<UUID>>();
        Cloneable cloneable = new ArrayList();
        for (IChangeSetLinkSummary object42 : list3) {
            cloneable.addAll(object42.getLinks());
        }
        try {
            iTeamRepository.itemManager().fetchCompleteItems((List)((Object)cloneable), 0, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_23);
        }
        LinkedList<IWorkItemHandle> linkedList = new LinkedList<IWorkItemHandle>();
        for (Object object322 : list3) {
            try {
                object22 = iTeamRepository.itemManager().fetchCompleteItems(object322.getLinks(), 0, null);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_24);
            }
            Iterator iterator = object22.iterator();
            while (iterator.hasNext()) {
                ILink iLink = (ILink)iterator.next();
                Object object3 = iLink.getTargetRef().resolve();
                if (!(object3 instanceof IWorkItemHandle)) {
                    throw (Throwable)StatusHelper.internalError(NLS.bind((String)Messages.RepoUtil_25, (Object)object3.getClass().getName()));
                }
                IWorkItemHandle iWorkItemHandle = (IWorkItemHandle)object3;
                linkedList.add(iWorkItemHandle);
                UUID uUID = object322.getChangeSet().getItemId();
                LinkedList<UUID> linkedList2 = (LinkedList<UUID>)hashMap2.get(uUID);
                if (linkedList2 == null) {
                    linkedList2 = new LinkedList<UUID>();
                    hashMap2.put(uUID, linkedList2);
                }
                linkedList2.add(iWorkItemHandle.getItemId());
            }
        }
        try {
            object322 = iTeamRepository.itemManager().fetchPartialItems((List)linkedList, 0, (Collection)list, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_26);
        }
        object22 = object322.iterator();
        while (object22.hasNext()) {
            object = (IWorkItem)object22.next();
            hashMap.put(object.getItemId(), (IWorkItem)object);
        }
        cloneable = new HashMap();
        for (Map.Entry entry : hashMap2.entrySet()) {
            object = new ArrayList(((List)entry.getValue()).size());
            for (Object object22 : (List)entry.getValue()) {
                object.add((IWorkItem)hashMap.get(object22));
            }
            cloneable.put((UUID)entry.getKey(), object);
        }
        return (Map)((Object)cloneable);
    }

    private static boolean findNamedChangeSetByWorkItem(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, String string, List list, List list2) throws FileSystemClientException, RepoUtil$AmbiguousSelectorException, RepoUtil$UnmatchedSelectorException {
        List list3;
        List list4;
        Object object2;
        List list5;
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (n <= 0) {
            return false;
        }
        try {
            list5 = SCMPlatform.getWorkspaceManager((ITeamRepository)iWorkspaceConnection.teamRepository()).getChangeSetLinkSummary((Collection)list, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_28);
        }
        HashMap<UUID, LinkedList<UUID>> hashMap = new HashMap<UUID, LinkedList<UUID>>();
        IWorkItem iWorkItem2 = new ArrayList();
        for (Object object2 : list5) {
            iWorkItem2.addAll(object2.getLinks());
        }
        try {
            iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItems((List)iWorkItem2, 0, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_29);
        }
        object2 = new LinkedList();
        for (Object object3 : list5) {
            try {
                list4 = iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItems(object3.getLinks(), 0, null);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_30);
            }
            for (Object object4 : list4) {
                Iterator iterator = object4.getTargetRef().resolve();
                if (!(iterator instanceof IWorkItemHandle)) {
                    throw (Throwable)StatusHelper.internalError(NLS.bind((String)Messages.RepoUtil_31, (Object)iterator.getClass().getName()));
                }
                IWorkItemHandle iWorkItemHandle = (IWorkItemHandle)iterator;
                object2.add(iWorkItemHandle);
                LinkedList<UUID> linkedList = (LinkedList<UUID>)hashMap.get(iWorkItemHandle.getItemId());
                if (linkedList == null) {
                    linkedList = new LinkedList<UUID>();
                    hashMap.put(iWorkItemHandle.getItemId(), linkedList);
                }
                linkedList.add(object3.getChangeSet().getItemId());
            }
        }
        try {
            list3 = iWorkspaceConnection.teamRepository().itemManager().fetchPartialItems((List)object2, 0, (Collection)Collections.singleton(IWorkItem.ID_PROPERTY), null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_32);
        }
        for (IWorkItem iWorkItem2 : list3) {
            Object object4;
            Object object3;
            if (iWorkItem2.getId() != n) continue;
            object3 = (List)hashMap.get(iWorkItem2.getItemId());
            ArrayList arrayList = new ArrayList(object3.size());
            object4 = object3.iterator();
            while (object4.hasNext()) {
                list4 = (UUID)object4.next();
                for (IChangeSet iChangeSet : list) {
                    if (!list4.equals(iChangeSet.getItemId())) continue;
                    arrayList.add(iChangeSet);
                }
            }
            switch (arrayList.size()) {
                case 0: {
                    throw (Throwable)StatusHelper.internalError(Messages.RepoUtil_33);
                }
                case 1: {
                    list2.add((IChangeSet)arrayList.get(0));
                    return true;
                }
            }
            throw (Throwable)new RepoUtil$AmbiguousSelectorException(RepoUtil$SelectorException$Type.CHANGESET, string, list, arrayList);
        }
        throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.CHANGESET, string, null);
    }

    public static IChangeSetHandle createChangeSet(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, String string) throws FileSystemClientException {
        IChangeSetHandle iChangeSetHandle;
        try {
            iChangeSetHandle = iWorkspaceConnection.createChangeSet(iComponentHandle, string, true, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, NLS.bind((String)Messages.RepoUtil_41, (Object)iComponentHandle.getItemId()));
        }
        try {
            iWorkspaceConnection.setCurrentChangeSet(iChangeSetHandle, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, NLS.bind((String)Messages.RepoUtil_42, (Object)iWorkspaceConnection.getName()));
        }
        return iChangeSetHandle;
    }

    public static IComponent createComponentOnWorkspace(IWorkspaceConnection iWorkspaceConnection, String string) throws FileSystemClientException {
        IComponent iComponent;
        ITeamRepository iTeamRepository = iWorkspaceConnection.teamRepository();
        IWorkspaceManager iWorkspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository);
        try {
            iComponent = iWorkspaceManager.createComponent(string, (IAuditableHandle)iTeamRepository.loggedInContributor(), null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_0);
        }
        try {
            iWorkspaceConnection.addComponent((IComponentHandle)iComponent, false, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_97);
        }
        return iComponent;
    }

    public static InputStream findContentFor(ITeamRepository iTeamRepository, IPath iPath, IVersionableHandle iVersionableHandle) throws FileSystemClientException {
        IFileItem iFileItem;
        if (iVersionableHandle == null) {
            return null;
        }
        StateId stateId = new StateId((IItemHandle)iVersionableHandle);
        try {
            iFileItem = (IFileItem)RepoFetcher.fetchItem((ITeamRepository)iTeamRepository, (StateId)stateId, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, NLS.bind((String)Messages.RepoUtil_44, (Object)iPath, (Object)stateId.getItemUUID().getUuidValue()));
        }
        try {
            return iTeamRepository.contentManager().retrieveContentStream(iFileItem.getContent(), null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, NLS.bind((String)Messages.RepoUtil_45, (Object)iPath, (Object)stateId.getItemUUID().getUuidValue()));
        }
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[32000];
        try {
            int n = inputStream.read(byArray);
            while (n > -1) {
                outputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    public static IWorkspaceHandle findAcceptCollaborationFor(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle) {
        IFlowTable iFlowTable = iWorkspaceConnection.getFlowTable();
        IFlowEntry iFlowEntry = iFlowTable.getCurrentDeliverFlow(iComponentHandle);
        if (iFlowEntry == null) {
            iFlowEntry = iFlowTable.getCurrentAcceptFlow();
        }
        if (iFlowEntry == null) {
            iFlowEntry = iFlowTable.getDefaultAcceptFlow();
        }
        if (iFlowEntry == null) {
            return null;
        }
        return (IWorkspaceHandle)iFlowEntry.getFlowNode();
    }

    public static Collection findWorkspaceComponentGroupings(IWorkspaceConnection iWorkspaceConnection, IPath iPath, IPath iPath2) throws FileSystemClientException {
        Map map = SubcommandUtil.getAffectedShareRoots(iPath, iPath2);
        HashMap<String, WorkspaceComponentGrouping> hashMap = new HashMap<String, WorkspaceComponentGrouping>();
        for (Map.Entry entry : map.entrySet()) {
            ISharingDescriptor iSharingDescriptor = ((IShare)entry.getKey()).getSharingDescriptor();
            String string = iSharingDescriptor.getRepositoryUri();
            WorkspaceComponentGrouping workspaceComponentGrouping = (WorkspaceComponentGrouping)hashMap.get(string);
            if (workspaceComponentGrouping == null) {
                IWorkspaceConnection iWorkspaceConnection2;
                if (!iSharingDescriptor.associatedWithWorkspace()) {
                    throw (Throwable)StatusHelper.internalError(NLS.bind((String)Messages.RepoUtil_46, (Object)iSharingDescriptor.getRepositoryUri(), (Object)iSharingDescriptor.getConnectionName()));
                }
                IContextHandle iContextHandle = iSharingDescriptor.getConnectionHandle();
                try {
                    iWorkspaceConnection2 = SCMPlatform.getWorkspaceManager((ITeamRepository)iWorkspaceConnection.teamRepository()).getWorkspaceConnection((IWorkspaceHandle)iContextHandle, null);
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    throw (Throwable)StatusHelper.wrap(teamRepositoryException, NLS.bind((String)Messages.RepoUtil_47, (Object)iWorkspaceConnection.teamRepository().getRepositoryURI(), (Object)iSharingDescriptor.getConnectionName()));
                }
                LinkedList linkedList = new LinkedList();
                workspaceComponentGrouping = new WorkspaceComponentGrouping(iWorkspaceConnection2, linkedList);
                hashMap.put(string, workspaceComponentGrouping);
            }
            workspaceComponentGrouping.getComponents().add(iSharingDescriptor.getComponent());
        }
        return hashMap.values();
    }

    public static Map groupChangeSetsByComponent(IWorkspaceConnection iWorkspaceConnection, List list) throws FileSystemClientException {
        List list2;
        try {
            list2 = iWorkspaceConnection.teamRepository().itemManager().fetchPartialItems(list, 0, (Collection)Collections.singletonList(IChangeSet.COMPONENT_PROPERTY), null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_49);
        }
        HashMap<ItemId, LinkedList<IChangeSet>> hashMap = new HashMap<ItemId, LinkedList<IChangeSet>>();
        for (IChangeSet iChangeSet : list2) {
            ItemId itemId = new ItemId((IItemHandle)iChangeSet.getComponent());
            LinkedList<IChangeSet> linkedList = (LinkedList<IChangeSet>)hashMap.get(itemId);
            if (linkedList == null) {
                linkedList = new LinkedList<IChangeSet>();
                hashMap.put(itemId, linkedList);
            }
            linkedList.add(iChangeSet);
        }
        return hashMap;
    }

    public static List getWorkspaceConnections(ICopyFileAreaView iCopyFileAreaView, boolean bl) throws FileSystemClientException {
        IWorkspaceConnection iWorkspaceConnection;
        IWorkspaceManager iWorkspaceManager;
        IClientConfiguration iClientConfiguration = CommandLineCore.getConfig();
        LinkedList<IWorkspaceConnection> linkedList = new LinkedList<IWorkspaceConnection>();
        Collection collection = iCopyFileAreaView.getLoadedWorkspaces();
        try {
            for (ICopyFileAreaView$IRepoView iCopyFileAreaView$IRepoView : collection) {
                ConnectionInfo connectionInfo = iClientConfiguration.getConnectionInfo(iCopyFileAreaView$IRepoView.getURI());
                ITeamRepository iTeamRepository = RepoUtil.login(iClientConfiguration, connectionInfo);
                iWorkspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository);
                iWorkspaceConnection = iWorkspaceManager.getWorkspaceConnection(iCopyFileAreaView$IRepoView.getHandle(), null);
                linkedList.add(iWorkspaceConnection);
                iWorkspaceConnection.refresh(null);
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_78);
        }
        if (bl) {
            ICopyFileAreaView$IRepoView iCopyFileAreaView$IRepoView;
            iCopyFileAreaView$IRepoView = ResourcesPlugin.getWorkspace().getRoot();
            iWorkspaceManager = iCopyFileAreaView.getLoadedShares();
            int n = ((IShare[])iWorkspaceManager).length;
            int n2 = 0;
            while (n2 < n) {
                IWorkspaceManager iWorkspaceManager2 = iWorkspaceManager[n2];
                iWorkspaceConnection = iCopyFileAreaView$IRepoView.getContainerForLocation(iCopyFileAreaView.getRoot().append(iWorkspaceManager2.getPath()));
                try {
                    iWorkspaceConnection.refreshLocal(2, null);
                }
                catch (CoreException coreException) {
                    throw (Throwable)StatusHelper.failure(Messages.RepoUtil_79, coreException);
                }
                ++n2;
            }
        }
        return linkedList;
    }

    public static IWorkspaceConnection findWorkspaceConnection(IClientConfiguration iClientConfiguration, String string, String string2) throws FileSystemClientException {
        IWorkspaceHandle iWorkspaceHandle;
        if (string == null) {
            return RepoUtil.findWorkspaceConnectionByCFA(iClientConfiguration);
        }
        if (string2 == null) {
            throw (Throwable)StatusHelper.argSyntax(Messages.RepoUtil_119);
        }
        ITeamRepository iTeamRepository = RepoUtil.login(iClientConfiguration, iClientConfiguration.getConnectionInfo(string, CommonOptions.OPT_URI, CommonOptions.OPT_USERNAME, CommonOptions.OPT_PASSWORD));
        try {
            iWorkspaceHandle = RepoUtil.findNamedWorkspace(string2, true, false, iTeamRepository);
        }
        catch (RepoUtil$UnmatchedSelectorException repoUtil$UnmatchedSelectorException) {
            SubcommandUtil.displaySelectorException(repoUtil$UnmatchedSelectorException);
            throw (Throwable)StatusHelper.ambiguousSelector(NLS.bind((String)Messages.RepoUtil_120, (Object)string2));
        }
        catch (RepoUtil$AmbiguousSelectorException repoUtil$AmbiguousSelectorException) {
            SubcommandUtil.displaySelectorException(repoUtil$AmbiguousSelectorException);
            throw (Throwable)StatusHelper.ambiguousSelector(NLS.bind((String)Messages.RepoUtil_121, (Object)string2));
        }
        try {
            return SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).getWorkspaceConnection(iWorkspaceHandle, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, NLS.bind((String)Messages.RepoUtil_122, (Object)string2));
        }
    }

    public static IWorkspaceConnection findWorkspaceConnectionByCFA(IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        ICopyFileAreaView iCopyFileAreaView = SubcommandUtil.getAffectedComponentsAndShares(iClientConfiguration);
        ICopyFileAreaView$IRepoView iCopyFileAreaView$IRepoView = null;
        Collection collection = iCopyFileAreaView.getLoadedWorkspaces();
        if (collection.size() < 1) {
            throw (Throwable)StatusHelper.argSyntax(Messages.RepoUtil_123);
        }
        if (collection.size() > 1) {
            throw (Throwable)StatusHelper.argSyntax(Messages.RepoUtil_124);
        }
        iCopyFileAreaView$IRepoView = (ICopyFileAreaView$IRepoView)iCopyFileAreaView.getLoadedWorkspaces().iterator().next();
        ITeamRepository iTeamRepository = RepoUtil.login(iClientConfiguration, iClientConfiguration.getConnectionInfo(iCopyFileAreaView$IRepoView.getURI()));
        IWorkspaceManager iWorkspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository);
        try {
            return iWorkspaceManager.getWorkspaceConnection(iCopyFileAreaView$IRepoView.getHandle(), null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_125);
        }
    }

    public static IWorkItemHandle findWorkItem(ITeamRepository iTeamRepository, String string) throws FileSystemClientException, RepoUtil$SelectorException {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (n <= 0) {
            return null;
        }
        return RepoUtil.findWorkitem(iTeamRepository, n);
    }

    public static IWorkItemHandle findWorkitem(ITeamRepository iTeamRepository, int n) throws FileSystemClientException, RepoUtil$SelectorException {
        List list;
        Object object = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
        IItemQuery iItemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)object);
        IPredicate iPredicate = object.id()._eq((Number)n);
        iItemQuery.filter(iPredicate);
        try {
            list = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).findItems(iItemQuery, new Object[0]);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_146);
        }
        if (list.size() == 0) {
            throw (Throwable)StatusHelper.ambiguousSelector(NLS.bind((String)Messages.RepoUtil_167, (Object)n));
        }
        if (list.size() > 1) {
            try {
                object = iTeamRepository.itemManager().fetchCompleteItems(list, 0, null);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)StatusHelper.wrap(teamRepositoryException, Messages.RepoUtil_10);
            }
            throw (Throwable)new RepoUtil$AmbiguousSelectorException(RepoUtil$SelectorException$Type.WORKITEM, Integer.toString(n), (List)object, (List)object);
        }
        return (IWorkItemHandle)list.get(0);
    }
}

