/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.util;

import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView$IRepoRunnable;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView$IRepoView;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspaceHandle;
import org.eclipse.osgi.util.NLS;

public class RepoRunnable
implements ICopyFileAreaView$IRepoRunnable {
    private final IClientConfiguration config;
    boolean hadLoginFailure = false;

    public RepoRunnable(IClientConfiguration config) {
        this.config = config;
    }

    public boolean hadLoginFailure() {
        return this.hadLoginFailure;
    }

    public void run(ICopyFileAreaView cfa, ICopyFileAreaView$IRepoView view, IWorkspaceConnection wsConn) throws FileSystemClientException {
    }

    protected ConnectionInfo getConnectionInfo(String uri) throws FileSystemClientException {
        return this.config.getConnectionInfo(uri);
    }

    public IWorkspaceConnection connect(String uri, IWorkspaceHandle wsHandle) throws FileSystemClientException {
        boolean completed = false;
        try {
            ConnectionInfo info = this.getConnectionInfo(uri);
            ITeamRepository repoConn = RepoUtil.login(this.config, info);
            IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repoConn);
            IWorkspaceConnection wsConn = null;
            try {
                wsConn = manager.getWorkspaceConnection(wsHandle, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap(e, NLS.bind((String)Messages.RepoRunnable_0, (Object)info.getURI(), (Object)info.getUsername()));
            }
            completed = true;
            IWorkspaceConnection iWorkspaceConnection = wsConn;
            return iWorkspaceConnection;
        }
        finally {
            if (!completed) {
                this.hadLoginFailure = true;
            }
        }
    }
}

