/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.util;

import com.ibm.team.filesystem.cli.core.CommandLineCore;
import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CompareInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentBaselineSetUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentBaselineUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentFlowUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CopyFileAreaPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.links.common.ILink;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PendingChangesUtil {
    public static void printPendingChanges(PendingChangesOptions options) throws FileSystemClientException {
        PendingChangesUtil.printPendingChanges(false, options);
    }

    public static void printPendingChanges(boolean respectCwd, PendingChangesOptions options) throws FileSystemClientException {
        PendingChangesUtil.printPendingChanges(respectCwd, options, new IndentingPrintStream(System.out));
    }

    public static void printPendingChanges(PendingChangesOptions options, IndentingPrintStream printStream) throws FileSystemClientException {
        PendingChangesUtil.printPendingChanges(false, options, printStream);
    }

    public static void printPendingChanges(boolean respectCwd, PendingChangesOptions options, IndentingPrintStream printStream) throws FileSystemClientException {
        ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares(options.getConfig());
        List workspaces = RepoUtil.getWorkspaceConnections(cfaView, true);
        if (respectCwd) {
            options = options.clone();
            options.enableFilter(1);
            for (ICopyFileAreaView.IRepoView repoView : cfaView.getLoadedWorkspaces()) {
                Collection cpIds = cfaView.getLoadedComponents(repoView);
                for (ItemId cpId : cpIds) {
                    options.addFilter(cpId.getItemUUID(), 1);
                }
            }
        }
        for (IWorkspaceConnection wsConn : workspaces) {
            if (!options.isInFilter((IItemHandle)wsConn.getResolvedWorkspace(), 0)) continue;
            PendingChangesUtil.printWorkspace(wsConn, options, printStream);
        }
    }

    public static void printWorkspace(ITeamRepository repo, IWorkspaceHandle wsHandle, PendingChangesOptions options, IndentingPrintStream printStream) throws FileSystemClientException {
        IWorkspaceConnection wsConn;
        try {
            wsConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(wsHandle, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap(e, Messages.PendingChangesUtil_1);
        }
        PendingChangesUtil.printWorkspace(wsConn, options, printStream);
    }

    public static void printWorkspace(IWorkspaceConnection wsConn, PendingChangesOptions options, IndentingPrintStream printStream) throws FileSystemClientException {
        String message;
        ITeamRepository repo = wsConn.teamRepository();
        IWorkspace collab = null;
        IWorkspaceHandle collabHandle = ComponentFlowUtil.getCurrentCollaboration((IWorkspaceConnection)wsConn);
        if (collabHandle != null) {
            try {
                collab = (IWorkspace)repo.itemManager().fetchCompleteItem((IItemHandle)collabHandle, 0, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap(e, Messages.PendingChangesUtil_98);
            }
        }
        if (collab == null) {
            message = Messages.PendingChangesUtil_2;
            if (options.isPrinterEnabled(13)) {
                message = Messages.PendingChangesUtil_136;
            }
            printStream.println(NLS.bind((String)message, (Object[])new Object[]{AliasUtil.selector(wsConn.getName(), wsConn.getResolvedWorkspace().getItemId()), wsConn.teamRepository().getUserId(), wsConn.teamRepository().getRepositoryURI()}));
        } else {
            message = Messages.PendingChangesUtil_101;
            if (options.isPrinterEnabled(13)) {
                message = Messages.PendingChangesUtil_137;
            }
            printStream.println(NLS.bind((String)message, (Object[])new Object[]{AliasUtil.selector(wsConn.getName(), wsConn.getResolvedWorkspace().getItemId()), AliasUtil.selector(collab.getName(), collab.getItemId()), wsConn.teamRepository().getUserId(), wsConn.teamRepository().getRepositoryURI()}));
        }
        if (options.isPrinterEnabled(1)) {
            LinkedList<CompareInput> inputs = new LinkedList<CompareInput>();
            Collection scopes = null;
            if (collab != null) {
                scopes = wsConn.getFlowTable().getComponentScopes((IFlowNodeHandle)collab);
            }
            if (scopes == null || scopes.isEmpty()) {
                List cpHandles;
                try {
                    cpHandles = wsConn.getComponents();
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap(e, NLS.bind((String)Messages.PendingChangesUtil_23, (Object)wsConn.getName()));
                }
                for (IComponentHandle cpHandle : cpHandles) {
                    inputs.add(new CompareInput((Object)wsConn, (Object)RepoUtil.getCurrentCollaboration(wsConn, cpHandle), Collections.singletonList(cpHandle)));
                }
            } else {
                inputs.add(new CompareInput((Object)wsConn, (Object)collab, new ArrayList(scopes)));
            }
            for (CompareInput input : inputs) {
                IComponentSyncContext[] contexts;
                IComponentSyncModel model;
                try {
                    model = ComponentBaselineSetUtil.create((CompareInput)input, null);
                    model.refresh(true, null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap(e, Messages.PendingChangesUtil_24);
                }
                IComponentSyncContext[] iComponentSyncContextArray = contexts = model.getComponentSyncContexts();
                int n = contexts.length;
                int n2 = 0;
                while (n2 < n) {
                    IComponentSyncContext context = iComponentSyncContextArray[n2];
                    if (options.isInFilter((IItemHandle)context.getComponent(), 1)) {
                        PendingChangesUtil.printComponent(wsConn, context, options, printStream.indent());
                    }
                    ++n2;
                }
            }
        }
    }

    public static void printComponent(IWorkspaceConnection wsConn, IComponentSyncContext cpContext, PendingChangesOptions options, IndentingPrintStream printStream) throws FileSystemClientException {
        Collection conflicts;
        ILogicalConflictReport conflictReport;
        ITeamRepository repo = wsConn.teamRepository();
        IComponent component = cpContext.getComponent();
        String addremComment = "";
        switch (cpContext.getType()) {
            case 3: {
                addremComment = Messages.PendingChangesUtil_131;
                break;
            }
            case 4: {
                addremComment = Messages.PendingChangesUtil_132;
                break;
            }
            case 5: {
                addremComment = Messages.PendingChangesUtil_133;
                break;
            }
            case 6: {
                addremComment = Messages.PendingChangesUtil_134;
            }
        }
        IWorkspaceHandle wsCollab = ComponentFlowUtil.getCurrentCollaboration((IWorkspaceConnection)wsConn);
        IConnection cpCollab = cpContext.getComponentSyncInfo().getRemote();
        if (cpCollab == null || wsCollab == null || cpCollab.getContextHandle().getItemId().equals((Object)wsCollab.getItemId())) {
            printStream.println(NLS.bind((String)Messages.PendingChangesUtil_6, (Object)AliasUtil.selector(component.getName(), component.getItemId()), (Object)addremComment));
        } else {
            printStream.println(NLS.bind((String)Messages.PendingChangesUtil_105, (Object[])new String[]{AliasUtil.selector(component.getName(), component.getItemId()), AliasUtil.selector(cpCollab.getName(), cpCollab.getContextHandle().getItemId()), addremComment}));
        }
        if (options.isPrinterEnabled(11)) {
            IBaseline bl = cpContext.getLocalBaseline();
            printStream.indent().println(NLS.bind((String)Messages.PendingChangesUtil_36, (Object)AliasUtil.selector(bl.getId(), bl.getName(), bl.getItemId())));
        }
        if (options.isPrinterEnabled(2)) {
            ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
            ICopyFileAreaView cfa = SubcommandUtil.getAffectedComponentsAndShares(options.getConfig());
            lcm.syncPendingChanges((IContextHandle)wsConn.getResolvedWorkspace(), (IComponentHandle)component, cfa.getRoot());
            ILocalChange[] localChanges = lcm.getPendingChanges((IContextHandle)wsConn.getResolvedWorkspace(), (IComponentHandle)component, cfa.getRoot());
            if (localChanges.length != 0) {
                printStream.indent().println(Messages.PendingChangesUtil_7);
                ILocalChange[] iLocalChangeArray = localChanges;
                int n = localChanges.length;
                int n2 = 0;
                while (n2 < n) {
                    IVersionableHandle ver;
                    ILocalChange localChange = iLocalChangeArray[n2];
                    IShareable shareable = localChange.getShareable();
                    if (shareable != null && ((ver = shareable.getVersionable()) == null || options.isInFilter((IItemHandle)ver, 2))) {
                        PendingChangesUtil.printUnresolvedChange(localChange, options, printStream.indent().indent());
                    }
                    ++n2;
                }
            }
        }
        if (options.isPrinterEnabled(3) && (conflictReport = cpContext.getLogicalConflictReport()) != null && !(conflicts = conflictReport.getConflictsForComponent((IComponentHandle)component)).isEmpty()) {
            printStream.indent().println(Messages.PendingChangesUtil_69);
            for (ILogicalConflict conflict : conflicts) {
                PendingChangesUtil.printConflict(conflict, printStream.indent().indent());
            }
        }
        if (options.isPrinterEnabled(8)) {
            PendingChangesUtil.printActivitySource(repo, (IActivitySource)cpContext.getOutgoingActivitySource(), Messages.PendingChangesUtil_9, options, printStream);
        }
        if (options.isPrinterEnabled(9)) {
            PendingChangesUtil.printActivitySource(repo, (IActivitySource)cpContext.getIncomingActivitySource(), Messages.PendingChangesUtil_26, options, printStream);
        }
        if (options.isPrinterEnabled(10)) {
            PendingChangesUtil.printActivitySource(repo, (IActivitySource)cpContext.getSuspendedActivitySource(), Messages.PendingChangesUtil_27, options, printStream);
        }
    }

    public static void printBaseline(ITeamRepository repo, IBaselineGroup baseline, PendingChangesOptions options, IndentingPrintStream printStream) throws FileSystemClientException {
        IBaseline bl = baseline.getBaseline();
        printStream.println(AliasUtil.selector(bl.getId(), bl.getName(), bl.getItemId()));
        if (options.isPrinterEnabled(12)) {
            for (IRemoteActivity activity : baseline.getActivities()) {
                PendingChangesUtil.printChangeSet(repo, activity, options, printStream.indent());
            }
        }
    }

    public static void printUnresolvedChange(ILocalChange change, PendingChangesOptions options, IndentingPrintStream printStream) {
        IPath changePath = change.getPath();
        String changeType = PendingChangesUtil.getChangeTypeString(change);
        printStream.println(NLS.bind((String)Messages.PendingChangesUtil_18, (Object)changeType, (Object)changePath));
    }

    public static void printChangeSet(ITeamRepository repo, IChangeSetHandle csHandle, PendingChangesOptions options, IndentingPrintStream printStream) throws FileSystemClientException {
        ChangeSetParts parts = new ChangeSetParts(repo, csHandle, options);
        printStream.println(NLS.bind((String)Messages.PendingChangesUtil_95, (Object[])new String[]{parts.alias, parts.flags, parts.authorName, parts.wiString, parts.csComment}));
        if (options.isPrinterEnabled(6)) {
            List changes = parts.changeSet.changes();
            if (!changes.isEmpty()) {
                printStream.indent().println(Messages.PendingChangesUtil_80);
            }
            for (IChange change : changes) {
                if (!options.isInFilter((IItemHandle)change.item(), 6)) continue;
                PendingChangesUtil.printChange(parts.changeSet.getComponent(), change, options, printStream.indent().indent());
            }
        }
        if (options.isPrinterEnabled(7)) {
            if (!parts.wiHandles.isEmpty()) {
                printStream.indent().println(Messages.PendingChangesUtil_81);
            }
            for (IWorkItemHandle wiHandle : parts.wiHandles) {
                if (!options.isInFilter((IItemHandle)wiHandle, 7)) continue;
                PendingChangesUtil.printWorkItem(repo, wiHandle, options, printStream.indent().indent());
            }
        }
    }

    public static void printChangeSet(ITeamRepository repo, IRemoteActivity activity, PendingChangesOptions options, IndentingPrintStream printStream) throws FileSystemClientException {
        ChangeSetParts parts = new ChangeSetParts(repo, activity, options);
        List changes = activity.getChanges();
        printStream.println(NLS.bind((String)Messages.PendingChangesUtil_95, (Object[])new String[]{parts.alias, parts.flags, parts.authorName, parts.wiString, parts.csComment}));
        if (options.isPrinterEnabled(6)) {
            if (!changes.isEmpty()) {
                printStream.indent().println(Messages.PendingChangesUtil_80);
            }
            for (IRemoteChangeSummary change : changes) {
                if (!options.isInFilter((IItemHandle)change.getItem(), 6)) continue;
                PendingChangesUtil.printChange(change.getChangeSummary().component(), change, options, printStream.indent().indent());
            }
        }
        if (options.isPrinterEnabled(7)) {
            if (!parts.wiHandles.isEmpty()) {
                printStream.indent().println(Messages.PendingChangesUtil_81);
            }
            for (IWorkItemHandle wiHandle : parts.wiHandles) {
                if (!options.isInFilter((IItemHandle)wiHandle, 7)) continue;
                PendingChangesUtil.printWorkItem(repo, wiHandle, options, printStream.indent().indent());
            }
        }
    }

    public static void printChange(IComponentHandle cpHandle, IRemoteChangeSummary changeSummary, PendingChangesOptions options, IndentingPrintStream printStream) throws FileSystemClientException {
        IChange change = changeSummary.getChange();
        String changePath = change.kind() == 16 ? changeSummary.getBeforePath() : changeSummary.getAfterPath();
        String changeType = PendingChangesUtil.getChangeTypeString(changeSummary);
        PendingChangesUtil.printChange(change, changeType, changePath, options, printStream);
    }

    public static void printChange(IComponentHandle cpHandle, IChange change, PendingChangesOptions options, IndentingPrintStream printStream) throws FileSystemClientException {
        Map pathMap;
        SiloedItemId silo = SiloedItemId.create((IVersionableHandle)(change.kind() == 16 ? change.beforeState() : change.afterState()), (IComponentHandle)cpHandle);
        CopyFileAreaPathResolver cfaResolver = CopyFileAreaPathResolver.create();
        try {
            pathMap = cfaResolver.resolve((Collection)Collections.singleton(silo), null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap(e, Messages.PendingChangesUtil_45);
        }
        String changePath = ((VersionablePath)pathMap.get(silo)).toString();
        String changeType = PendingChangesUtil.getChangeTypeString(change);
        PendingChangesUtil.printChange(change, changeType, changePath, options, printStream);
    }

    private static void printChange(IChange change, String changeType, String changePath, PendingChangesOptions options, IndentingPrintStream printStream) {
        String message = options.isPrinterEnabled(14) ? NLS.bind((String)Messages.PendingChangesUtil_143, (Object[])new Object[]{changeType, AliasUtil.alias(change.item().getItemId()), changePath}) : NLS.bind((String)Messages.PendingChangesUtil_18, (Object)changeType, (Object)changePath);
        printStream.println(message);
    }

    public static void printConflict(ILogicalConflict conflict, IndentingPrintStream printStream) {
        printStream.println(NLS.bind((String)Messages.PendingChangesUtil_74, (Object[])new String[]{PendingChangesUtil.getLocalPathFor(conflict.getPathHint()).toString(), PendingChangesUtil.getConflictInformation((ILogicalChange)conflict, true), PendingChangesUtil.getConflictInformation((ILogicalChange)conflict, false)}));
    }

    public static void printWorkItem(ITeamRepository repo, IFileSystemWorkItem fsWorkItem, PendingChangesOptions options, IndentingPrintStream printStream) throws FileSystemClientException {
        PendingChangesUtil.printWorkItem(repo, (IWorkItemHandle)fsWorkItem.getWorkItemHandle(), options, printStream);
    }

    public static void printWorkItem(ITeamRepository repo, IWorkItemHandle wiHandle, PendingChangesOptions options, IndentingPrintStream printStream) throws FileSystemClientException {
        IWorkItem workItem;
        try {
            workItem = (IWorkItem)repo.itemManager().fetchCompleteItem((IItemHandle)wiHandle, 0, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap(e, Messages.PendingChangesUtil_19);
        }
        String wiComment = workItem.getHTMLSummary().getPlainText();
        if (!options.isVerbose()) {
            wiComment = SubcommandUtil.sanitizeText(wiComment, 60, true);
        }
        printStream.println(AliasUtil.selector(workItem.getId(), wiComment, workItem.getItemId()));
    }

    private static String getChangeTypeString(IRemoteChangeSummary change) {
        IChange realChange = change.getChange();
        String type = PendingChangesUtil.getChangeTypeString(realChange);
        type = String.valueOf(change.getActivity().getActivitySource().getModel().hasConflict(change).isEmpty() ? (char)'-' : '#') + type;
        type = String.valueOf(PendingChangesUtil.hasCollision(change) ? (char)'!' : '-') + type;
        return type;
    }

    private static String getChangeTypeString(IChange change) {
        char[] cType = new char[]{'-', '-'};
        if (change.kind() != 0) {
            if (change.kind() == 1) {
                cType[0] = 97;
            } else if (change.kind() == 16) {
                cType[0] = 100;
            } else {
                if ((change.kind() & 0xC) != 0) {
                    cType[0] = 109;
                }
                if ((change.kind() & 2) != 0) {
                    cType[1] = 99;
                }
            }
        }
        return new String(cType);
    }

    private static String getChangeTypeString(ILocalChange change) {
        char[] cType = new char[]{'-', '-'};
        if (change.getType() != 0) {
            if (change.getType() == 2) {
                cType[0] = 97;
            } else if (change.getType() == 4) {
                cType[0] = 100;
            } else {
                if ((change.getType() & 8) != 0) {
                    cType[0] = 109;
                }
                if ((change.getType() & 0x21) != 0) {
                    cType[1] = 99;
                }
            }
        }
        return new String(cType);
    }

    private static boolean hasCollision(IRemoteActivity activity) {
        for (IRemoteChangeSummary change : activity.getChanges()) {
            if (!PendingChangesUtil.hasCollision(change)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCollision(IRemoteChangeSummary change) {
        ILogicalConflictReport conflictReport = change.getActivity().getActivitySource().getModel().getLogicalConflictReport();
        if (conflictReport == null) {
            return false;
        }
        Collection conflicts = conflictReport.conflicts();
        for (ILogicalConflict conflict : conflicts) {
            Collection items = conflict.conflictingItems();
            for (IVersionableHandle ver : items) {
                if (!ver.getItemId().equals((Object)change.getChange().item().getItemId())) continue;
                return true;
            }
        }
        return conflictReport.conflicts().contains(change.getChangeSummary());
    }

    private static List<IWorkItemHandle> getWorkItemsForChangeSet(ITeamRepository repo, IChangeSetHandle csHandle) throws FileSystemClientException {
        List links;
        IChangeSetLinkSummary linkSummary;
        LinkedList<IWorkItemHandle> wiHandles = new LinkedList<IWorkItemHandle>();
        try {
            linkSummary = (IChangeSetLinkSummary)SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getChangeSetLinkSummary((Collection)Collections.singleton(csHandle), null).get(0);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap(e, Messages.PendingChangesUtil_15);
        }
        try {
            links = repo.itemManager().fetchCompleteItems(linkSummary.getLinks(), 0, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap(e, Messages.PendingChangesUtil_16);
        }
        for (ILink link : links) {
            Object obj = link.getTargetRef().resolve();
            if (!(obj instanceof IWorkItemHandle)) continue;
            wiHandles.add((IWorkItemHandle)obj);
        }
        return wiHandles;
    }

    private static String getConflictInformation(ILogicalChange logicalChange, boolean mine) {
        if (logicalChange.kind() == 1) {
            ILogicalConflict conflict = (ILogicalConflict)logicalChange;
            switch (conflict.conflictType()) {
                case 1: {
                    return Messages.PendingChangesUtil_50;
                }
                case 2: {
                    return mine ? Messages.PendingChangesUtil_51 : Messages.PendingChangesUtil_50;
                }
                case 3: {
                    return mine ? Messages.PendingChangesUtil_50 : Messages.PendingChangesUtil_51;
                }
                case 5: {
                    return mine ? Messages.PendingChangesUtil_52 : Messages.PendingChangesUtil_51;
                }
                case 4: {
                    return mine ? Messages.PendingChangesUtil_58 : Messages.PendingChangesUtil_51;
                }
                case 10: {
                    return mine ? Messages.PendingChangesUtil_51 : Messages.PendingChangesUtil_52;
                }
                case 9: {
                    return Messages.PendingChangesUtil_52;
                }
                case 7: {
                    return mine ? Messages.PendingChangesUtil_50 : Messages.PendingChangesUtil_58;
                }
                case 8: {
                    return mine ? Messages.PendingChangesUtil_51 : Messages.PendingChangesUtil_58;
                }
                case 6: {
                    return Messages.PendingChangesUtil_58;
                }
            }
            return Messages.PendingChangesUtil_59;
        }
        if (logicalChange.kind() == 2) {
            if (logicalChange.isChangeType(1)) {
                return mine ? Messages.PendingChangesUtil_52 : Messages.PendingChangesUtil_50;
            }
            if (logicalChange.isChangeType(2)) {
                return mine ? Messages.PendingChangesUtil_52 : Messages.PendingChangesUtil_51;
            }
            if (logicalChange.isChangeType(12)) {
                return mine ? Messages.PendingChangesUtil_52 : Messages.PendingChangesUtil_60;
            }
            if (logicalChange.isChangeType(4)) {
                return Messages.PendingChangesUtil_52;
            }
            if (logicalChange.isChangeType(8)) {
                return mine ? Messages.PendingChangesUtil_52 : Messages.PendingChangesUtil_58;
            }
            if (logicalChange.isChangeType(16)) {
                return Messages.PendingChangesUtil_61;
            }
            return mine ? Messages.PendingChangesUtil_52 : Messages.PendingChangesUtil_62;
        }
        if (logicalChange.kind() == 3) {
            if (logicalChange.isChangeType(1)) {
                return mine ? Messages.PendingChangesUtil_63 : Messages.PendingChangesUtil_50;
            }
            if (logicalChange.isChangeType(2)) {
                return mine ? Messages.PendingChangesUtil_64 : Messages.PendingChangesUtil_51;
            }
            if (logicalChange.isChangeType(12)) {
                return mine ? Messages.PendingChangesUtil_64 : Messages.PendingChangesUtil_60;
            }
            if (logicalChange.isChangeType(4)) {
                return mine ? Messages.PendingChangesUtil_64 : Messages.PendingChangesUtil_52;
            }
            if (logicalChange.isChangeType(8)) {
                return mine ? Messages.PendingChangesUtil_64 : Messages.PendingChangesUtil_58;
            }
            if (logicalChange.isChangeType(16)) {
                return mine ? Messages.PendingChangesUtil_64 : Messages.PendingChangesUtil_65;
            }
            return mine ? Messages.PendingChangesUtil_64 : Messages.PendingChangesUtil_62;
        }
        return Messages.PendingChangesUtil_59;
    }

    private static IPath getLocalPathFor(String[] path) {
        if (path == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < path.length) {
            if (i != 0) {
                buffer.append('/');
            }
            buffer.append(path[i]);
            ++i;
        }
        return new Path(buffer.toString());
    }

    private static void printActivitySource(ITeamRepository repo, IActivitySource source, String title, PendingChangesOptions options, IndentingPrintStream printStream) throws FileSystemClientException {
        LinkedList<IRemoteActivity> activities = new LinkedList<IRemoteActivity>();
        if (options.isPrinterEnabled(4)) {
            for (IRemoteActivity activity : source.getActivities()) {
                IChangeSetHandle csHandle = activity.getChangeSetHandle();
                if (!options.isInFilter((IItemHandle)csHandle, 4)) continue;
                activities.add(activity);
            }
        }
        LinkedList<IBaselineGroup> baselines = new LinkedList<IBaselineGroup>();
        if (options.isPrinterEnabled(5)) {
            for (IBaselineGroup baseline : source.getBaselines()) {
                IBaseline blHandle = baseline.getBaseline();
                if (!options.isInFilter((IItemHandle)blHandle, 5)) continue;
                baselines.add(baseline);
            }
        }
        if (!activities.isEmpty() || !baselines.isEmpty()) {
            printStream.indent().println(title);
        }
        if (!activities.isEmpty()) {
            printStream.indent().indent().println(Messages.PendingChangesUtil_49);
            for (IRemoteActivity activity : activities) {
                PendingChangesUtil.printChangeSet(repo, activity, options, printStream.indent().indent().indent());
            }
        }
        if (!baselines.isEmpty()) {
            printStream.indent().indent().println(Messages.PendingChangesUtil_116);
            for (IBaselineGroup baseline : baselines) {
                ComponentBaselineUtil.syncResolve((IBaselineGroup)baseline);
            }
            try {
                source.getModel().refresh(true, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap(e, Messages.PendingChangesUtil_127);
            }
            for (IBaselineGroup baseline : baselines) {
                PendingChangesUtil.printBaseline(repo, baseline, options, printStream.indent().indent().indent());
            }
        }
    }

    private static class ChangeSetParts {
        public String authorName;
        public String alias;
        public String wiString;
        public String flags;
        public List<IWorkItemHandle> wiHandles;
        public String csComment;
        public IChangeSet changeSet;

        public ChangeSetParts(ITeamRepository repo, IChangeSetHandle csHandle, PendingChangesOptions options) throws FileSystemClientException {
            IContributor author;
            try {
                this.changeSet = (IChangeSet)repo.itemManager().fetchCompleteItem((IItemHandle)csHandle, 0, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap(e, Messages.PendingChangesUtil_12);
            }
            this.wiHandles = PendingChangesUtil.getWorkItemsForChangeSet(repo, csHandle);
            this.alias = AliasUtil.alias(csHandle.getItemId());
            this.alias = this.alias == null ? "" : NLS.bind((String)Messages.PendingChangesUtil_85, (Object)this.alias);
            try {
                author = (IContributor)repo.itemManager().fetchCompleteItem((IItemHandle)this.changeSet.getAuthor(), 0, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap(e, Messages.PendingChangesUtil_12);
            }
            if (author.getItemId().equals((Object)repo.loggedInContributor().getItemId())) {
                this.authorName = "";
            } else {
                this.authorName = options.isVerbose() ? author.getUserId() : author.getName();
                this.authorName = NLS.bind((String)Messages.PendingChangesUtil_86, (Object)this.authorName);
            }
            this.wiString = "";
            if (!this.wiHandles.isEmpty()) {
                IWorkItem workItem;
                try {
                    workItem = (IWorkItem)repo.itemManager().fetchCompleteItem((IItemHandle)this.wiHandles.get(0), 0, null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap(e, Messages.PendingChangesUtil_19);
                }
                String wiComment = workItem.getHTMLSummary().getPlainText();
                if (!options.isVerbose()) {
                    wiComment = SubcommandUtil.sanitizeText(wiComment, 60, true);
                }
                this.wiString = NLS.bind((String)Messages.PendingChangesUtil_90, (Object)workItem.getId(), (Object)wiComment);
            }
            this.csComment = this.changeSet.getComment();
            if (this.csComment.length() == 0) {
                this.csComment = Messages.PendingChangesUtil_13;
            } else if (!options.isVerbose()) {
                this.csComment = NLS.bind((String)Messages.PendingChangesUtil_38, (Object)SubcommandUtil.sanitizeText(this.csComment, 60, true));
            }
            this.flags = this.changeSet.isActive() ? "@" : "$";
        }

        public ChangeSetParts(ITeamRepository repo, IRemoteActivity activity, PendingChangesOptions options) throws FileSystemClientException {
            this(repo, activity.getChangeSetHandle(), options);
            this.flags = String.valueOf(PendingChangesUtil.hasCollision(activity) ? "!" : "-") + (activity.getActivitySource().getModel().hasConflict(activity) ? "#" : "-") + this.flags;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PendingChangesOptions
    implements Cloneable {
        public static final int WORKSPACE = 0;
        public static final int COMPONENT = 1;
        public static final int UNRESOLVED_CHANGE = 2;
        public static final int CONFLICT = 3;
        public static final int CHANGESET = 4;
        public static final int BASELINE = 5;
        public static final int CHANGE = 6;
        public static final int WORK_ITEM = 7;
        public static final int OUTGOING_CHANGES = 8;
        public static final int INCOMING_CHANGES = 9;
        public static final int SUSPENDED_CHANGES = 10;
        public static final int COMPONENT_BASELINE = 11;
        public static final int BASELINE_EXPAND = 12;
        public static final int WORKSPACE_URL = 13;
        public static final int VERSIONABLE_SELECTOR = 14;
        private boolean verbose = false;
        private IClientConfiguration config;
        private Set<Integer> enabledPrinters;
        private Set<Integer> enabledFilters;
        private Map<Integer, Set<UUID>> filters;

        public PendingChangesOptions() {
            this.config = CommandLineCore.getConfig();
            this.enabledPrinters = new HashSet<Integer>();
            this.enabledFilters = new HashSet<Integer>();
            this.filters = new HashMap<Integer, Set<UUID>>();
        }

        public PendingChangesOptions(PendingChangesOptions options) {
            this.config = options.config;
            this.verbose = options.verbose;
            this.enabledPrinters = new HashSet<Integer>(options.enabledPrinters);
            this.enabledFilters = new HashSet<Integer>(options.enabledFilters);
            this.filters = new HashMap<Integer, Set<UUID>>();
            for (Map.Entry<Integer, Set<UUID>> entry : options.filters.entrySet()) {
                this.filters.put(entry.getKey(), new HashSet(entry.getValue()));
            }
        }

        public boolean isVerbose() {
            return this.verbose;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public IClientConfiguration getConfig() {
            return this.config;
        }

        public void enablePrinter(int type) {
            this.enabledPrinters.add(type);
        }

        public void disablePrinter(int type) {
            this.enabledPrinters.remove(type);
        }

        public boolean isPrinterEnabled(int type) {
            return this.enabledPrinters.contains(type);
        }

        public void enableFilter(int type) {
            this.enabledFilters.add(type);
        }

        public void disableFilter(int type) {
            this.enabledFilters.remove(type);
        }

        public boolean isFilterEnabled(int type) {
            return this.enabledFilters.contains(type);
        }

        public void addFilter(IItemHandle handle, int type) {
            this.addFilter(handle.getItemId(), type);
        }

        public void addFilter(UUID uuid, int type) {
            Set<UUID> uuids = this.filters.get(type);
            if (uuids == null) {
                uuids = new HashSet<UUID>();
                this.filters.put(type, uuids);
            }
            uuids.add(uuid);
        }

        public void addFilters(Collection<? extends IItemHandle> handles, int type) {
            for (IItemHandle iItemHandle : handles) {
                this.addFilter(iItemHandle, type);
            }
        }

        public boolean isInFilter(IItemHandle handle, int type) {
            return this.isInFilter(handle.getItemId(), type);
        }

        public boolean isInFilter(UUID uuid, int type) {
            if (!this.isFilterEnabled(type)) {
                return true;
            }
            Set<UUID> uuids = this.filters.get(type);
            if (uuids == null) {
                return false;
            }
            return uuids.contains(uuid);
        }

        public PendingChangesOptions clone() {
            return new PendingChangesOptions(this);
        }
    }
}

