/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.util;

import java.io.IOException;
import java.io.OutputStream;

public class IndentingPrintStream {
    final OutputStream stream;
    final String newline = System.getProperty("line.separator");
    Exception exception = null;
    final int indent;

    public IndentingPrintStream(OutputStream outputStream) {
        this.stream = outputStream;
        this.indent = 0;
    }

    public IndentingPrintStream(OutputStream outputStream, int n) {
        this.stream = outputStream;
        this.indent = n;
    }

    public void println(CharSequence charSequence) {
        try {
            this.stream.write(this.createString(charSequence).append(this.newline).toString().getBytes());
            this.stream.flush();
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void printIndent() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.indent) {
            stringBuffer.append(" ");
            ++n;
        }
        this.print(stringBuffer);
    }

    public void print(CharSequence charSequence) {
        try {
            this.stream.write(charSequence.toString().getBytes());
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void println() {
        try {
            this.stream.write(this.newline.getBytes());
            this.stream.flush();
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public IndentingPrintStream indent() {
        return new IndentingPrintStream(this.stream, this.indent + 2);
    }

    protected StringBuffer createString(CharSequence charSequence) {
        StringBuffer stringBuffer = new StringBuffer(this.indent + charSequence.length());
        int n = 0;
        while (n < this.indent) {
            stringBuffer.append(" ");
            ++n;
        }
        stringBuffer.append(charSequence);
        return stringBuffer;
    }
}

