/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.internal.subcommands;

import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.INamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.NamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.PositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.SubcommandLoader;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommand;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition$LoadOptionsException;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class HelpCmd
implements ISubcommand,
IOptionSource {
    public static final String NO_HELP_STRING = Messages.HelpCmd_0;
    public static PositionalOptionDefinition OPT_SUBCOMMAND_NAME = new PositionalOptionDefinition("subcmd", 0, -1);
    public static NamedOptionDefinition OPT_ALL = new NamedOptionDefinition(null, "all", 0);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        options.setLongHelp(Messages.HelpCmd_1);
        options.addOption(OPT_SUBCOMMAND_NAME, Messages.HelpCmd_2).addOption(OPT_ALL, Messages.HelpCmd_3);
        return options;
    }

    public void run(IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        ICommandLine iCommandLine = iClientConfiguration.getSubcommandCommandLine();
        if (iCommandLine != null && iCommandLine.hasOption(OPT_ALL)) {
            this.showAllSubcommands(iClientConfiguration);
        } else if (iCommandLine == null || !iCommandLine.hasOption(OPT_SUBCOMMAND_NAME)) {
            this.showSubcommandListing(iClientConfiguration);
        } else {
            this.showSubCommand(iCommandLine.getOptions(OPT_SUBCOMMAND_NAME), iClientConfiguration);
        }
    }

    private void showSubcommandListing(IClientConfiguration iClientConfiguration) {
        Options options = iClientConfiguration.getCommandLine().getDefinition();
        System.out.print(Messages.HelpCmd_4);
        this.showUsage(options);
        System.out.println();
        Collection collection = iClientConfiguration.getSubcommandDefinitions();
        IndentingPrintStream indentingPrintStream = new IndentingPrintStream(System.out);
        indentingPrintStream.println(Messages.HelpCmd_5);
        indentingPrintStream = indentingPrintStream.indent();
        for (ISubcommandDefinition iSubcommandDefinition : collection) {
            if (!iSubcommandDefinition.showInHelpListing() || iSubcommandDefinition.getParentId() != null) continue;
            indentingPrintStream.println(NLS.bind((String)Messages.HelpCmd_6, (Object)iSubcommandDefinition.getFullSubcommandName(), (Object)iSubcommandDefinition.getShortHelp()));
            if (!iSubcommandDefinition.isParent()) continue;
            IndentingPrintStream indentingPrintStream2 = indentingPrintStream.indent();
            StringBuffer stringBuffer = new StringBuffer();
            for (ISubcommandDefinition iSubcommandDefinition2 : iSubcommandDefinition.getChildren()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(Messages.HelpCmd_7);
                }
                stringBuffer.append(iSubcommandDefinition2.getFullSubcommandName());
            }
            indentingPrintStream2.println(String.valueOf(Messages.HelpCmd_8) + stringBuffer);
        }
    }

    private void showUsage(Options options) {
        Object object2;
        IndentingPrintStream indentingPrintStream = new IndentingPrintStream(System.out);
        if (options.getNamedOptions().size() > 0) {
            indentingPrintStream.print(Messages.HelpCmd_29);
        }
        for (Object object2 : options.getPositionalOptions()) {
            boolean bl;
            boolean bl2 = bl = object2.getMinCount() > 0;
            if (bl) {
                indentingPrintStream.print("<");
            } else {
                indentingPrintStream.print("[");
            }
            indentingPrintStream.print(object2.getName());
            if (object2.getMaxCount() == -1) {
                indentingPrintStream.print("...");
            }
            if (bl) {
                indentingPrintStream.print(">");
            } else {
                indentingPrintStream.print("]");
            }
            indentingPrintStream.print(" ");
        }
        indentingPrintStream.println();
        object2 = indentingPrintStream.indent();
        int n = 0;
        for (IPositionalOptionDefinition iPositionalOptionDefinition : options.getPositionalOptions()) {
            n = Math.max(n, iPositionalOptionDefinition.getName().length());
        }
        for (IPositionalOptionDefinition iPositionalOptionDefinition : options.getPositionalOptions()) {
            ((IndentingPrintStream)object2).println(StringUtil.pad(iPositionalOptionDefinition.getName(), n) + NLS.bind((String)Messages.HelpCmd_30, (Object)options.getHelpFor(iPositionalOptionDefinition.getId())));
        }
        if (options.getNamedOptions().size() > 0) {
            indentingPrintStream.println();
            indentingPrintStream.print(Messages.HelpCmd_31);
            indentingPrintStream.println();
        }
        indentingPrintStream = indentingPrintStream.indent();
        object2 = new HashMap<INamedOptionDefinition, StringBuffer>();
        n = 0;
        for (INamedOptionDefinition iNamedOptionDefinition : options.getNamedOptions()) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if (iNamedOptionDefinition.getShortOpt() != null) {
                stringBuffer.append("-" + iNamedOptionDefinition.getShortOpt());
                bl = true;
            }
            if (iNamedOptionDefinition.getLongOpt() != null) {
                if (bl) {
                    stringBuffer.append(" ");
                }
                if (bl) {
                    stringBuffer.append("[");
                }
                stringBuffer.append("--" + iNamedOptionDefinition.getLongOpt());
                if (bl) {
                    stringBuffer.append("]");
                }
            }
            if (iNamedOptionDefinition.getArgCount() == -1) {
                stringBuffer.append(" ...");
            } else {
                int n2 = iNamedOptionDefinition.getArgCount();
                while (n2 > 0) {
                    stringBuffer.append(Messages.HelpCmd_32);
                    --n2;
                }
            }
            ((HashMap)object2).put(iNamedOptionDefinition, stringBuffer);
            n = Math.max(n, stringBuffer.length());
        }
        n += 2;
        for (INamedOptionDefinition iNamedOptionDefinition : options.getNamedOptions()) {
            indentingPrintStream.printIndent();
            indentingPrintStream.print(StringUtil.pad((CharSequence)((HashMap)object2).get(iNamedOptionDefinition), n));
            indentingPrintStream.print(Messages.HelpCmd_33);
            indentingPrintStream.print(options.getHelpFor(iNamedOptionDefinition.getId()));
            indentingPrintStream.println();
        }
    }

    private void showAllSubcommands(IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        Collection collection = iClientConfiguration.getSubcommandDefinitions();
        LinkedList<FileSystemClientException> linkedList = new LinkedList<FileSystemClientException>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (ISubcommandDefinition iSubcommandDefinition : collection) {
            if (!iSubcommandDefinition.showInHelpListing()) continue;
            if (!bl) {
                System.out.println();
                System.out.println();
            }
            bl = false;
            try {
                this.showSubcommand(iClientConfiguration, Collections.singletonList(iSubcommandDefinition.getFullSubcommandName()), iSubcommandDefinition);
            }
            catch (FileSystemClientException fileSystemClientException) {
                System.err.println(NLS.bind((String)Messages.HelpCmd_9, (Object)iSubcommandDefinition.getFullSubcommandName()));
                linkedList.add(fileSystemClientException);
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(Messages.HelpCmd_10);
                }
                stringBuffer.append(iSubcommandDefinition.getFullSubcommandName());
            }
        }
        if (linkedList.size() > 0) {
            throw (Throwable)StatusHelper.internalError(NLS.bind((String)Messages.HelpCmd_11, (Object)stringBuffer.toString()), linkedList);
        }
    }

    private void showSubCommand(List list, IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        String string = (String)list.get(0);
        ISubcommandDefinition iSubcommandDefinition = SubcommandLoader.getInstance().loadToplevel(string);
        if (iSubcommandDefinition == null) {
            throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.HelpCmd_12, (Object)string));
        }
        if (iSubcommandDefinition.getParentId() != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (ISubcommandDefinition iSubcommandDefinition2 : iSubcommandDefinition.getAncestors()) {
                stringBuffer.append(iSubcommandDefinition2.getFullSubcommandName());
                stringBuffer.append(Messages.HelpCmd_13);
            }
            stringBuffer.append(string);
            throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.HelpCmd_14, (Object)string, (Object)stringBuffer));
        }
        ISubcommandDefinition iSubcommandDefinition3 = iSubcommandDefinition;
        int n = 1;
        while (n < list.size()) {
            try {
                iSubcommandDefinition3 = iSubcommandDefinition.getChild((String)list.get(n));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.HelpCmd_15, list.get(n)));
            }
            ++n;
        }
        this.showSubcommand(iClientConfiguration, list, iSubcommandDefinition3);
    }

    private void showSubcommand(IClientConfiguration iClientConfiguration, List list, ISubcommandDefinition iSubcommandDefinition) throws FileSystemClientException {
        Object object;
        Object object2;
        String[] stringArray;
        Options options;
        String string = (String)list.get(list.size() - 1);
        try {
            options = iSubcommandDefinition.getOptions();
        }
        catch (ISubcommandDefinition$LoadOptionsException iSubcommandDefinition$LoadOptionsException) {
            throw (Throwable)StatusHelper.failure(NLS.bind((String)Messages.HelpCmd_16, (Object)string, (Object)iSubcommandDefinition$LoadOptionsException.getCause().getMessage()), iSubcommandDefinition$LoadOptionsException);
        }
        catch (ConflictingOptionException conflictingOptionException) {
            throw (Throwable)StatusHelper.failure(NLS.bind((String)Messages.HelpCmd_17, (Object)string, (Object)conflictingOptionException.getMessage()), conflictingOptionException);
        }
        Object object3 = iSubcommandDefinition.getAncestors();
        System.out.print(Messages.HelpCmd_19);
        Object object4 = object3.iterator();
        while (object4.hasNext()) {
            stringArray = (String[])object4.next();
            System.out.print(String.valueOf(stringArray.getFullSubcommandName()) + Messages.HelpCmd_20);
        }
        System.out.print(iSubcommandDefinition.getFullSubcommandName());
        System.out.println();
        object3 = options.getLongHelp();
        if (object3 == null) {
            System.out.println(NO_HELP_STRING);
        } else {
            System.out.println((String)object3);
        }
        System.out.println();
        stringArray = iSubcommandDefinition.getAliases();
        if (stringArray.length > 0) {
            System.out.print(Messages.HelpCmd_21);
            boolean bl = false;
            object2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = object2[n2];
                if (bl) {
                    System.out.print(Messages.HelpCmd_22);
                }
                bl = true;
                System.out.print((String)object);
                ++n2;
            }
            System.out.println();
            System.out.println();
        }
        System.out.print(Messages.HelpCmd_23);
        object4 = iSubcommandDefinition.getAncestors();
        object4.add(iSubcommandDefinition);
        Iterator iterator = object4.iterator();
        while (iterator.hasNext()) {
            object = (ISubcommandDefinition)iterator.next();
            System.out.print(String.valueOf(object.getFullSubcommandName()) + Messages.HelpCmd_24);
        }
        if (iSubcommandDefinition.isParent()) {
            object = iSubcommandDefinition.getChildren();
            System.out.print('<');
            boolean bl = false;
            object2 = object.iterator();
            while (object2.hasNext()) {
                ISubcommandDefinition iSubcommandDefinition2 = (ISubcommandDefinition)object2.next();
                if (bl) {
                    System.out.print('|');
                }
                bl = true;
                System.out.print(iSubcommandDefinition2.getFullSubcommandName());
            }
            System.out.println(Messages.HelpCmd_25);
            System.out.println(Messages.HelpCmd_26);
            IndentingPrintStream indentingPrintStream = new IndentingPrintStream(System.out).indent();
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                object2 = (ISubcommandDefinition)iterator2.next();
                indentingPrintStream.println(NLS.bind((String)Messages.HelpCmd_27, (Object)object2.getFullSubcommandName(), (Object)object2.getShortHelp()));
            }
            System.out.println(NLS.bind((String)Messages.HelpCmd_28, (Object)iSubcommandDefinition.getFullSubcommandName()));
        } else {
            this.showUsage(options);
        }
    }
}

