/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.internal.aliases;

import com.ibm.team.filesystem.cli.core.internal.aliases.UuidAlias;
import com.ibm.team.filesystem.cli.core.internal.aliases.UuidAliasRegistry;
import com.ibm.team.repository.common.UUID;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;

public class AliasLoader {
    private static String ENCODING = "UTF-8";
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static String LAST_ALLOCATED_LINE = "lastAllocated={0}" + LINE_SEPARATOR;
    private static Pattern LAST_ALLOCATED_REGEX = Pattern.compile("lastAllocated\\s*=\\s*(\\d+)");
    private static String LAST_RUN_LINE = "lastRun={0}" + LINE_SEPARATOR;
    private static Pattern LAST_RUN_REGEX = Pattern.compile("lastRun\\s*=\\s*(\\d+)");
    static final byte[] VERSION_PREAMBLE = "### Jazz UUID Aliases ".getBytes();

    public static void load(UuidAliasRegistry uuidAliasRegistry, File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        try {
            String string;
            boolean bl = false;
            boolean bl2 = false;
            while ((string = bufferedReader.readLine()) != null) {
                long l;
                if ((string = string.trim()).length() == 0 || string.startsWith("#")) continue;
                if (!bl && -1L != (l = AliasLoader.readNumber(string, LAST_ALLOCATED_REGEX))) {
                    uuidAliasRegistry.setLastAllocated(l);
                    bl = true;
                    continue;
                }
                if (!bl2 && -1L != (l = AliasLoader.readNumber(string, LAST_RUN_REGEX))) {
                    uuidAliasRegistry.setLastRun(l);
                    bl2 = true;
                    continue;
                }
                AliasLoader.parseLine(string, uuidAliasRegistry);
            }
        }
        finally {
            bufferedReader.close();
        }
    }

    private static long readNumber(String string, Pattern pattern) {
        block3: {
            String string2;
            Matcher matcher = pattern.matcher(string.trim());
            if (matcher.matches() && (string2 = matcher.group(1)) != null) {
                try {
                    return Long.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!AliasLoader.class.getClass().desiredAssertionStatus()) break block3;
                    numberFormatException.printStackTrace();
                }
            }
        }
        return -1L;
    }

    private static void parseLine(String string, UuidAliasRegistry uuidAliasRegistry) {
        String[] stringArray = (string = string.trim()).split("\\s+");
        if (stringArray.length != 3) {
            return;
        }
        uuidAliasRegistry.createAliasFor(UUID.valueOf((String)stringArray[0]), stringArray[1], Long.valueOf(stringArray[2]));
    }

    public static void save(Enumeration enumeration, long l, long l2, File file) throws IOException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            Object object = new FileOutputStream(file);
            ((OutputStream)object).write(VERSION_PREAMBLE);
            ((OutputStream)object).write(49);
            ((OutputStream)object).write(LINE_SEPARATOR.getBytes());
            CharSequence charSequence = NLS.bind((String)LAST_ALLOCATED_LINE, (Object)l);
            ((OutputStream)object).write(((String)charSequence).getBytes(ENCODING));
            charSequence = NLS.bind((String)LAST_RUN_LINE, (Object)l2);
            ((OutputStream)object).write(((String)charSequence).getBytes(ENCODING));
            outputStreamWriter = new OutputStreamWriter((OutputStream)object, ENCODING);
            while (enumeration.hasMoreElements()) {
                object = (UuidAlias)enumeration.nextElement();
                charSequence = new StringBuffer(24 + UuidAliasRegistry.WIDTH + 2 + 4 + LINE_SEPARATOR.length() + 8);
                ((StringBuffer)charSequence).append(((UuidAlias)object).uuid.getUuidValue());
                ((StringBuffer)charSequence).append(" ");
                ((StringBuffer)charSequence).append(((UuidAlias)object).getMonicker());
                ((StringBuffer)charSequence).append(" ");
                ((StringBuffer)charSequence).append(((UuidAlias)object).getLastRun());
                ((StringBuffer)charSequence).append(LINE_SEPARATOR);
                outputStreamWriter.write(((StringBuffer)charSequence).toString());
            }
        }
        catch (Throwable throwable) {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (outputStreamWriter != null) {
                outputStreamWriter.close();
            }
        }
        catch (IOException iOException) {}
    }
}

