/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.internal;

import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.SubcommandDefinition$$Cold;
import com.ibm.team.filesystem.cli.core.internal.SubcommandDefinition$PathPair;
import com.ibm.team.filesystem.cli.core.internal.SubcommandDefinition$Policy;
import com.ibm.team.filesystem.cli.core.internal.SubcommandLoader;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommand;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition$LoadOptionsException;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition$LoadSubcommandException;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;

class SubcommandDefinition
implements ISubcommandDefinition {
    IConfigurationElement ext;
    private String name = null;
    private String shortHelp = null;

    public SubcommandDefinition(IConfigurationElement iConfigurationElement) {
        this.ext = iConfigurationElement;
    }

    private String getAttr(String string) {
        return this.getAttr(string, true);
    }

    private String getAttr(String string, boolean bl) {
        String string2 = this.ext.getAttribute(string);
        if (bl && string2 == null) {
            System.err.println(NLS.bind((String)Messages.SubcommandDefinition_0, (Object)string));
        }
        return string2;
    }

    public String getFullSubcommandName() {
        if (this.name == null) {
            this.name = this.getAttr("name");
        }
        return this.name;
    }

    public String getShortHelp() {
        if (this.shortHelp == null) {
            this.shortHelp = this.getAttr("shortHelp");
        }
        return this.shortHelp;
    }

    public String getLongHelp() {
        return this.ext.getAttribute("longHelp");
    }

    public String getOptionsClass() {
        return this.ext.getAttribute("options");
    }

    public Options getOptions() throws ISubcommandDefinition$LoadOptionsException, ConflictingOptionException {
        Object object;
        Options options = null;
        boolean bl = true;
        if (this.getOptionsClass() == null) {
            options = new Options(false);
        } else {
            try {
                object = (IOptionSource)this.ext.createExecutableExtension("options");
            }
            catch (CoreException coreException) {
                throw (Throwable)new ISubcommandDefinition$LoadOptionsException(this.name, coreException);
            }
            options = object.getOptions();
            bl = false;
        }
        object = this.getLongHelp();
        if (!$assertionsDisabled && bl && object == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Extension point for subcommand \"" + this.getId() + "\" does not set options class or long help.")));
        }
        if (object != null) {
            options.setLongHelp((String)object);
        }
        return options;
    }

    protected SubcommandDefinition$Policy getInitPolicy() throws FileSystemClientException {
        String string = this.getAttr("initpolicy");
        if ("none".equals(string)) {
            return SubcommandDefinition$Policy.NONE;
        }
        if ("ancestor".equals(string)) {
            return SubcommandDefinition$Policy.ANCESTOR;
        }
        if ("argument".equals(string)) {
            return SubcommandDefinition$Policy.ARGUMENT;
        }
        if ("argument/ancestor".equals(string)) {
            return SubcommandDefinition$Policy.ARG_ANC;
        }
        if ("uri/argument/ancestor".equals(string)) {
            return SubcommandDefinition$Policy.URI_ARG_ANC;
        }
        if ("scratch".equals(string)) {
            return SubcommandDefinition$Policy.SCRATCH;
        }
        if ("argument-create".equals(string)) {
            return SubcommandDefinition$Policy.ARGUMENT_CREATE;
        }
        throw (Throwable)StatusHelper.internalError(NLS.bind((String)Messages.SubcommandDefinition_1, (Object[])new Object[]{this.getFullSubcommandName(), this.ext.getContributor().getName(), string}));
    }

    public SubcommandDefinition$PathPair initialize(ICommandLine iCommandLine) throws FileSystemClientException {
        SubcommandDefinition$Policy subcommandDefinition$Policy = this.getInitPolicy();
        String string = iCommandLine.getOption(CommonOptions.OPT_DIRECTORY, null);
        String string2 = iCommandLine.getOption(CommonOptions.OPT_URI, null);
        File file = null;
        File file2 = null;
        switch (subcommandDefinition$Policy) {
            case NONE: {
                return new SubcommandDefinition$PathPair(null, null, null);
            }
            case ANCESTOR: {
                String string3 = System.getProperty("user.dir");
                file = SubcommandUtil.findAncestorCFARoot(string3);
                if (file == null) {
                    throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.SubcommandDefinition_2, (Object)string3));
                }
                file2 = SubcommandUtil.canonicalize(new File(System.getProperty("user.dir")));
                break;
            }
            case ARGUMENT: 
            case ARGUMENT_CREATE: {
                if (string == null) {
                    this.verifyArg(iCommandLine);
                    throw (Throwable)StatusHelper.argSyntax(Messages.SubcommandDefinition_3);
                }
                file2 = file = SubcommandUtil.canonicalize(new File(string));
                if (subcommandDefinition$Policy == SubcommandDefinition$Policy.ARGUMENT_CREATE) {
                    File file3 = SubcommandUtil.findAncestorCFARoot(file.getAbsolutePath());
                    if (file3 == null) {
                        if (file.exists() || file.mkdirs()) break;
                        throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.SubcommandDefinition_4, (Object)file.getAbsolutePath()));
                    }
                    if (file.equals(file3)) break;
                    throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.SubcommandDefinition_5, (Object)file3.getAbsolutePath()));
                }
                if (file.exists()) break;
                throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.SubcommandDefinition_6, (Object)string));
            }
            case URI_ARG_ANC: 
            case ARG_ANC: {
                if (string == null) {
                    file = SubcommandUtil.findAncestorCFARoot(System.getProperty("user.dir"));
                    if (file == null) {
                        if (string2 != null) {
                            file2 = file = SubcommandUtil.getScratchCFA(null);
                            break;
                        }
                        this.verifyArg(iCommandLine);
                        throw (Throwable)StatusHelper.misconfiguredLocalFS(Messages.SubcommandDefinition_7);
                    }
                    file2 = SubcommandUtil.canonicalize(new File(System.getProperty("user.dir")));
                    break;
                }
                file = SubcommandUtil.findNamedAncestorCFARoot(string);
                file2 = SubcommandUtil.canonicalize(new File(string));
                if (file2.exists()) break;
                throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.SubcommandDefinition_8, (Object)file2.getAbsolutePath()));
            }
            case SCRATCH: {
                file2 = file = SubcommandUtil.getScratchCFA(null);
            }
        }
        Assert.isNotNull(file);
        SubcommandUtil.initializeEclipseWorkspaceRoot(file);
        return new SubcommandDefinition$PathPair(file, file2, null);
    }

    public ISubcommand loadSubcommand() throws ISubcommandDefinition$LoadSubcommandException {
        block3: {
            try {
                if (this.getSubcommandName() != null) break block3;
                return null;
            }
            catch (CoreException coreException) {
                throw (Throwable)new ISubcommandDefinition$LoadSubcommandException(this.name, coreException);
            }
        }
        return (ISubcommand)this.ext.createExecutableExtension("class");
    }

    public String getSubcommandName() {
        return this.ext.getAttribute("class");
    }

    public String getModuleName() {
        return this.ext.getContributor().getName();
    }

    public String getId() {
        return this.getAttr("id", false);
    }

    public String getParentId() {
        return this.getAttr("parent", false);
    }

    public ISubcommandDefinition getParent() {
        String string = this.getParentId();
        if (string == null) {
            return null;
        }
        Collection collection = SubcommandLoader.getInstance().getAllDefinitions();
        if (string != null) {
            for (ISubcommandDefinition iSubcommandDefinition : collection) {
                if (!string.equals(iSubcommandDefinition.getId())) continue;
                return iSubcommandDefinition;
            }
        }
        throw (Throwable)new IllegalArgumentException(NLS.bind((String)Messages.SubcommandDefinition_11, (Object)string));
    }

    public boolean isParent() {
        return this.ext.getAttribute("class") == null;
    }

    public Collection getChildren() {
        if (!this.isParent()) {
            throw (Throwable)new IllegalArgumentException(Messages.SubcommandDefinition_13);
        }
        return SubcommandLoader.getInstance().getChildSubcommands(this);
    }

    public boolean showInHelpListing() {
        return this.ext.getAttribute("hideFromHelp") == null;
    }

    private void verifyArg(ICommandLine iCommandLine) throws FileSystemClientException {
        SubcommandDefinition$$Cold.verifyArg(this, iCommandLine);
    }

    public String[] getAliases() {
        String string = this.getAttr("aliases", false);
        if (string == null) {
            return new String[0];
        }
        return string.split("\\s+");
    }

    public List getAncestors() throws  {
        return SubcommandDefinition$$Cold.getAncestors(this);
    }

    public ISubcommandDefinition getChild(String string) throws  {
        return SubcommandDefinition$$Cold.getChild(this, string);
    }
}

