/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.internal;

import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.internal.Application;
import com.ibm.team.filesystem.cli.core.internal.ClientConfiguration$$Cold;
import com.ibm.team.filesystem.cli.core.internal.ClientConfiguration$ShowPolicy;
import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.RepositoryRegistry;
import com.ibm.team.filesystem.cli.core.internal.SubcommandLoader;
import com.ibm.team.filesystem.cli.core.internal.aliases.UuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.subcommands.IApplicationEndListener;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IRepositoryRecord;
import com.ibm.team.filesystem.cli.core.subcommands.IRepositoryRegistry;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil$IAliasOptions;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.PromptUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemClientException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;

public class ClientConfiguration
implements IClientConfiguration,
AliasUtil$IAliasOptions {
    private final IApplicationContext context;
    private final ICommandLine args;
    private final List parents;
    private final ICommandLine subargs;
    private final RepositoryRegistry repoReg;
    private final UuidAliasRegistry aliasReg;
    private final boolean isDryRun;
    private final File cfaRoot;
    private final File cwd;
    private List endListeners;
    private final ISubcommandDefinition defn;
    private ClientConfiguration$ShowPolicy showAlias;
    private ClientConfiguration$ShowPolicy showUuids;

    public static String getDefaultConfigDirectory() {
        return String.valueOf(System.getProperty("user.home")) + File.separator + ".jazz-scm";
    }

    public ClientConfiguration(IApplicationContext iApplicationContext, ISubcommandDefinition iSubcommandDefinition, File file, File file2, List list, ICommandLine iCommandLine, ICommandLine iCommandLine2) {
        this.context = iApplicationContext;
        this.defn = iSubcommandDefinition;
        this.cfaRoot = file;
        this.cwd = file2;
        this.args = iCommandLine;
        this.subargs = iCommandLine2;
        this.parents = list;
        this.endListeners = new LinkedList();
        File file3 = null;
        String string = ClientConfiguration.getDefaultConfigDirectory();
        if (iCommandLine != null) {
            string = iCommandLine.getOption(Application.OPT_CONFIG_LOCATION, string);
        }
        file3 = new File(string);
        this.repoReg = new RepositoryRegistry(new File(file3, "repositories"));
        this.aliasReg = new UuidAliasRegistry(new File(file3, "aliases"), 1000);
        this.isDryRun = iCommandLine == null || iCommandLine.hasOption(Application.OPT_DRY_RUN);
    }

    public File getEclipseWorkspaceRoot() {
        return this.cfaRoot;
    }

    public File getCurrentWorkingDirectory() {
        return this.cwd;
    }

    public Collection getSubcommandDefinitions() {
        return SubcommandLoader.getInstance().getAllDefinitions();
    }

    public ISubcommandDefinition getSubcommandDefinition() {
        return this.defn;
    }

    public IApplicationContext getApplicationContext() {
        return this.context;
    }

    public ICommandLine getSubcommandCommandLine() {
        return this.subargs;
    }

    public IRepositoryRegistry getRepositoryRegistry() {
        return this.repoReg;
    }

    public IUuidAliasRegistry getAliasRegistry() {
        return this.aliasReg;
    }

    public boolean isDryRun() {
        return this.isDryRun;
    }

    public ICommandLine getCommandLine() {
        return this.args;
    }

    public List getParents() {
        return this.parents;
    }

    public void addApplicationEndListener(IApplicationEndListener iApplicationEndListener) {
        this.endListeners.add(iApplicationEndListener);
    }

    public void deallocate() {
        for (IApplicationEndListener iApplicationEndListener : this.endListeners) {
            iApplicationEndListener.run();
        }
        this.aliasReg.shutdown();
    }

    void setShowUuids(ClientConfiguration$ShowPolicy showPolicy) {
        this.showUuids = showPolicy;
    }

    void setShowAliases(ClientConfiguration$ShowPolicy showPolicy) {
        this.showAlias = showPolicy;
    }

    public AliasUtil$IAliasOptions getAliasConfig() {
        return this;
    }

    public IClientConfiguration getClientConfiguration() {
        return this;
    }

    public boolean showAlias() {
        return this.showAlias == ClientConfiguration$ShowPolicy.ALWAYS;
    }

    public boolean showUuid() {
        return this.showUuids == ClientConfiguration$ShowPolicy.ALWAYS;
    }

    public ConnectionInfo getConnectionInfo(String string, IOptionKey iOptionKey, IOptionKey iOptionKey2, IOptionKey iOptionKey3) throws FileSystemClientException {
        IRepositoryRecord iRepositoryRecord = null;
        String string2 = string;
        if (iOptionKey != null && this.subargs.hasOption(iOptionKey)) {
            string2 = this.subargs.getOption(iOptionKey);
        }
        if (string2 == null) {
            throw (Throwable)StatusHelper.argSyntax(Messages.ClientConfiguration_0);
        }
        Object object = this.getRepositoryRegistry();
        iRepositoryRecord = object.getRecordByURL(string2);
        if (iRepositoryRecord == null && (iRepositoryRecord = object.getRecordByNickname(string2)) != null) {
            string2 = iRepositoryRecord.getUrl();
        }
        object = null;
        object = iOptionKey2 != null && this.subargs.hasOption(iOptionKey2) ? this.subargs.getOption(iOptionKey2) : (iRepositoryRecord == null ? System.getProperty("user.name") : iRepositoryRecord.getUsername());
        if (object == null && this.mayInteract()) {
            try {
                object = PromptUtil.prompt(NLS.bind((String)Messages.ClientConfiguration_1, (Object)string2), true);
            }
            catch (IOException iOException) {
                throw (Throwable)StatusHelper.failure(Messages.ClientConfiguration_2, iOException);
            }
        }
        if (object == null) {
            throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.ClientConfiguration_3, (Object)string2));
        }
        String string3 = null;
        if (iOptionKey3 != null && this.subargs.hasOption(iOptionKey3)) {
            string3 = this.subargs.getOption(iOptionKey3);
        } else if (iRepositoryRecord != null) {
            string3 = iRepositoryRecord.getPassword();
        }
        if (string3 == null && this.mayInteract()) {
            try {
                string3 = PromptUtil.prompt(NLS.bind((String)Messages.ClientConfiguration_4, (Object)object, (Object)string2), false);
            }
            catch (IOException iOException) {
                throw (Throwable)StatusHelper.failure(Messages.ClientConfiguration_2, iOException);
            }
        }
        if (string3 == null) {
            throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.ClientConfiguration_6, (Object)string2));
        }
        return new ConnectionInfo(string2, (String)object, string3);
    }

    public ConnectionInfo getConnectionInfo() throws FileSystemClientException {
        return ClientConfiguration$$Cold.getConnectionInfo(this);
    }

    public ConnectionInfo getConnectionInfo(String string) throws FileSystemClientException {
        return ClientConfiguration$$Cold.getConnectionInfo(this, string);
    }

    public boolean mayInteract() {
        return !this.args.hasOption(Application.OPT_DISALLOW_INTERACTION);
    }
}

