/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.cliparser;

import com.ibm.team.filesystem.cli.core.cliparser.INamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.NamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.Options$HelpPair;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.internal.Messages;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class Options {
    private final boolean stopOnUnknownValue;
    LinkedList positionalOptions = new LinkedList();
    List namedOptions = new LinkedList();
    String longHelp = null;
    public static final int ARG_INFINITE = -1;
    private List optionHelp = new LinkedList();

    public Options(boolean bl) {
        this.stopOnUnknownValue = bl;
    }

    public Options addOption(IOptionKey iOptionKey, String string, String string2, String string3, int n) throws ConflictingOptionException {
        NamedOptionDefinition namedOptionDefinition = new NamedOptionDefinition(iOptionKey, string, string2, n);
        return this.addOption(namedOptionDefinition, string3);
    }

    public boolean hasOption(IOptionKey iOptionKey) {
        return this.getOption(iOptionKey) != null;
    }

    public IOptionDefinition getOption(IOptionKey iOptionKey) {
        for (IOptionDefinition iOptionDefinition : this.namedOptions) {
            if (!iOptionKey.equals(iOptionDefinition.getId())) continue;
            return iOptionDefinition;
        }
        for (IOptionDefinition iOptionDefinition : this.positionalOptions) {
            if (!iOptionKey.equals(iOptionDefinition.getId())) continue;
            return iOptionDefinition;
        }
        return null;
    }

    public LinkedList getPositionalOptions() {
        return this.positionalOptions;
    }

    public Options addOption(IPositionalOptionDefinition iPositionalOptionDefinition, String string) throws ConflictingOptionException {
        if (this.positionalOptionsAreInfinite()) {
            IPositionalOptionDefinition iPositionalOptionDefinition2 = (IPositionalOptionDefinition)this.positionalOptions.getLast();
            throw (Throwable)new IllegalArgumentException(NLS.bind((String)Messages.Options_0, (Object)iPositionalOptionDefinition2.getId().toString()));
        }
        this.ensureNonConflicting(iPositionalOptionDefinition);
        this.positionalOptions.add(iPositionalOptionDefinition);
        this.optionHelp.add(new Options$HelpPair(iPositionalOptionDefinition.getId(), string));
        return this;
    }

    public boolean positionalOptionsAreInfinite() {
        if (this.positionalOptions.size() > 0) {
            IPositionalOptionDefinition iPositionalOptionDefinition = (IPositionalOptionDefinition)this.positionalOptions.getLast();
            return iPositionalOptionDefinition.getMaxCount() == -1;
        }
        return false;
    }

    public Options addOption(INamedOptionDefinition iNamedOptionDefinition, String string) throws ConflictingOptionException {
        if (iNamedOptionDefinition.getId() == null) {
            throw (Throwable)new IllegalArgumentException(Messages.Options_1);
        }
        this.ensureNonConflicting(iNamedOptionDefinition);
        this.namedOptions.add(iNamedOptionDefinition);
        this.optionHelp.add(new Options$HelpPair(iNamedOptionDefinition.getId(), string));
        return this;
    }

    private void ensureNonConflicting(IOptionDefinition iOptionDefinition) throws ConflictingOptionException {
        if (this.hasOption(iOptionDefinition.getId())) {
            throw (Throwable)new ConflictingOptionException(iOptionDefinition, null, "id", iOptionDefinition.getId().toString());
        }
        for (IOptionDefinition iOptionDefinition2 : this.namedOptions) {
            if (!iOptionDefinition2.getName().equals(iOptionDefinition.getName())) continue;
            throw (Throwable)new ConflictingOptionException(iOptionDefinition, iOptionDefinition2, "name", iOptionDefinition2.getName());
        }
        for (IOptionDefinition iOptionDefinition2 : this.positionalOptions) {
            if (!iOptionDefinition2.getName().equals(iOptionDefinition.getName())) continue;
            throw (Throwable)new ConflictingOptionException(iOptionDefinition, iOptionDefinition2, "name", iOptionDefinition2.getName());
        }
        if (iOptionDefinition instanceof INamedOptionDefinition) {
            IOptionDefinition iOptionDefinition2;
            iOptionDefinition2 = (INamedOptionDefinition)iOptionDefinition;
            for (Object object : this.namedOptions) {
                String string = object.getShortOpt();
                if (string != null && string.equals(iOptionDefinition2.getShortOpt())) {
                    throw (Throwable)new ConflictingOptionException(iOptionDefinition, (IOptionDefinition)object, "shortOpt", object.getShortOpt());
                }
                String string2 = object.getLongOpt();
                if (string2 == null || !string2.equals(iOptionDefinition2.getLongOpt())) continue;
                throw (Throwable)new ConflictingOptionException(iOptionDefinition, (IOptionDefinition)object, "longOpt", object.getLongOpt());
            }
        }
    }

    public List getNamedOptions() {
        return this.namedOptions;
    }

    public boolean shouldStopOnUnknownValue() {
        return this.stopOnUnknownValue;
    }

    public void setLongHelp(String string) {
        this.longHelp = string;
    }

    public String getLongHelp() {
        return this.longHelp;
    }

    public String getHelpFor(IOptionKey iOptionKey) {
        for (Options$HelpPair options$HelpPair : this.optionHelp) {
            if (options$HelpPair.key != iOptionKey) continue;
            return options$HelpPair.help;
        }
        throw (Throwable)new IllegalArgumentException(Messages.Options_2);
    }
}

