/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.operations;

import com.ibm.rational.wvcm.factory.PluginProviderFactory;
import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoStream;
import com.ibm.team.connector.scm.operations.BuildResultUpdater;
import com.ibm.team.connector.scm.operations.Messages;
import com.ibm.team.connector.scm.operations.TaskDetailedFeedback;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.interop.client.IInteropManager;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.ILink;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.repository.client.ILicenseClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IWorkItemCommon;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.wvcm.Feedback;
import javax.wvcm.Location;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.ProviderFactory;
import javax.wvcm.Resource;
import javax.wvcm.Stream;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ConnectorOps {
    public static final String UPDATE_SYNC_STREAM_LICENSE_ID = "com.ibm.team.connector.scm.cc.update-sync-stream";
    public static final String WVCM_JAZZ_PROVIDER_PATH = JzProvider.class.getName();
    private static final String EV_PREFIX = "com.ibm.team.connector.scm.operations.";
    private static final PropertyRequestItem.PropertyRequest PR_NAMES = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Resource.PATHNAME_LOCATION, Resource.DISPLAY_NAME});
    static Class<?>[] DEPENDENCIES = new Class[]{IAuditable.class, IFileSystemWorkItemManager.class, IInteropManager.class, ILinkManager.class, IProcessItemService.class, ITeamBuildClient.class, IWorkItemClient.class, IWorkItemCommon.class, ProviderFactory.class};

    public static JzProvider createJazzProvider(String repositoryURI, String userId, String password) throws Exception {
        JzProvider jazzProvider = null;
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        ValidationHelper.validateNotEmpty((String)JzProvider.IA_REPOSITORY_URI, (String)repositoryURI);
        ValidationHelper.validateNotEmpty((String)"userId", (String)userId);
        ValidationHelper.validateNotNull((String)"password", (Object)password);
        Hashtable<String, String> initArgs = new Hashtable<String, String>();
        initArgs.put(JzProvider.IA_REPOSITORY_URI, repositoryURI);
        try {
            JzProvider.doLogin((String)repositoryURI, (String)userId, (String)password);
            jazzProvider = (JzProvider)PluginProviderFactory.pluginCreateProvider((String)WVCM_JAZZ_PROVIDER_PATH, null, initArgs);
            if (jazzProvider == null) {
                System.out.println("internal warning: plugin provider factory returned null");
                jazzProvider = (JzProvider)ProviderFactory.createProvider((String)WVCM_JAZZ_PROVIDER_PATH, null, initArgs);
            }
            ValidationHelper.validateNotNull((String)"jazzProvider", (Object)jazzProvider);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return jazzProvider;
    }

    /*
     * Unable to fully structure code
     */
    public static void synchronizeStream(JzProvider jazzProvider, String syncStreamLocationString, String buildResultUuid) throws WvcmException {
        block12: {
            block13: {
                repo = jazzProvider.getRepo();
                buildResultUpdater = buildResultUuid == null ? null : new BuildResultUpdater(repo, buildResultUuid);
                f = new TaskDetailedFeedback(buildResultUpdater);
                try {
                    syncStream = ConnectorOps.getSyncStream(jazzProvider, syncStreamLocationString, (Feedback)f);
                    iStream = InteropStream.getInteropStream((Stream)syncStream, (Feedback)f);
                    if (iStream == null) {
                        throw new WvcmException(NLS.bind((String)Messages.ConnectorOps_ERROR_CANT_RESOLVE_TO_SYNC_STREAM_WITH_NAME, (Object[])new Object[]{syncStreamLocationString}), null, WvcmException.ReasonCode.NOT_FOUND);
                    }
                    actualUserId = repo.loggedInContributor().getUserId();
                    if (!actualUserId.equals(requiredUserId = (String)iStream.thisProvider().initArgs().get(JzProvider.IA_SYNC_USER_ID))) {
                        throw new WvcmException(NLS.bind((String)Messages.ConnectorOps_ERROR_CANT_SYNC_WRONG_OS_USER, (Object[])new Object[]{actualUserId, requiredUserId}), WvcmException.ReasonCode.FORBIDDEN);
                    }
                    ConnectorOps.assertLicense(jazzProvider, syncStream.getDisplayName());
                    System.out.println(ConnectorOps.getBVNMessage((JzProvider)iStream.thisProvider()));
                    System.out.println(NLS.bind((String)Messages.ConnectorOps_INFO_RUNNING_ON_HOST, (Object[])new Object[]{JzProvider.getHostname()}));
                    iStream.sync((Feedback)f);
                    testingThrownExceptions = ConnectorOps.testingThrownException("com.ibm.team.connector.scm.operations.forceSyncException");
                    if (testingThrownExceptions) {
                        try {
                            throw new WvcmException("Testing exception handling (first one)", WvcmException.ReasonCode.NOT_FOUND);
                        }
                        catch (WvcmException e) {
                            if (buildResultUpdater != null) {
                                buildResultUpdater.contributeExceptionStackTrace(e);
                            }
                            throw new WvcmException("Testing exception handling (wrapper)", null, WvcmException.ReasonCode.NOT_FOUND, (Throwable)e);
                        }
                    }
                    syncEndedWithoutConflicts = iStream.get_state().equals((Object)InteropStream.InteropStreamState.OK);
                    if (buildResultUpdater != null) {
                        buildResultUpdater.setCompletionStatus(syncEndedWithoutConflicts);
                    }
                    completionMessage = syncEndedWithoutConflicts != false ? Messages.ConnectorOps_STATUS_SYNC_COMPLETE_NO_CONFLICTS : Messages.ConnectorOps_STATUS_SYNC_COMPLETE_WITH_CONFLICTS;
                    System.out.println(completionMessage);
                    break block12;
                }
                catch (WvcmException e) {
                    if (e.getNestedExceptions() == null) {
                        ConnectorOps.processException(buildResultUpdater, e);
                        break block13;
                    }
                    var10_15 = e.getNestedExceptions();
                    var9_13 = var10_15.length;
                    var8_11 = 0;
                    ** while (var8_11 < var9_13)
                }
lbl-1000:
                // 1 sources

                {
                    ne = var10_15[var8_11];
                    ConnectorOps.processException(buildResultUpdater, ne);
                    ++var8_11;
                    continue;
                }
            }
            if (buildResultUpdater != null) {
                throw new WvcmException(Messages.ConnectorOps_ERROR_SYNC_FAILED, e.getReasonCode());
            }
            throw e;
        }
    }

    public static Stream getSyncStream(JzProvider jazzProvider, String syncStreamLocationString, Feedback f) throws WvcmException {
        Stream syncStream = ConnectorOps.lookupSyncStream(jazzProvider, syncStreamLocationString, f);
        if (syncStream == null) {
            throw new WvcmException(NLS.bind((String)Messages.ConnectorOps_ERROR_CANT_RESOLVE_TO_WVCM_STREAM_WITH_NAME, (Object[])new Object[]{syncStreamLocationString}), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return syncStream;
    }

    public static Stream lookupSyncStream(JzProvider jazzProvider, String syncStreamLocationString, Feedback f) throws WvcmException {
        ValidationHelper.validateNotEmpty((String)"syncStreamLocationString", (String)syncStreamLocationString);
        Location syncStreamLocation = jazzProvider.location(syncStreamLocationString);
        ValidationHelper.validateNotNull((String)"syncStreamLocation", (Object)syncStreamLocation);
        Stream syncStream = ConnectorOps.resolveStream(jazzProvider, syncStreamLocation, f);
        return syncStream;
    }

    private static String getBVNMessage(JzProvider provider) {
        return NLS.bind((String)Messages.ConnectorOps_SYNCHRONIZER_VERSION_NUMBER, (Object[])new Object[]{ConnectorOps.getVersionNumber(provider)});
    }

    private static String getVersionNumber(JzProvider provider) {
        String result = ConnectorOps.getBundleVersionNumber();
        if (result == null) {
            result = ConnectorOps.getVersionNumberFromInstallLocation(provider);
        }
        if (result == null) {
            return Messages.ConnectorOps_UNKNOWN;
        }
        return result;
    }

    private static String getVersionNumberFromInstallLocation(JzProvider provider) {
        String result;
        block6: {
            result = null;
            File buildId = new File(new File(provider.getInstallLocation(), "ScmConnectors"), "buildId.txt");
            try {
                if (!buildId.exists()) break block6;
                FileReader r = new FileReader(buildId);
                BufferedReader br = new BufferedReader(r);
                try {
                    result = br.readLine();
                }
                finally {
                    br.close();
                    r.close();
                }
            }
            catch (FileNotFoundException e) {
                provider.logIgnoredException("getVersionNumberFromInstallLocation", (Exception)e);
            }
            catch (IOException e) {
                provider.logIgnoredException("getVersionNumberFromInstallLocation", (Exception)e);
            }
        }
        return result;
    }

    private static String getBundleVersionNumber() {
        Bundle bundle = Platform.getBundle((String)"com.ibm.team.connector.scm.operations");
        if (bundle == null) {
            return null;
        }
        Dictionary headers = bundle.getHeaders();
        if (headers == null) {
            return null;
        }
        String bundleVersion = (String)headers.get("Bundle-Version");
        if (bundleVersion == null) {
            return null;
        }
        return bundleVersion;
    }

    private static void processException(BuildResultUpdater buildResultUpdater, Throwable e) {
        if (buildResultUpdater != null) {
            buildResultUpdater.contributeExceptionStackTrace(e);
        }
        System.err.println(NLS.bind((String)Messages.ConnectorOps_ERROR_SYNC_EXCEPTION, (Object[])new Object[]{e.getMessage()}));
        Throwable cause = e.getCause();
        while (cause != null) {
            System.err.println(NLS.bind((String)Messages.ConnectorOps_CONTINUED_ERROR_CAUSED_BY, (Object[])new Object[]{cause.getMessage()}));
            cause = cause.getCause();
        }
    }

    private static boolean testingThrownException(String triggerEvName) {
        String testingThrownExceptions = System.getProperty(triggerEvName, null);
        if (testingThrownExceptions == null) {
            testingThrownExceptions = System.getenv(triggerEvName);
        }
        return Boolean.TRUE.toString().equalsIgnoreCase(testingThrownExceptions);
    }

    private static void assertLicense(JzProvider provider, String streamName) throws WvcmException {
        ILicenseClient clientLibrary = (ILicenseClient)provider.getRepo().getClientLibrary(ILicenseClient.class);
        try {
            clientLibrary.assertLicense(UPDATE_SYNC_STREAM_LICENSE_ID, provider.getMonitor());
            boolean testingThrownExceptions = ConnectorOps.testingThrownException("com.ibm.team.connector.scm.operations.forceLicensingException");
            if (testingThrownExceptions) {
                throw new LicenseNotGrantedException("This is a test of the exception for : com.ibm.team.connector.scm.cc.update-sync-stream");
            }
        }
        catch (LicenseNotGrantedException e) {
            throw new WvcmException(NLS.bind((String)Messages.ConnectorOps_ERROR_NO_LICENSE_TO_SYNC, (Object[])new Object[]{streamName}), null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
        catch (TeamRepositoryException e) {
            throw new WvcmException(NLS.bind((String)Messages.ConnectorOps_ERROR_CANT_CHECK_LICENSE_TO_SYNC, (Object[])new Object[]{streamName}), null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public static Stream resolveStream(JzProvider provider, Location syncStreamLocation, Feedback feedback) throws WvcmException {
        SrvcFeedback sf = new SrvcFeedback(feedback);
        SrvcResource result = provider.lookup(syncStreamLocation, sf);
        if (result != null) {
            return (Stream)result.buildProxy(PR_NAMES, sf);
        }
        return JzRepoStream.lookupStreamByName((JzProvider)provider, (String)syncStreamLocation.string(), (PropertyRequestItem.PropertyRequest)PR_NAMES, (SrvcFeedback)sf);
    }

    public static int listOrUnlinkClones(JzProvider provider, boolean hasRemoveOption, boolean verbose) {
        System.out.println(ConnectorOps.getBVNMessage(provider));
        final ILinkManager linkManager = JzRepoResource.getLinkManager((JzProvider)provider);
        try {
            JzRepoResource.CountingVisitor countingVisitor = hasRemoveOption ? new JzRepoResource.CountingVisitor(verbose){

                public boolean visit(ILink cloneLink) throws WvcmException {
                    super.visit(cloneLink);
                    try {
                        linkManager.deleteLink(cloneLink, null);
                    }
                    catch (TeamRepositoryException e) {
                        throw new WvcmException(Messages.ConnectorOps_ERROR_DELETION_FAILED, null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
                    }
                    return true;
                }
            } : new JzRepoResource.CountingVisitor(verbose);
            JzRepoResource.forEachCloneLink((JzProvider)provider, (JzRepoResource.IVisitCloneLink)countingVisitor);
            int matches = countingVisitor.getMatches();
            System.out.println(NLS.bind((String)(hasRemoveOption ? Messages.ConnectorOps_INFO_REMOVED_LINKS_WITH_COUNT : Messages.ConnectorOps_INFO_CLONE_LINKS_FOUND_COUNT), (Object[])new Object[]{matches}));
            return matches;
        }
        catch (WvcmException e) {
            throw new RuntimeException(NLS.bind((String)Messages.ConnectorOps_ERROR_COMMAND_FAILED, (Object[])new Object[]{"clones"}), e);
        }
    }

    public static void checkDependencies(JzProvider provider, boolean verbose) {
        ITeamRepository repo = provider.getRepo();
        Class<?>[] classArray = DEPENDENCIES;
        int n = DEPENDENCIES.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            repo.getClientLibrary(c);
            if (verbose) {
                System.out.println(NLS.bind((String)Messages.ConnectorOps_LOADED_CLASS, (Object[])new Object[]{c.getName()}));
            }
            ++n2;
        }
        System.out.println(Messages.ConnectorOps_DEPS_OK);
    }

    public static void logout(JzProvider provider) {
        ITeamRepository repo;
        ITeamRepository iTeamRepository = repo = provider != null ? provider.getRepo() : null;
        if (repo != null) {
            repo.logout();
        }
    }
}

